/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.LogEventFormatter;
import com.ibm.log.LogNode;
import com.ibm.log.util.LogConstants;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageCatalog;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Formatter
extends LogNode
implements LogEventFormatter {
    static final long serialVersionUID = 4124205104283541665L;
    protected static final int DEFAULT_MSG_CATS = 10;
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String DEFAULT_SEPARATOR = " ";
    protected static final String INDENT = "  ";
    private boolean localizedDate = false;
    private boolean localizedTime = false;
    private transient Date date = new Date();
    private transient Date time = new Date();
    private transient FieldPosition dateField = new FieldPosition(0);
    private transient FieldPosition timeField = new FieldPosition(0);
    protected transient Hashtable msgCats = new Hashtable();
    private int maxMessageCatalogs = 10;
    private Locale locale = Locale.getDefault();
    private String localeCodes = this.locale.getDisplayName();
    private transient MessageCatalog textCat = new MessageCatalog((ResourceBundle)null);
    private final transient Object dateLock = new Object();
    private final transient Object timeLock = new Object();
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private SimpleDateFormat timeFormat = new SimpleDateFormat();
    private String separator = " ";
    protected transient String lineSep = System.getProperty("line.separator");
    private transient StringBuffer dateBuffer = new StringBuffer();
    private transient String formattedDate;
    private transient StringBuffer timeBuffer = new StringBuffer();
    private static final long MS_IN_HOUR = 3600000L;
    public static final long MS_IN_DAY = 86400000L;
    private transient boolean daylightTime;
    private transient long today = System.currentTimeMillis() / 86400000L;
    private boolean wantIso8601TimeZone = true;
    private transient String iso8601TimeZone = null;

    public Formatter() {
        this.init();
    }

    public Formatter(String name) {
        super(name);
        this.init();
    }

    private void init() {
        TimeZone tz = TimeZone.getDefault();
        this.setDateFormat(DEFAULT_DATE_FORMAT);
        this.dateFormat.setTimeZone(tz);
        this.setTimeFormat(DEFAULT_TIME_FORMAT);
        this.timeFormat.setTimeZone(tz);
        long time = System.currentTimeMillis();
        this.daylightTime = this.isDaylightTime(time);
        this.today = this.getToday(time);
        this.formattedDate = this.formatDate(time);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        if (this.localizedDate) {
            props.put("dateFormat", LogConstants.LOCALIZED_DATE_TIME);
        } else {
            props.put("dateFormat", this.getDateFormat().toPattern());
        }
        if (this.localizedTime) {
            props.put("timeFormat", LogConstants.LOCALIZED_DATE_TIME);
        } else {
            props.put("timeFormat", this.getTimeFormat().toPattern());
        }
        props.put("separator", this.getSeparator());
        props.put("maxMsgCats", Integer.toString(this.getMaxMessageCatalogs()));
        props.put("locale", this.getLocaleCodes());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("dateFormat");
        if (prop != null) {
            if (prop.equals(LogConstants.LOCALIZED_DATE_TIME)) {
                this.localizedDate = true;
                this.setDateFormat();
            } else {
                this.localizedDate = false;
                this.setDateFormat(prop);
            }
        }
        if ((prop = props.getProperty("timeFormat")) != null) {
            if (prop.equals(LogConstants.LOCALIZED_DATE_TIME)) {
                this.localizedTime = true;
                this.setTimeFormat();
            } else {
                this.localizedTime = false;
                this.setTimeFormat(prop);
            }
        }
        if ((prop = props.getProperty("separator")) != null) {
            this.setSeparator(prop);
        }
        if ((prop = props.getProperty("maxMsgCats")) != null) {
            this.setMaxMessageCatalogs(new Integer(prop));
        }
        if ((prop = props.getProperty("locale")) != null) {
            this.setLocaleCodes(prop);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setLocale");
            LogUtil.errorMsg(msg);
        }
    }

    public String getLocaleCodes() {
        return this.localeCodes;
    }

    public void setLocaleCodes(String codesName) {
        if (codesName != null) {
            this.localeCodes = codesName;
            StringTokenizer tokenizer = new StringTokenizer(codesName, "_");
            int count = tokenizer.countTokens();
            String[] names = new String[count];
            for (int i = 0; i < count; ++i) {
                names[i] = tokenizer.nextToken();
            }
            Locale newLocale = null;
            switch (count) {
                case 1: {
                    newLocale = new Locale(names[0], "");
                    break;
                }
                case 2: {
                    newLocale = new Locale(names[0], names[1]);
                    break;
                }
                case 3: {
                    newLocale = new Locale(names[0], names[1], names[2]);
                    break;
                }
            }
            if (newLocale != null) {
                this.setLocale(newLocale);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setLocaleCodes");
            LogUtil.errorMsg(msg);
        }
    }

    public int getMaxMessageCatalogs() {
        return this.maxMessageCatalogs;
    }

    public void setMaxMessageCatalogs(int cats) {
        if (cats > 0) {
            this.maxMessageCatalogs = cats;
            this.msgCats = new Hashtable(this.maxMessageCatalogs);
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(cats), this.getClass().getName() + ".setMaxMessageCatalogs");
            LogUtil.errorMsg(msg);
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String sep) {
        if (sep != null) {
            this.separator = sep;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setSeparator");
            LogUtil.errorMsg(msg);
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat() {
        try {
            DateFormat df = DateFormat.getDateInstance(3, this.getLocale());
            this.dateFormat = (SimpleDateFormat)df;
        }
        catch (Exception e) {
            this.dateFormat = new SimpleDateFormat();
            this.setDateFormat(DEFAULT_DATE_FORMAT);
        }
        this.dateFormat.setTimeZone(TimeZone.getDefault());
        this.formattedDate = this.formatDate(System.currentTimeMillis());
    }

    public void setDateFormat(SimpleDateFormat format) {
        if (format != null) {
            this.dateFormat = format;
            this.formattedDate = this.formatDate(System.currentTimeMillis());
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDateFormat(SimpleDateFormat)");
            LogUtil.errorMsg(msg);
        }
    }

    public void setDateFormat(String pattern) {
        if (pattern != null) {
            this.dateFormat.applyPattern(pattern);
            this.formattedDate = this.formatDate(System.currentTimeMillis());
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDateFormat(String)");
            LogUtil.errorMsg(msg);
        }
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat() {
        try {
            DateFormat df = DateFormat.getTimeInstance(3, this.getLocale());
            this.timeFormat = (SimpleDateFormat)df;
        }
        catch (Exception e) {
            this.timeFormat = new SimpleDateFormat();
            this.setTimeFormat(DEFAULT_TIME_FORMAT);
        }
        this.timeFormat.setTimeZone(TimeZone.getDefault());
    }

    public void setTimeFormat(SimpleDateFormat format) {
        if (format != null) {
            this.timeFormat = format;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setTimeFormat(SimpleDateFormat)");
            LogUtil.errorMsg(msg);
        }
    }

    public void setTimeFormat(String pattern) {
        if (pattern != null) {
            this.timeFormat.applyPattern(pattern);
            boolean wantIsoTimeZone = pattern.equals(DEFAULT_TIME_FORMAT);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setTimeFormat(String)");
            LogUtil.errorMsg(msg);
        }
    }

    public String getDate(long timeStamp) {
        long testDay = this.getToday(timeStamp);
        if (this.today != testDay) {
            this.today = testDay;
            this.daylightTime = this.isDaylightTime(timeStamp);
            this.formattedDate = this.formatDate(timeStamp);
        }
        return this.formattedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTime(long timeStamp) {
        Object object = this.timeLock;
        synchronized (object) {
            this.time.setTime(timeStamp);
            this.timeBuffer.setLength(0);
            StringBuffer output = this.timeFormat.format(this.time, this.timeBuffer, this.timeField);
            if (this.wantIso8601TimeZone) {
                output.append(this.getIso8601TimeZone(this.time));
            }
            return output.toString();
        }
    }

    public String getIso8601TimeZone() {
        return this.getIso8601TimeZone(new Date(System.currentTimeMillis()));
    }

    public String getIso8601TimeZone(Date now) {
        if (this.iso8601TimeZone == null) {
            TimeZone tz = this.timeFormat.getTimeZone();
            int offset = tz.getRawOffset();
            if (tz.inDaylightTime(now)) {
                GregorianCalendar cal = new GregorianCalendar(tz);
                cal.setTime(now);
                offset += cal.get(16);
            }
            int secondsEast = offset / 1000;
            int tzHoursEast = secondsEast / 3600;
            int tzMinutes = secondsEast / 60 % 60;
            if (tzMinutes < 0) {
                tzMinutes = -tzMinutes;
            }
            this.iso8601TimeZone = new DecimalFormat("+00;-00").format(tzHoursEast);
            this.iso8601TimeZone = this.iso8601TimeZone + ":";
            this.iso8601TimeZone = this.iso8601TimeZone + new DecimalFormat("00;00").format(tzMinutes);
        }
        return this.iso8601TimeZone;
    }

    public String format(LogEvent event) {
        String sep = this.getSeparator();
        StringBuffer bfr = new StringBuffer(256);
        long timeStamp = event.getTimeStamp();
        bfr.append(this.getDate(timeStamp));
        bfr.append(sep);
        bfr.append(this.getTime(timeStamp));
        bfr.append(sep);
        String attrib = event.getLoggingClass();
        if (attrib != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getLoggingMethod()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getOrganization()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getProduct()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getProductInstance()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getComponent()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getClient()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getServer()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getServerFormat()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        if ((attrib = event.getCorrelationId()) != null) {
            bfr.append(attrib);
            bfr.append(sep);
        }
        bfr.append(this.getText(event));
        return bfr.toString();
    }

    public String getHeader() {
        return null;
    }

    public String getTrailer() {
        return null;
    }

    protected String getText(LogEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        bfr.append(this.getMessage(event));
        String stackTrace = event.getStackTrace();
        if (stackTrace != null) {
            String textOrKey = event.getText();
            if (textOrKey != null) {
                bfr.append(this.lineSep);
                bfr.append(INDENT);
            }
            bfr.append(stackTrace);
        } else {
            bfr.append(this.lineSep);
        }
        return bfr.toString();
    }

    public String getMessage(LogEvent event) {
        StringBuffer bfr = new StringBuffer(256);
        String textOrKey = event.getText();
        Object[] inserts = event.getInserts();
        if (textOrKey != null) {
            bfr.append(this.textCat.formatMessage(textOrKey, inserts));
        } else {
            textOrKey = event.getMessageKey();
            if (textOrKey != null) {
                String messageFile = event.getMessageFile();
                MessageCatalog cat = this.getMessageCatalog(messageFile);
                bfr.append(cat.getMessage(textOrKey, inserts));
            }
        }
        return bfr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MessageCatalog getMessageCatalog(String catName) {
        Locale loc = this.getLocale();
        MessageCatalog cat = (MessageCatalog)this.msgCats.get(catName);
        if (cat != null) {
            if (loc.equals(cat.getLocale())) return cat;
            cat.setLocale(loc);
            return cat;
        }
        cat = new MessageCatalog(catName, loc);
        Class<Formatter> clazz = Formatter.class;
        synchronized (Formatter.class) {
            if (this.msgCats.size() >= this.getMaxMessageCatalogs()) {
                Enumeration names = this.msgCats.keys();
                String leastUsedName = (String)names.nextElement();
                int leastUsedCount = ((MessageCatalog)this.msgCats.get(leastUsedName)).getHitCount();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    int count = ((MessageCatalog)this.msgCats.get(name)).getHitCount();
                    if (count >= leastUsedCount) continue;
                    leastUsedName = name;
                    leastUsedCount = count;
                }
                this.msgCats.remove(leastUsedName);
            }
            this.msgCats.put(catName, cat);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cat;
        }
    }

    public long getToday(long currentTime) {
        int offset = TimeZone.getDefault().getRawOffset();
        if (this.daylightTime) {
            offset = (int)((long)offset + 3600000L);
        }
        return (currentTime + (long)offset) / 86400000L;
    }

    public boolean isDaylightTime(long currentTime) {
        boolean daylight = false;
        if (TimeZone.getDefault().inDaylightTime(new Date(currentTime))) {
            daylight = true;
        }
        return daylight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDate(long timeStamp) {
        Object object = this.dateLock;
        synchronized (object) {
            this.date.setTime(timeStamp);
            this.dateBuffer.setLength(0);
            StringBuffer output = this.dateFormat.format(this.date, this.dateBuffer, this.dateField);
            return output.toString();
        }
    }
}

