/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Filter;
import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class LevelFilter
extends Filter {
    static final long serialVersionUID = 7693778762172659639L;
    private Level level = Level.ALL;

    public LevelFilter() {
    }

    public LevelFilter(String name) {
        super(name);
    }

    public LevelFilter(String name, Level level) {
        super(name);
        this.setLevel(level);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("level", this.getLevel().getName());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("level");
        if (prop != null) {
            this.setLevel(Level.getLevel(prop));
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setLevel");
            LogUtil.errorMsg(msg);
        }
    }

    public boolean isLoggable(LogEvent event) {
        boolean loggable = false;
        if (event != null) {
            Level level = event.getLevel();
            loggable = level == null ? true : this.isLoggable(level);
        }
        return loggable;
    }

    public boolean isLoggable(Level level) {
        return this.isLogging() && level != null && level.getValue() >= this.getLevel().getValue();
    }

    public String toString() {
        String result = super.toString();
        return result + this.getLevel().toString();
    }
}

