/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.LevelLoggerSupport;
import com.ibm.log.LogEvent;

public class LevelLogger
extends LevelLoggerSupport {
    static final long serialVersionUID = 3448594761976746934L;

    public LevelLogger() {
    }

    public LevelLogger(String name) {
        super(name);
    }

    public void message(Level level, String key) {
        if (this.isLoggable(level)) {
            this.logMessage(level, key, this.getMessageFile(), null);
        }
    }

    public void message(Level level, String key, Object insert1) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(level, key, this.getMessageFile(), inserts);
        }
    }

    public void message(Level level, String key, Object insert1, Object insert2) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(level, key, this.getMessageFile(), inserts);
        }
    }

    public void message(Level level, String key, Object[] inserts) {
        if (this.isLoggable(level)) {
            this.logMessage(level, key, this.getMessageFile(), inserts);
        }
    }

    public void msg(Level level, String key, String file) {
        if (this.isLoggable(level)) {
            this.logMessage(level, key, file, null);
        }
    }

    public void msg(Level level, String key, String file, Object insert1) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1};
            this.logMessage(level, key, file, inserts);
        }
    }

    public void msg(Level level, String key, String file, Object insert1, Object insert2) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logMessage(level, key, file, inserts);
        }
    }

    public void msg(Level level, String key, String file, Object[] inserts) {
        if (this.isLoggable(level)) {
            this.logMessage(level, key, file, inserts);
        }
    }

    public void text(Level level, String text) {
        if (this.isLoggable(level)) {
            this.logText(level, text, null);
        }
    }

    public void text(Level level, String text, Object insert1) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(level, text, inserts);
        }
    }

    public void text(Level level, String text, Object insert1, Object insert2) {
        if (this.isLoggable(level)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(level, text, inserts);
        }
    }

    public void text(Level level, String text, Object[] inserts) {
        if (this.isLoggable(level)) {
            this.logText(level, text, inserts);
        }
    }

    public void entry(Level level) {
        if (this.isLoggable(level)) {
            this.logText(level, "Entry", null);
        }
    }

    public void entry(Level level, Object parm1) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{LevelLogger.objToStr(parm1)};
            this.logText(level, "Entry, parm 1 = {0}", parms);
        }
    }

    public void entry(Level level, Object parm1, Object parm2) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{LevelLogger.objToStr(parm1), LevelLogger.objToStr(parm2)};
            this.logText(level, "Entry, parm 1 = {0}, parm 2 = {1}", parms);
        }
    }

    public void entry(Level level, Object[] parms) {
        if (this.isLoggable(level)) {
            StringBuffer bfr = new StringBuffer("Entry");
            Object[] strs = null;
            if (parms != null) {
                strs = new String[parms.length];
                for (int j = 0; j < parms.length; ++j) {
                    bfr.append(", parm " + (j + 1) + " = {" + j + "}");
                    strs[j] = LevelLogger.objToStr(parms[j]);
                }
            }
            this.logText(level, bfr.toString(), strs);
        }
    }

    public void exit(Level level) {
        if (this.isLoggable(level)) {
            this.logText(level, "Exit", null);
        }
    }

    public void exit(Level level, byte retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, short retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Short(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, int retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, long retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Long(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, float retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Float(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, double retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Double(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, char retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Character(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, boolean retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Level level, Object retValue) {
        if (this.isLoggable(level)) {
            Object[] parms = new Object[]{LevelLogger.objToStr(retValue)};
            this.logText(level, "Exit, return value = {0}", parms);
        }
    }

    public void exception(Level level, Throwable throwable) {
        if (this.isLoggable(level)) {
            LogEvent event = new LogEvent(level, throwable);
            this.logAndWarn(event);
        }
    }

    public void exception(Level level, Throwable throwable, String text) {
        if (this.isLoggable(level)) {
            LogEvent event = new LogEvent(level, throwable, text);
            this.logAndWarn(event);
        }
    }

    protected void logMessage(Level level, String key, String file, Object[] inserts) {
        LogEvent event = new LogEvent(level, key, file, inserts);
        this.logAndWarn(event);
    }

    protected void logText(Level level, String text, Object[] inserts) {
        LogEvent event = new LogEvent(level, text, inserts);
        this.logAndWarn(event);
    }

    public String toString() {
        String result = super.toString();
        return result + ", " + this.getLevel().toString();
    }
}

