/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.LevelFilter;
import com.ibm.log.Logger;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public abstract class LevelLoggerSupport
extends Logger {
    private LevelFilter levelFilter = new LevelFilter("", Level.INFO);

    public LevelLoggerSupport() {
    }

    public LevelLoggerSupport(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("level", this.getLevel().getName());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("level");
        if (prop != null) {
            Level newLevel = Level.getLevel(prop);
            if (newLevel == null) {
                String[] parms = new String[]{prop};
                String msg = LogUtil.getLogMsg("ERR_BAD_LEVEL", parms, this.getClass().getName() + ".setConfig");
                LogUtil.errorMsg(msg);
                newLevel = Level.INFO;
            }
            this.setLevel(newLevel);
        }
    }

    public Level getLevel() {
        return this.levelFilter.getLevel();
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.levelFilter.setLevel(level);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setLevel");
            LogUtil.errorMsg(msg);
        }
    }

    public boolean isLoggable(Level level) {
        return this.isLogging() && this.levelFilter.isLoggable(level);
    }

    public String toString() {
        String result = super.toString();
        return result + ", " + this.getLevel().toString();
    }
}

