/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Level;
import com.ibm.log.LogEvent;
import com.ibm.log.MemoryHandler;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class LevelMemoryHandler
extends MemoryHandler {
    static final long serialVersionUID = 6680067691832199251L;
    private Level level = Level.ERROR;

    public LevelMemoryHandler() {
    }

    public LevelMemoryHandler(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("level", this.getLevel().getName());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("level");
        if (prop != null) {
            this.setLevel(Level.getLevel(prop));
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setLevel");
            LogUtil.errorMsg(msg);
        }
    }

    public synchronized void process(LogEvent event) {
        if (event != null) {
            if (this.convertExceptions) {
                event.convertException();
            }
            this.queue.enqueue(event);
            Level level = event.getLevel();
            if (!level.equals(Level.OFF) && level.getValue() >= this.getLevel().getValue()) {
                this.close();
            }
        }
    }

    public String toString() {
        String result = super.toString();
        return result + ", level=" + this.getLevel();
    }
}

