/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.LogEventListener;
import com.ibm.log.LogEventProducer;
import com.ibm.log.LogNode;
import com.ibm.log.util.LogUtil;
import java.util.Properties;
import java.util.Vector;

public abstract class LogEventProducerImpl
extends LogNode
implements LogEventProducer {
    private transient boolean listenerWarningSent = false;
    private boolean logging = true;
    protected int listenerCount = 0;
    protected transient long loggedEventCount = 0L;
    private Object listenerSync = new Object();
    private String listenerNames = "";
    private Vector listeners = new Vector();
    private LogEventListener[] cachedListeners = new LogEventListener[0];

    public LogEventProducerImpl() {
    }

    public LogEventProducerImpl(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object clone() {
        LogEventProducerImpl obj = (LogEventProducerImpl)super.clone();
        Object object = this.listenerSync;
        synchronized (object) {
            obj.listeners = (Vector)this.listeners.clone();
            obj.cachedListeners = this.listeners.toArray(new LogEventListener[0]);
        }
        return obj;
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("logging", new Boolean(this.logging).toString());
        if (!this.listenerNames.equals("")) {
            props.put("listenerNames", this.listenerNames);
        }
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("logging");
        if (prop != null) {
            this.setLogging(new Boolean(prop));
        }
        if ((prop = props.getProperty("listenerNames")) != null) {
            this.listenerNames = prop;
        }
    }

    public final boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean flag) {
        this.logging = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEventListener(LogEventListener listener) {
        if (listener != null) {
            Object object = this.listenerSync;
            synchronized (object) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                    ++this.listenerCount;
                    this.cachedListeners = this.listeners.toArray(new LogEventListener[0]);
                }
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".addLogEventListener");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeLogEventListener(LogEventListener listener) {
        if (listener != null) {
            Object object = this.listenerSync;
            synchronized (object) {
                if (this.listeners.contains(listener)) {
                    this.listeners.remove(listener);
                    --this.listenerCount;
                    this.cachedListeners = this.listeners.toArray(new LogEventListener[0]);
                }
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".removeLogEventListener");
            LogUtil.errorMsg(msg);
        }
    }

    public LogEventListener[] getLogEventListeners() {
        return this.cachedListeners;
    }

    public void log(LogEvent event) {
        if (event != null && this.listenerCount > 0) {
            ++this.loggedEventCount;
            LogEventListener[] listeners = this.getLogEventListeners();
            if (listeners != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    LogEventListener l = listeners[i];
                    l.process(event);
                }
            }
        }
    }

    protected void logAndWarn(LogEvent event) {
        if (event != null) {
            if (this.listenerCount > 0) {
                ++this.loggedEventCount;
                this.listenerWarningSent = false;
                LogEventListener[] listeners = this.getLogEventListeners();
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; ++i) {
                        LogEventListener l = listeners[i];
                        l.process(event);
                    }
                }
            } else if (!this.listenerWarningSent) {
                this.listenerWarningSent = true;
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_NO_LISTENERS", this.getName()));
            }
        }
    }

    public String toString() {
        String result = super.toString();
        return result + ", isLogging=" + this.isLogging() + ", loggedEvents=" + this.loggedEventCount;
    }
}

