/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogComponent;
import com.ibm.log.util.LogUtil;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public abstract class LogNode
implements Cloneable,
LogComponent {
    private String description = "";
    private String descriptionFile = "";
    private String descriptionKey = "";
    private String name = "";

    public LogNode() {
    }

    public LogNode(String name) {
        this.setName(name);
    }

    public synchronized Object clone() {
        try {
            LogNode obj = (LogNode)super.clone();
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Properties getConfig() {
        Properties props = new Properties();
        if (!this.getName().equals("")) {
            props.put("name", this.getName());
        }
        if (!this.getDescription().equals("")) {
            props.put("description", this.getDescription());
        }
        if (!this.getDescriptionFile().equals("")) {
            props.put("descriptionFile", this.getDescriptionFile());
        }
        if (!this.getDescriptionKey().equals("")) {
            props.put("descriptionKey", this.getDescriptionKey());
        }
        props.put("className", this.getClass().getName());
        return props;
    }

    public void setConfig(Properties props) {
        String prop = props.getProperty("name");
        if (prop != null) {
            this.setName(prop);
        }
        if ((prop = props.getProperty("description")) != null) {
            this.setDescription(prop);
        }
        if ((prop = props.getProperty("descriptionFile")) != null) {
            this.setDescriptionFile(prop);
        }
        if ((prop = props.getProperty("descriptionKey")) != null) {
            this.setDescriptionKey(prop);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setName");
            LogUtil.errorMsg(msg);
        }
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        String desc = this.description;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.getDescriptionFile() != null && this.getDescriptionKey() != null) {
            try {
                String descFile = this.getDescriptionFile();
                ClassLoader cl = LogUtil.getClassLoaderForResource(descFile);
                ResourceBundle msgBundle = cl == null ? ResourceBundle.getBundle(descFile, locale) : ResourceBundle.getBundle(descFile, locale, cl);
                desc = msgBundle.getString(this.getDescriptionKey());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return desc;
    }

    public void setDescription(String desc) {
        if (desc != null) {
            this.description = desc;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDescription");
            LogUtil.errorMsg(msg);
        }
    }

    public void setDescription(String key, String file) {
        if (key != null && file != null) {
            this.setDescriptionKey(key);
            this.setDescriptionFile(file);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".set");
            LogUtil.errorMsg(msg);
        }
    }

    public String getDescriptionFile() {
        return this.descriptionFile;
    }

    public void setDescriptionFile(String descFile) {
        if (descFile != null) {
            this.descriptionFile = descFile;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDescriptionFile");
            LogUtil.errorMsg(msg);
        }
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescriptionKey(String descKey) {
        if (descKey != null) {
            this.descriptionKey = descKey;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDescriptionKey");
            LogUtil.errorMsg(msg);
        }
    }

    public String toString() {
        String name = this.getName();
        if (name.equals("")) {
            name = "(none)";
        }
        return "name=" + name + ", class=" + this.getClass().getName();
    }
}

