/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.util.LinkedList;
import java.util.Properties;

public class ThreadHandler
extends Handler
implements Runnable {
    static final long serialVersionUID = 8709102387974828892L;
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    private transient boolean daemon = false;
    private transient boolean finished = false;
    private transient boolean stopRequested = false;
    private int capacity = 10000;
    private transient int discardedEventCount = 0;
    protected transient Object queueEmptyLock = new Object();
    protected transient Object queueFullLock = new Object();
    private transient LinkedList queue = new LinkedList();
    protected transient Thread myThread = null;

    public ThreadHandler() {
    }

    public ThreadHandler(String name) {
        super(name);
    }

    public ThreadHandler(String name, boolean daemon) {
        super(name);
        this.daemon = daemon;
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("queueCapacity", new Integer(this.getQueueCapacity()).toString());
        props.put("daemon", new Boolean(this.daemon).toString());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("queueCapacity");
        if (prop != null) {
            this.setQueueCapacity(new Integer(prop));
        }
        if ((prop = props.getProperty("daemon")) != null) {
            this.setDaemon(new Boolean(prop));
        }
    }

    public Thread getThread() {
        return this.myThread;
    }

    public int getQueueCount() {
        return this.queue.size();
    }

    public int getQueueCapacity() {
        return this.capacity;
    }

    public void setQueueCapacity(int size) {
        if (size >= 0) {
            this.capacity = size;
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(size), this.getClass().getName() + ".setQueueCapacity");
            LogUtil.errorMsg(msg);
        }
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean flag) {
        this.daemon = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                String threadName = this.getClass().getName() + ":" + this.getName();
                this.myThread = new Thread((Runnable)this, threadName);
                if (this.isDaemon()) {
                    this.myThread.setDaemon(true);
                } else {
                    this.myThread.setDaemon(false);
                }
                this.myThread.start();
                this.open = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        while (!this.finished) {
            LogEvent event;
            object = this.queueEmptyLock;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    event = null;
                    if (this.stopRequested) {
                        this.finished = true;
                    } else {
                        try {
                            this.queueEmptyLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    event = (LogEvent)this.queue.removeFirst();
                }
            }
            if (event == null) continue;
            object = this.queueFullLock;
            synchronized (object) {
                this.queueFullLock.notifyAll();
            }
            this.log(event);
            if (this.discardedEventCount == 0) continue;
            if (this.discardedEventCount == 1) {
                LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_1", this.getName()));
            } else {
                LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_2", this.getName(), new Integer(this.discardedEventCount)));
            }
            this.discardedEventCount = 0;
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            this.queueEmptyLock.notify();
        }
        object = this.deviceLock;
        synchronized (object) {
            this.myThread = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.queueEmptyLock;
        synchronized (object) {
            this.stopRequested = true;
            this.queueEmptyLock.notify();
        }
        object = this.queueEmptyLock;
        synchronized (object) {
            while (this.open) {
                try {
                    this.queueEmptyLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(LogEvent event) {
        if (event != null && !this.stopRequested) {
            if (!this.open) {
                try {
                    this.open();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            boolean done = false;
            while (!done) {
                Object object;
                if (this.queue.size() < this.getQueueCapacity()) {
                    object = this.queueEmptyLock;
                    synchronized (object) {
                        this.queue.addLast(event);
                        this.queueEmptyLock.notify();
                    }
                    done = true;
                    continue;
                }
                if (!Thread.currentThread().equals(this.myThread)) {
                    object = this.queueFullLock;
                    synchronized (object) {
                        try {
                            this.queueFullLock.wait();
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (this.discardedEventCount == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_QUEUE_FULL", this.getName()));
                }
                ++this.discardedEventCount;
                done = true;
            }
        }
    }

    public void write(LogEvent event) throws Exception {
    }
}

