/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;

public class ZosConsoleHandler
extends Handler {
    private static final String SYSPROP_OSNAME = "os.name";
    private static final String OS_NAME_ZOS = "z/OS";
    private static final String OS_NAME_OS390 = "OS/390";
    private static final String SYSPROP_OSARCH = "os.name";
    private static final String OS_ARCH_390 = "390";
    private static final String OS_ARCH_390X = "390x";
    private static final String IBM_VM_BITMODE = "com.ibm.vm.bitmode";
    private static final String VM_BITMODE_32 = "32";
    private static final String VM_BITMODE_64 = "64";
    static boolean initialized = false;

    public ZosConsoleHandler() throws Exception {
        if (!initialized) {
            throw new Exception(this.getClass().getName() + " is only supported on " + OS_ARCH_390 + " architecture.");
        }
    }

    public ZosConsoleHandler(String name) throws Exception {
        super(name);
        if (!initialized) {
            throw new Exception(this.getClass().getName() + " is only supported on " + OS_ARCH_390 + " architecture.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open = true;
                this.writeHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.open) {
                try {
                    this.writeTrailer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent event) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            ZosConsoleHandler.zosWTO(this.getFormatter().format(event));
        }
    }

    protected void writeHeader() throws Exception {
        String header = this.getFormatter().getHeader();
        if (header != null) {
            ZosConsoleHandler.zosWTO(header);
        }
    }

    protected void writeTrailer() throws Exception {
        String trailer = this.getFormatter().getTrailer();
        if (trailer != null) {
            ZosConsoleHandler.zosWTO(trailer);
        }
    }

    private static native void zosWTO(String var0) throws Exception;

    static {
        String osName = System.getProperty("os.name");
        String vmMode = System.getProperty(IBM_VM_BITMODE);
        if (OS_NAME_OS390.equals(osName) || OS_NAME_ZOS.equals(osName)) {
            if (VM_BITMODE_64.equals(vmMode)) {
                System.loadLibrary("JLOG_64");
                initialized = true;
            } else {
                System.loadLibrary("JLOG");
                initialized = true;
            }
        }
    }
}

