/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Channel {
    public static final String ENCODING_UTF8 = "UTF-8";
    private InputStream socketIn = null;
    private OutputStream socketOut = null;
    private Socket socket;

    public Channel(Socket socket) {
        this.socket = socket;
    }

    public void open() throws IOException {
        this.socketIn = this.socket.getInputStream();
        this.socketOut = this.socket.getOutputStream();
    }

    public void close() {
        try {
            this.socketIn.close();
            this.socketOut.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String read() throws IOException {
        int c;
        byte[] buffer = new byte[50];
        int length = 0;
        while ((c = this.socketIn.read()) > 0) {
            if (length == buffer.length) {
                byte[] newBuffer = new byte[buffer.length * 2];
                System.arraycopy(buffer, 0, newBuffer, 0, length);
                buffer = newBuffer;
            }
            buffer[length++] = (byte)c;
        }
        return new String(buffer, 0, length, ENCODING_UTF8);
    }

    public void write(String msg) throws IOException {
        msg = msg + "\u0000";
        this.socketOut.write(msg.getBytes(ENCODING_UTF8));
    }
}

