/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.cmd;

import com.ibm.log.cmd.CommandServer;
import com.ibm.log.cmd.LogCmdProcessor;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class LogCmdServer
implements CommandServer,
Runnable {
    public static final int DEFAULT_PORT = 9992;
    public static final int RC_OK = 0;
    public static final int RC_ERROR = 1;
    public static final String CTRL_MSG_CMD = "Cmd:";
    public static final String CTRL_MSG_RC = "RC:";
    public static final String CTRL_MSG_STDERR = "Stderr:";
    public static final String CTRL_MSG_STDOUT = "Stdout:";
    public static final String LOG_CMD_CONFIG = "config";
    public static final String LOG_CMD_DUMP = "dump";
    public static final String LOG_CMD_HELP = "help";
    public static final String LOG_CMD_LIST = "list";
    public static final String LOG_CMD_REMOVE = "remove";
    public static final String LOG_CMD_SAVE = "save";
    public static final String LOG_CMD_SAVE_OPT_ALL = "all";
    public static final String LOG_CMD_SET = "set";
    public static final String OPTION_HELP = "-h";
    private boolean started = false;
    private boolean stopRequested = false;
    private int serverPort = 9992;
    private ServerSocket serverSocket = null;

    public LogCmdServer() {
        this(9992);
    }

    public LogCmdServer(int port) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        final int forPort = port;
        if (sm == null) {
            this.obtainServerSocket(forPort);
        } else {
            sm.checkListen(forPort);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        LogCmdServer.this.obtainServerSocket(forPort);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                pae.getException().printStackTrace(System.err);
            }
        }
    }

    private void obtainServerSocket(int port) {
        int startAt;
        ServerSocket ss = null;
        InetAddress loopback = null;
        try {
            loopback = InetAddress.getByName(null);
        }
        catch (UnknownHostException exNoHost) {
            String msg = LogUtil.getLogMsg("ERR_LOCALHOST_CMD_SOCKET");
            LogUtil.errorMsg(msg);
            return;
        }
        if (port != 0) {
            try {
                this.serverSocket = ss = new ServerSocket(port, 64, loopback);
                this.serverPort = port;
            }
            catch (IOException ioex) {
                Object[] msgArgs = new Object[]{new Integer(port)};
                String msg = LogUtil.getLogMsg("ERR_PORT_IN_USE", msgArgs);
                LogUtil.errorMsg(msg);
            }
            return;
        }
        boolean triedAllPorts = false;
        int tryPort = 0;
        int i = startAt = (int)(System.currentTimeMillis() % 16384L);
        while (ss == null && !triedAllPorts) {
            try {
                tryPort = 49152 + i;
                ss = new ServerSocket(tryPort, 64, loopback);
            }
            catch (IOException ioex) {
                ss = null;
                if ((i = (i + 1) % 16384) != startAt) continue;
                triedAllPorts = true;
            }
        }
        if (ss != null) {
            this.serverSocket = ss;
            this.serverPort = tryPort;
        } else {
            Object[] msgArgs = new Object[]{"49152-65535"};
            String msg = LogUtil.getLogMsg("ERR_PORT_IN_USE", msgArgs);
            LogUtil.errorMsg(msg);
        }
    }

    public synchronized void start() {
        Thread cmdThread = new Thread((Runnable)this, this.getClass().getName());
        cmdThread.setDaemon(true);
        cmdThread.start();
        this.started = true;
    }

    public void run() {
        if (this.serverSocket == null) {
            this.started = false;
            return;
        }
        try {
            this.serverSocket.setSoTimeout(1000);
        }
        catch (SocketException stex) {
            stex.printStackTrace(System.err);
        }
        SecurityManager sm = System.getSecurityManager();
        while (!this.stopRequested) {
            try {
                Socket socket;
                final ServerSocket sSocket = this.serverSocket;
                if (sm == null) {
                    socket = sSocket.accept();
                } else {
                    try {
                        socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return sSocket.accept();
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw (IOException)pae.getException();
                    }
                }
                Thread thread = new Thread(new LogCmdProcessor(socket));
                thread.start();
            }
            catch (InterruptedIOException intrex) {
            }
            catch (SocketException sockintrex) {
            }
            catch (IOException ioex) {
                ioex.printStackTrace(System.err);
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
        }
        this.started = false;
    }

    public synchronized void stop() {
        this.stopRequested = true;
        while (this.started) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getPort() {
        return this.serverPort;
    }
}

