/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.Handler;
import com.ibm.log.LogComponent;
import com.ibm.log.LogEventFormatter;
import com.ibm.log.LogEventListener;
import com.ibm.log.LogEventProducer;
import com.ibm.log.cmd.CommandServer;
import com.ibm.log.cmd.LogCmdServer;
import com.ibm.log.mgr.ConfigChangeEvent;
import com.ibm.log.mgr.ConfigChangeListener;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.LogManagerConfig;
import com.ibm.log.mgr.LogPermission;
import com.ibm.log.util.ErrorProtocol;
import com.ibm.log.util.LogUtil;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class LogManager
implements ConfigChangeListener {
    protected static final Object mgrLock = new Object();
    protected static final Object objLock = new Object();
    protected CommandServer commandServer = null;
    private DataStore dataStore = null;
    protected Hashtable fullConfig = new Hashtable();
    protected static LogManager mgr = null;
    private boolean sysPropNoLogCmdServer = false;
    private boolean factoryNoLogCmdServer = false;
    private String port;
    private boolean cfgPermission = false;

    protected static final void verifyLogConfigPermission() throws AccessControlException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LogPermission("config", null));
        }
    }

    protected final boolean hasLogConfigPermission() {
        return this.cfgPermission;
    }

    public static LogManager getManager() {
        return LogManager.getManager(null, true);
    }

    public static LogManager getManager(boolean cmdServer) {
        return LogManager.getManager(null, cmdServer);
    }

    public static LogManager getManager(DataStore store) {
        return LogManager.getManager(store, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogManager getManager(DataStore store, boolean cmdServer) {
        Object object = mgrLock;
        synchronized (object) {
            if (mgr == null) {
                mgr = new LogManager(store, cmdServer);
            } else {
                LogManager.verifyLogConfigPermission();
            }
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogManager getManagerWithMergedDataStore(DataStore store, boolean cmdServer) {
        Object object = mgrLock;
        synchronized (object) {
            if (mgr == null) {
                mgr = new LogManager(store, cmdServer);
            } else {
                LogManager.verifyLogConfigPermission();
                DataStore oldStore = mgr.getDataStore();
                if (oldStore == null) {
                    mgr.setDataStore(store);
                } else if (store != null) {
                    Enumeration cfgs = store.getConfig();
                    DataStoreConfig nextCfg = null;
                    String nextCfgName = null;
                    while (cfgs.hasMoreElements()) {
                        nextCfg = (DataStoreConfig)cfgs.nextElement();
                        nextCfgName = nextCfg.getProperty("name");
                        if (oldStore.containsConfig(nextCfgName)) {
                            if (nextCfgName.equals("/")) continue;
                            String msg = LogUtil.getLogMsg("WARN_CFG_NOT_MERGED", nextCfgName);
                            LogUtil.errorMsg(msg);
                            continue;
                        }
                        oldStore.addConfig(nextCfg);
                    }
                }
            }
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteManager() {
        LogManager.verifyLogConfigPermission();
        Object object = mgrLock;
        synchronized (object) {
            if (mgr != null) {
                mgr.stopCommandServer();
                mgr = null;
            }
        }
    }

    protected LogManager() throws AccessControlException {
        LogManager.verifyLogConfigPermission();
        this.cfgPermission = true;
    }

    protected LogManager(DataStore store, boolean cmdServer) throws AccessControlException {
        LogManager.verifyLogConfigPermission();
        this.cfgPermission = true;
        boolean bl = this.factoryNoLogCmdServer = !cmdServer;
        if (store != null) {
            this.setDataStore(store);
        }
        this.startCommandServer();
    }

    protected LogManager(DataStore store) throws AccessControlException {
        this(store, true);
    }

    public DataStore getDataStore() {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore store) {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        if (store != null) {
            if (this.dataStore != null) {
                this.dataStore.removeConfigChangeListener(this);
            }
            this.dataStore = store;
            this.dataStore.addConfigChangeListener(this);
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDataStore");
            LogUtil.errorMsg(msg);
        }
    }

    public CommandServer getCommandServer() {
        return this.commandServer;
    }

    public void setCommandServer(CommandServer server) {
        if (server != null) {
            this.commandServer = server;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setCommandServer");
            LogUtil.errorMsg(msg);
        }
    }

    private void getSystemProperties() throws AccessControlException {
        SecurityManager sm;
        if (this.dataStore != null && this.dataStore.containsConfig("jlog")) {
            DataStoreConfig cfg = this.dataStore.getConfig("jlog");
            String cfgLogCmdPort = cfg.getProperty("logCmdPort");
            String cfgNoLogCmd = cfg.getProperty("noLogCmd");
            if (cfgNoLogCmd != null) {
                this.sysPropNoLogCmdServer = Boolean.valueOf(cfgNoLogCmd);
            }
            if (cfgLogCmdPort != null) {
                this.port = cfgLogCmdPort;
            }
        }
        if ((sm = System.getSecurityManager()) == null) {
            String noLogCmd = System.getProperty("jlog.noLogCmd");
            String logCmdPort = System.getProperty("jlog.logCmdPort");
            if (noLogCmd != null) {
                this.sysPropNoLogCmdServer = Boolean.valueOf(noLogCmd);
            }
            if (logCmdPort != null) {
                this.port = logCmdPort;
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String noLogCmd = System.getProperty("jlog.noLogCmd");
                    String logCmdPort = System.getProperty("jlog.logCmdPort");
                    if (noLogCmd != null) {
                        LogManager.this.sysPropNoLogCmdServer = Boolean.valueOf(noLogCmd);
                    }
                    if (logCmdPort != null) {
                        LogManager.this.port = logCmdPort;
                    }
                    return null;
                }
            });
        }
    }

    protected void startCommandServer() throws AccessControlException {
        this.getSystemProperties();
        if (!this.sysPropNoLogCmdServer && !this.factoryNoLogCmdServer) {
            SecurityManager sm;
            int portNbr = 9992;
            if (this.port != null) {
                try {
                    portNbr = Integer.parseInt(this.port);
                }
                catch (NumberFormatException e) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_CMD_SERVER_PORT", this.port));
                }
            }
            if ((sm = System.getSecurityManager()) == null) {
                this.commandServer = new LogCmdServer(portNbr);
            } else {
                final int tempPort = portNbr;
                LogCmdServer tempServer = (LogCmdServer)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new LogCmdServer(tempPort);
                    }
                });
                this.commandServer = tempServer;
            }
            this.commandServer.start();
        }
    }

    protected void stopCommandServer() {
        if (this.commandServer != null) {
            this.commandServer.stop();
        }
    }

    public LogEventProducer getLogger(String name) throws IllegalArgumentException, IllegalStateException {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        LogEventProducer logger = null;
        LogComponent comp = this.getObject(name);
        if (comp instanceof LogEventProducer) {
            logger = (LogEventProducer)comp;
        }
        return logger;
    }

    public void returnLogger(LogEventProducer logger) {
        this.returnObject(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogComponent getObject(String name) throws IllegalArgumentException, IllegalStateException {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        DataStore ds = this.getDataStore();
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException(LogUtil.getLogMsg("ERR_OBJECT_NAME"));
        }
        if (ds == null) {
            throw new IllegalStateException(LogUtil.getLogMsg("ERR_NO_DATA_STORE"));
        }
        LogComponent object = null;
        Object object2 = objLock;
        synchronized (object2) {
            DataStoreConfig props;
            LogManagerConfig mgrConfig = (LogManagerConfig)this.fullConfig.get(name);
            if (mgrConfig == null) {
                mgrConfig = new LogManagerConfig();
            }
            if ((object = mgrConfig.getObject()) == null && (props = ds.getConfig(name)) != null) {
                final String className = props.getProperty("className");
                if (className != null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm == null) {
                        object = (LogComponent)LogUtil.createObject(className);
                        if (object != null) {
                            object.setConfig(props);
                        }
                    } else {
                        try {
                            object = (LogComponent)AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    LogComponent obj = (LogComponent)LogUtil.createObject(className);
                                    if (obj != null) {
                                        obj.setConfig(props);
                                    }
                                    return obj;
                                }
                            });
                        }
                        catch (AccessControlException ace) {
                            String msg = LogUtil.getLogMsg("ERR_INVALID_PERMISSION", name, ace.getMessage());
                            LogUtil.errorMsg(msg);
                            object = null;
                        }
                    }
                    if (object != null) {
                        if (object instanceof LogEventProducer) {
                            this.addListeners((LogEventProducer)object, props);
                        }
                        if (object instanceof Handler) {
                            this.addFormatter((Handler)object, props);
                            this.addErrorProtocol((Handler)object, props);
                        }
                        mgrConfig.setObject(object);
                        this.fullConfig.put(name, mgrConfig);
                    }
                } else {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_MISSING_CLASS_NAME", name));
                }
            }
            if (object != null) {
                mgrConfig.incrementInUseCount();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(LogComponent object) {
        if (object != null) {
            Object object2 = objLock;
            synchronized (object2) {
                String name = object.getName();
                LogManagerConfig mgrConfig = (LogManagerConfig)this.fullConfig.get(name);
                if (mgrConfig != null && mgrConfig.decrementInUseCount() == 0) {
                    if (object instanceof LogEventProducer) {
                        this.removeListeners((LogEventProducer)object);
                    }
                    if (object instanceof Handler) {
                        ((Handler)object).close();
                        this.removeFormatter((Handler)object);
                        this.removeErrorProtocol((Handler)object);
                    }
                    object = null;
                    mgrConfig.setObject(null);
                    this.fullConfig.remove(name);
                }
            }
        }
    }

    protected void addListeners(LogEventProducer object, Properties props) {
        if (object != null) {
            LogEventListener listener;
            String names = props.getProperty("listenerNames");
            Vector<LogEventListener> current = new Vector<LogEventListener>();
            LogEventListener[] listeners = object.getLogEventListeners();
            if (listeners != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    current.addElement(listeners[i]);
                }
            }
            if (names != null) {
                StringTokenizer st = new StringTokenizer(names);
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    listener = (LogEventListener)this.getObject(name);
                    if (listener == null) continue;
                    if (current.contains(listener)) {
                        this.returnObject(listener);
                        current.removeElement(listener);
                        continue;
                    }
                    object.addLogEventListener(listener);
                }
            }
            Enumeration e = current.elements();
            while (e.hasMoreElements()) {
                listener = (LogEventListener)e.nextElement();
                object.removeLogEventListener(listener);
                this.returnObject(listener);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".addLogEventListeners");
            LogUtil.errorMsg(msg);
        }
    }

    protected void removeListeners(LogEventProducer object) {
        LogEventListener[] listeners = object.getLogEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.returnObject(listeners[i]);
        }
    }

    protected void addFormatter(Handler handler, Properties props) {
        if (handler != null) {
            LogEventFormatter formatter;
            String name = props.getProperty("formatterName");
            if (name != null && (formatter = (LogEventFormatter)this.getObject(name)) != null) {
                handler.setFormatter(formatter);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".addFormatter");
            LogUtil.errorMsg(msg);
        }
    }

    protected void removeFormatter(Handler handler) {
        this.returnObject(handler.getFormatter());
    }

    protected void addErrorProtocol(Handler handler, Properties props) {
        if (handler != null) {
            ErrorProtocol protocol;
            String name = props.getProperty("errorProtocolName");
            if (name != null && (protocol = (ErrorProtocol)this.getObject(name)) != null) {
                handler.setErrorProtocol(protocol);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".addErrorProtocol");
            LogUtil.errorMsg(msg);
        }
    }

    protected void removeErrorProtocol(Handler handler) {
        this.returnObject(handler.getErrorProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChange(ConfigChangeEvent event) {
        if (!this.cfgPermission) {
            throw new SecurityException();
        }
        final Properties config = event.getConfig();
        String name = config.getProperty("name");
        if (name != null) {
            Object object = objLock;
            synchronized (object) {
                LogComponent object2;
                LogManagerConfig mgrConfig = (LogManagerConfig)this.fullConfig.get(name);
                if (mgrConfig != null && (object2 = mgrConfig.getObject()) != null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm == null) {
                        object2.setConfig(config);
                    } else {
                        try {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    object2.setConfig(config);
                                    return null;
                                }
                            });
                        }
                        catch (AccessControlException ace) {
                            String msg = LogUtil.getLogMsg("ERR_INVALID_PERMISSION", name, ace.getMessage());
                            LogUtil.errorMsg(msg);
                            throw ace;
                        }
                    }
                    if (object2 instanceof LogEventProducer) {
                        this.addListeners((LogEventProducer)object2, config);
                    }
                    if (object2 instanceof Handler) {
                        this.addFormatter((Handler)object2, config);
                        this.addErrorProtocol((Handler)object2, config);
                    }
                }
            }
        }
        String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".configChange");
        LogUtil.errorMsg(msg);
    }

    protected void finalize() throws Throwable {
        Vector<LogComponent> allLogObjs = new Vector<LogComponent>();
        Enumeration<Object> e = this.fullConfig.elements();
        while (e.hasMoreElements()) {
            LogManagerConfig config = (LogManagerConfig)e.nextElement();
            allLogObjs.add(config.getObject());
        }
        e = allLogObjs.elements();
        while (e.hasMoreElements()) {
            LogComponent object = (LogComponent)e.nextElement();
            if (object == null) continue;
            this.returnObject(object);
        }
        super.finalize();
    }
}

