/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.PropertyDataStore;
import com.ibm.log.util.LogException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyFileDataStore
extends PropertyDataStore {
    public PropertyFileDataStore(String name) throws IOException, LogException {
        super(name);
    }

    private void getFileAndProperties(String fileName, Properties properties) throws IOException {
        String path;
        this.propFileName = fileName;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            path = System.getProperty("jlog.propertyFileDir");
        } else {
            try {
                path = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return System.getProperty("jlog.propertyFileDir");
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }
        if (path != null) {
            String tempDir = path.replace('/', File.separatorChar);
            if (!tempDir.endsWith(File.separator)) {
                tempDir = tempDir + File.separator;
            }
            this.propFileName = tempDir + fileName;
        }
        this.is = new BufferedInputStream(new FileInputStream(this.propFileName));
        properties.load(this.is);
    }

    protected Properties loadProperties(String name) throws IOException, AccessControlException {
        Properties properties = new Properties();
        String fileName = name;
        this.getFileAndProperties(fileName, properties);
        this.is.close();
        return properties;
    }

    public void saveConfig(boolean saveAll) throws Exception, AccessControlException {
        FileOutputStream fos = new FileOutputStream(this.propFileName, false);
        String header = "Written by " + this.getClass().getName();
        Enumeration e1 = this.getConfig();
        while (e1.hasMoreElements()) {
            DataStoreConfig config = (DataStoreConfig)e1.nextElement();
            String configName = config.getProperty("name");
            if (config == this.getRoot() || !saveAll && !config.isLoadedFromDataStore()) continue;
            Properties props = new Properties();
            Enumeration<Object> e2 = config.keys();
            while (e2.hasMoreElements()) {
                String propName = (String)e2.nextElement();
                if (propName.equals("name")) continue;
                String key = configName + "." + propName;
                String value = (String)config.get(propName);
                props.setProperty(key, value);
            }
            props.store(fos, header);
        }
        fos.close();
    }

    public boolean isWriteable() {
        return true;
    }
}

