/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.server;

import com.ibm.log.FileHandler;
import com.ibm.log.LogEventListener;
import com.ibm.log.Logger;
import com.ibm.log.server.SocketLogger;
import com.ibm.log.util.LogUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class SocketServer
extends Logger
implements Runnable {
    static final long serialVersionUID = -1264105798077827156L;
    public static final int DEFAULT_PORT = 9991;
    public static final String DEFAULT_LOG_FILE = "server.log";
    private transient boolean finished = false;
    private transient boolean stopRequested = false;
    private int port = 9991;
    private LogEventListener eventListener;

    public static void main(String[] args) {
        int port = 9991;
        String fileName = DEFAULT_LOG_FILE;
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    port = Integer.valueOf(args[0]);
                }
                catch (NumberFormatException e) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("SS_USAGE"));
                    System.exit(1);
                }
                break;
            }
            case 2: {
                try {
                    port = Integer.valueOf(args[0]);
                }
                catch (NumberFormatException e) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("SS_USAGE"));
                    System.exit(1);
                }
                fileName = args[1];
                break;
            }
            default: {
                LogUtil.errorMsg(LogUtil.getLogMsg("SS_USAGE"));
                System.exit(1);
            }
        }
        FileHandler fh = new FileHandler();
        fh.setFileName(fileName);
        SocketServer ss = new SocketServer(port);
        ss.addLogEventListener(fh);
        Thread thread = new Thread(ss);
        thread.start();
        System.out.println(LogUtil.getLogMsg("START_SERVER", new Integer(port).toString()));
        System.out.println(LogUtil.getLogMsg("OUTPUT_TO_FILE", fileName));
    }

    public SocketServer() {
    }

    public SocketServer(int port) {
        this.port = port;
    }

    public void run() throws SecurityException, AccessControlException {
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (!this.stopRequested) {
                try {
                    Socket socket;
                    final ServerSocket sSocket = serverSocket;
                    SecurityManager sm = System.getSecurityManager();
                    if (sm == null) {
                        socket = sSocket.accept();
                    } else {
                        try {
                            socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return sSocket.accept();
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            throw (IOException)pae.getException();
                        }
                    }
                    if (this.stopRequested) continue;
                    SocketLogger socketLogger = new SocketLogger(socket);
                    LogEventListener[] listeners = this.getLogEventListeners();
                    for (int i = 0; i < listeners.length; ++i) {
                        socketLogger.addLogEventListener(listeners[i]);
                    }
                    Thread thread = new Thread(socketLogger);
                    thread.start();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() throws SecurityException {
        this.stopRequested = true;
        try {
            new Socket("localhost", this.port).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

