/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.SerialFileHandler;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageErrorProtocol;
import java.io.File;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class BackupErrorProtocol
extends MessageErrorProtocol {
    static final long serialVersionUID = 1608895686546511054L;
    public static final int DEFAULT_CAPACITY = 100000;
    private static final String NAME_START = "backup_";
    private static final String NAME_END = ".log";
    private transient boolean cleanupRequired = false;
    public transient boolean open = false;
    private int capacity = 100000;
    private transient int discardedEventCount = 0;
    private transient int backedEventCount = 0;
    private transient SerialFileHandler backupFile = null;
    private String backupDir = null;
    private transient String backupName = null;

    public BackupErrorProtocol() {
    }

    public BackupErrorProtocol(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("backupCapacity", new Integer(this.getCapacity()).toString());
        if (this.getBackupDir() != null) {
            props.put("backupDir", this.getBackupDir());
        }
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("backupCapacity");
        if (prop != null) {
            this.setCapacity(new Integer(prop));
        }
        if ((prop = props.getProperty("backupDir")) != null) {
            this.setBackupDir(prop);
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        if (capacity >= 0) {
            this.capacity = capacity;
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(capacity), this.getClass().getName() + ".setCapacity");
            LogUtil.errorMsg(msg);
        }
    }

    public String getBackupDir() {
        return this.backupDir;
    }

    public void setBackupDir(String dir) {
        this.backupDir = dir;
        if (this.backupDir != null) {
            this.backupDir = this.backupDir.replace('\\', File.separatorChar);
            this.backupDir = this.backupDir.replace('/', File.separatorChar);
            if (this.backupDir.charAt(this.backupDir.length() - 1) != File.separatorChar) {
                this.backupDir = this.backupDir + File.separator;
            }
        }
    }

    public void error(Handler handler, LogEvent event, Throwable t) {
        if (this.backedEventCount == 0 && this.discardedEventCount == 0) {
            LogUtil.errorMsg(LogUtil.getLogMsg("BACKUP_ATTEMPT", handler.getName()));
        }
        if (!this.isFull()) {
            try {
                if (!this.open) {
                    this.open();
                }
                this.backupFile.write(event);
                ++this.backedEventCount;
                this.cleanupRequired = true;
            }
            catch (Exception e) {
                if (this.discardedEventCount == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_WRITE_BACKUP", this.backupName, handler.getName()));
                }
                ++this.discardedEventCount;
            }
        } else {
            if (this.discardedEventCount == 0) {
                LogUtil.errorMsg(LogUtil.getLogMsg("ERR_BACKUP_FULL", this.backupName, handler.getName()));
            }
            ++this.discardedEventCount;
        }
    }

    public void cleanup(Handler handler) {
        Vector events = null;
        try {
            events = this.backupFile.readSerializedEvents();
        }
        catch (Exception e) {
            LogUtil.errorMsg(LogUtil.getLogMsg("ERR_READ_BACKUP", this.backupName, handler.getName()));
            this.close();
        }
        if (events != null) {
            try {
                for (int j = 0; j < events.size(); ++j) {
                    handler.write((LogEvent)events.elementAt(j));
                    --this.backedEventCount;
                }
                if (this.discardedEventCount == 0) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_0", handler.getName()));
                } else if (this.discardedEventCount == 1) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_1", handler.getName()));
                } else {
                    LogUtil.errorMsg(LogUtil.getLogMsg("HANDLER_OK_2", handler.getName(), new Integer(this.discardedEventCount)));
                }
                this.discardedEventCount = 0;
                this.close();
                this.backupFile.deleteLog();
            }
            catch (Exception e1) {
                this.close();
                this.backupFile.deleteLog();
                try {
                    this.open();
                    for (int k = j; k < events.size(); ++k) {
                        LogEvent event = (LogEvent)events.elementAt(k);
                        this.backupFile.write(event);
                        ++this.backedEventCount;
                    }
                    this.cleanupRequired = true;
                }
                catch (Exception e2) {
                    LogUtil.errorMsg(LogUtil.getLogMsg("ERR_WRITE_BACKUP", this.backupName, handler.getName()));
                    this.close();
                }
            }
        }
    }

    public boolean isCleanupRequired() {
        return this.cleanupRequired;
    }

    protected synchronized boolean isFull() {
        return this.backedEventCount >= this.capacity && this.capacity != 0;
    }

    protected void open() throws Exception {
        Random random = new Random();
        while (!this.open) {
            String backupDir = this.getBackupDir();
            this.backupName = backupDir != null ? backupDir : "";
            int randomMid = random.nextInt();
            if (randomMid < 0) {
                randomMid = -randomMid;
            }
            this.backupName = this.backupName + NAME_START + new Integer(randomMid).toString() + NAME_END;
            File testFile = new File(this.backupName);
            if (testFile.exists()) continue;
            if (this.backupFile == null) {
                this.backupFile = new SerialFileHandler();
                this.backupFile.setMaxFiles(1);
            }
            this.backupFile.setFileName(this.backupName);
            this.backupFile.open();
            this.open = true;
        }
    }

    protected void close() {
        if (this.backupFile != null) {
            this.backupFile.close();
        }
        this.open = false;
        this.cleanupRequired = false;
        this.backedEventCount = 0;
        this.discardedEventCount = 0;
    }
}

