/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

public class CBEMsgID {
    public static final int ID_TYPE_INDEX_NONE = 0;
    public static final String ID_TYPE_NAME_IBM631 = "IBM6.3.1";
    public static final int ID_TYPE_INDEX_IBM631 = 631;
    public static final int ID_TYPE_LENGTH_IBM631 = 10;
    public static final String ID_TYPE_NAME_IBM541 = "IBM5.4.1";
    public static final int ID_TYPE_INDEX_IBM541 = 541;
    public static final int ID_TYPE_LENGTH_IBM541 = 10;
    public static final String ID_TYPE_NAME_IBM531 = "IBM5.3.1";
    public static final int ID_TYPE_INDEX_IBM531 = 531;
    public static final int ID_TYPE_LENGTH_IBM531 = 9;
    public static final String ID_TYPE_NAME_IBM441 = "IBM4.4.1";
    public static final int ID_TYPE_INDEX_IBM441 = 441;
    public static final int ID_TYPE_LENGTH_IBM441 = 9;
    public static final String ID_TYPE_NAME_IBM431 = "IBM4.3.1";
    public static final int ID_TYPE_INDEX_IBM431 = 431;
    public static final int ID_TYPE_LENGTH_IBM431 = 8;
    public static final String ID_TYPE_NAME_IBM341 = "IBM3.4.1";
    public static final int ID_TYPE_INDEX_IBM341 = 341;
    public static final int ID_TYPE_LENGTH_IBM341 = 8;
    public static final String ID_TYPE_NAME_IBM331 = "IBM3.3.1";
    public static final int ID_TYPE_INDEX_IBM331 = 331;
    public static final int ID_TYPE_LENGTH_IBM331 = 7;

    private CBEMsgID() {
    }

    public static int getIdLen(int typeIndex) {
        int len = 0;
        switch (typeIndex) {
            case 331: {
                len = 7;
                break;
            }
            case 341: {
                len = 8;
                break;
            }
            case 431: {
                len = 8;
                break;
            }
            case 441: {
                len = 9;
                break;
            }
            case 531: {
                len = 9;
                break;
            }
            case 541: {
                len = 10;
                break;
            }
            case 631: {
                len = 10;
                break;
            }
        }
        return len;
    }

    public static String getIdType(int typeIndex) {
        String idType = null;
        switch (typeIndex) {
            case 331: {
                idType = ID_TYPE_NAME_IBM331;
                break;
            }
            case 341: {
                idType = ID_TYPE_NAME_IBM341;
                break;
            }
            case 431: {
                idType = ID_TYPE_NAME_IBM431;
                break;
            }
            case 441: {
                idType = ID_TYPE_NAME_IBM441;
                break;
            }
            case 531: {
                idType = ID_TYPE_NAME_IBM531;
                break;
            }
            case 541: {
                idType = ID_TYPE_NAME_IBM541;
                break;
            }
            case 631: {
                idType = ID_TYPE_NAME_IBM631;
                break;
            }
        }
        return idType;
    }

    public static int getTypeIndex(String s) {
        int idType = 0;
        if (null != s) {
            int sLen = s.length();
            boolean[] isAlpha = new boolean[10];
            boolean[] isDigit = new boolean[10];
            boolean[] validSev = new boolean[10];
            for (int i = 0; i < 10; ++i) {
                if (i < sLen) {
                    char c = s.charAt(i);
                    isAlpha[i] = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
                    isDigit[i] = c >= '0' && c <= '9';
                    validSev[i] = 'I' == c || 'W' == c || 'E' == c;
                    continue;
                }
                isAlpha[i] = false;
                isDigit[i] = false;
                validSev[i] = false;
            }
            if (isAlpha[0] && isAlpha[1] && isAlpha[2]) {
                if (isAlpha[3] && isAlpha[4] && isAlpha[5]) {
                    if (isDigit[6] && isDigit[7] && isDigit[8] && validSev[9]) {
                        idType = 631;
                    }
                } else if (isAlpha[3] && isAlpha[4]) {
                    if (isDigit[5] && isDigit[6] && isDigit[7]) {
                        if (isDigit[8] && validSev[9]) {
                            idType = 541;
                        } else if (validSev[8]) {
                            idType = 531;
                        }
                    }
                } else if (isAlpha[3]) {
                    if (isDigit[4] && isDigit[5] && isDigit[6]) {
                        if (isDigit[7] && validSev[8]) {
                            idType = 441;
                        } else if (validSev[7]) {
                            idType = 431;
                        }
                    }
                } else if (isDigit[3] && isDigit[4] && isDigit[5]) {
                    if (isDigit[6] && validSev[7]) {
                        idType = 341;
                    } else if (validSev[6]) {
                        idType = 331;
                    }
                }
            }
        }
        return idType;
    }
}

