/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ISO8601DateFormat
extends DateFormat {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final int BEGIN_TIMEZONE_FIELD = 23;
    private static final int END_TIMEZONE_FIELD = 29;
    private final SimpleDateFormat formatHelper = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final TimeZone formatTimeZone = this.formatHelper.getTimeZone();
    private final GregorianCalendar formatTZCalendar = new GregorianCalendar(this.formatTimeZone);
    private final SimpleDateFormat parseHelper = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final DecimalFormat tzHFormat;
    private static final String TZ_SEPARATOR = ":";
    private final DecimalFormat tzMFormat;

    public ISO8601DateFormat() {
        this.parseHelper.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.tzHFormat = new DecimalFormat("+00;-00");
        this.tzMFormat = new DecimalFormat("00;00");
    }

    public StringBuffer format(Date date, StringBuffer buff, FieldPosition fieldPos) {
        StringBuffer output = null;
        if (null != date && null != buff) {
            int tzSecondsEast = this.getTZOffsetSeconds(date);
            int tzHoursEast = tzSecondsEast / 3600;
            int tzMinutes = tzSecondsEast / 60 % 60;
            if (tzMinutes < 0) {
                tzMinutes = -tzMinutes;
            }
            output = buff;
            this.formatHelper.format(date, output, fieldPos);
            buff.append(this.tzHFormat.format(tzHoursEast));
            buff.append(TZ_SEPARATOR);
            buff.append(this.tzMFormat.format(tzMinutes));
            if (null != fieldPos && 17 == fieldPos.getField()) {
                fieldPos.setBeginIndex(23);
                fieldPos.setEndIndex(29);
            }
        }
        return output;
    }

    private synchronized int getTZOffsetSeconds(Date date) {
        int offsetMillis = this.formatTimeZone.getRawOffset();
        if (this.formatTimeZone.inDaylightTime(date)) {
            this.formatTZCalendar.setTime(date);
            offsetMillis += this.formatTZCalendar.get(16);
        }
        return offsetMillis / 1000;
    }

    public Date parse(String source, ParsePosition pos) {
        Date date = null;
        if (null != source && null != pos) {
            int tzOffsetEast = 0;
            date = this.parseHelper.parse(source, pos);
            Number tzHoursEast = this.tzHFormat.parse(source, pos);
            pos.setIndex(pos.getIndex() + 1);
            Number tzMinutesEast = this.tzMFormat.parse(source, pos);
            if (null != tzHoursEast) {
                tzOffsetEast += tzHoursEast.intValue() * 3600000;
            }
            if (null != tzMinutesEast) {
                tzOffsetEast += tzMinutesEast.intValue() * 60000;
            }
            date.setTime(date.getTime() - (long)tzOffsetEast);
        }
        return date;
    }
}

