/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.Nas.gui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.Nas.gui.admin.NasAddDialog;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.server.agentreq.ManNasReq;
import org.eclipse.aperi.TStorm.server.guireq.RespManNas;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TextUtil;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasManualPanel
extends JPanel
implements ActionListener,
GuiRequestor {
    static final String ADDNAS = MessageLog.getMessageNoID("NAG0101L");
    static final String DELETE = MessageLog.getMessageNoID("GUI0106L");
    static final String FILER = MessageLog.getMessageNoID("NAG0015L");
    static final String NETWORK_NAME = MessageLog.getMessageNoID("NAG0103L");
    static final String DOMAIN = MessageLog.getMessageNoID("NAG0110L");
    static final String COMPUTER = MessageLog.getMessageNoID("NAG0104L");
    static final String OS_TYPE = MessageLog.getMessageNoID("STG1108L");
    static final String NONE = MessageLog.getMessageNoID("NAG0032L");
    static final String[] colNames = new String[]{FILER, NETWORK_NAME, OS_TYPE, DOMAIN, COMPUTER};
    static final int FILER_COL = 0;
    static final int NETWORK_COL = 1;
    static final int OS_TYPE_COL = 2;
    static final int DOMAIN_COL = 3;
    static final int COMPUTER_COL = 4;
    private MegaTable table = new MegaTable();
    private RespManNas[] dataArray;
    private NameList[] selectedNas;
    private NameList[] windowsAgents;
    private NameList[] unixAgents;
    private NameList[] ldapNameList;
    private LdapTree[] ldapTrees;
    private JButton addNasButton;
    private JButton addNetButton;
    private JButton deleteButton;
    private JPanel nonePanel;
    private NasAddDialog addDialog;
    private boolean requestSubmitted;
    private boolean bAddNas;
    private DataDisplayInfo ddi;
    private TableMouseListener mouseListener;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public NasManualPanel(DataDisplayInfo ddi, Object[] data) {
        this.ddi = ddi;
        this.setLayout(new BorderLayout());
        this.massageData(data);
        this.mouseListener = new TableMouseListener();
        this.addNasButton = new JButton(ADDNAS);
        this.addNasButton.setEnabled(true);
        this.addNasButton.setActionCommand(ADDNAS);
        this.addNasButton.addActionListener(this);
        GuiUtil.setAccessible(this.addNasButton, this.addNasButton.getText(), this.addNasButton.getText());
        this.addNasButton.setToolTipText(Util.getString("TOOLTIP_BUTTON_AGENTROW"));
        this.deleteButton = new JButton(DELETE);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setActionCommand(DELETE);
        this.deleteButton.addActionListener(this);
        GuiUtil.setAccessible(this.deleteButton, this.deleteButton.getText(), this.deleteButton.getText());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addNasButton);
        buttonPanel.add(this.deleteButton);
        this.add((Component)buttonPanel, "North");
        if (this.dataArray == null || this.dataArray.length == 0) {
            this.nonePanel = new JPanel();
            this.nonePanel.add(new JLabel(MessageLog.getMessageNoID("STG0020M")));
            this.add((Component)this.nonePanel, "Center");
        } else {
            this.table.setBaseTableModel(new TableModel());
            this.table.setSelectionPolicy(0);
            this.table.setMouseListener(this.mouseListener);
            this.add((Component)this.table, "Center");
        }
    }

    private void massageData(Object[] array) {
        int i;
        this.dataArray = (RespManNas[])array[0];
        this.ldapTrees = (LdapTree[])array[1];
        NameList[] agents = (NameList[])array[2];
        int unixCount = 0;
        int windowsCount = 0;
        for (int i2 = 0; i2 < agents.length; ++i2) {
            if (Constants.isWindows((short)agents[i2].nlID3)) {
                ++windowsCount;
                continue;
            }
            ++unixCount;
        }
        NameList none = new NameList();
        none.nlName = NONE;
        none.nlID = -999;
        this.unixAgents = new NameList[unixCount];
        this.windowsAgents = new NameList[windowsCount];
        unixCount = 0;
        windowsCount = 0;
        for (i = 0; i < agents.length; ++i) {
            if (Constants.isWindows((short)agents[i].nlID3)) {
                this.windowsAgents[windowsCount++] = agents[i];
                continue;
            }
            this.unixAgents[unixCount++] = agents[i];
        }
        if (windowsCount == 0) {
            this.windowsAgents = new NameList[1];
            this.windowsAgents[0] = none;
        }
        if (unixCount == 0) {
            this.unixAgents = new NameList[1];
            this.unixAgents[0] = none;
        }
        this.ldapNameList = new NameList[this.ldapTrees.length];
        for (i = 0; i < this.ldapTrees.length; ++i) {
            this.ldapNameList[i] = new NameList();
            this.ldapNameList[i].nlName = this.ldapTrees[i].getTrueLtName();
            this.ldapNameList[i].nlID = this.ldapTrees[i].ltTreeID;
            this.ldapNameList[i].nlID2 = this.ldapTrees[i].ltComputerID;
            this.ldapNameList[i].nlHostName = this.ldapTrees[i].ltComputerName;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addNasButton) {
            this.addNas();
        } else if (source == this.deleteButton) {
            this.delete();
        } else if (source == this.addDialog.getSaveButton()) {
            this.saveADD();
        } else if (source == this.addDialog.getCancelButton()) {
            this.addDialogClosed();
        } else if (source == this.addDialog.getWindowsRB() || source == this.addDialog.getUnixRB()) {
            this.filterAgents();
        }
    }

    private void addItems(NameList[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.addDialog.getAgentBox().addItem(items[i]);
        }
    }

    private void filterAgents() {
        if (this.addDialog == null || this.addDialog.getSaveButton() == null) {
            return;
        }
        this.addDialog.getAgentBox().removeAllItems();
        this.addDialog.getUseridField().setText("");
        this.addDialog.getPasswordField().setText("");
        if (this.addDialog.getWindowsRB().isSelected()) {
            this.addItems(this.windowsAgents);
            this.addDialog.setUserPasswordEnabled(true);
        } else {
            this.addItems(this.unixAgents);
            this.addDialog.setUserPasswordEnabled(false);
        }
        this.addDialog.getSaveButton().setEnabled(true);
        this.addDialog.getAgentBox().repaint();
    }

    private void addNas() {
        this.bAddNas = true;
        this.initComponents();
        this.addDialog.setTitle(MessageLog.getMessageNoID("NAG0101L"));
        this.filterAgents();
        Help.setHelpID(this.addDialog.getRootPane(), "asco150");
        this.addDialog.display();
    }

    private void delete() {
        int[] selected = this.table.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            RespManNas node = this.dataArray[selected[i]];
            this.deleteDialog(node);
        }
    }

    private void deleteDialog(RespManNas node) {
        String confirmTitle = MessageLog.getMessageNoID("NAG0115L");
        String confirmText = MessageLog.getMessageNoID("NAG0116L", node.mnNetName);
        if (GuiUtil.getConfirmation(this.guiMain.getFrame(), confirmTitle, confirmText, false)) {
            this.sendRequest(node);
        }
    }

    private void initComponents() {
        this.addDialog = null;
        this.addDialog = new NasAddDialog(this.guiMain.getFrame(), true, this.windowsAgents, this.ldapNameList);
        this.addDialog.setTitle(MessageLog.getMessageNoID("NAG0101L"));
        this.addDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing() {
                NasManualPanel.this.addDialogClosed();
            }

            public void windowOpened() {
                NasManualPanel.this.requestFocus();
                NasManualPanel.this.addDialog.getNameField().requestFocus();
            }
        });
        this.addDialog.getWindowsRB().addActionListener(this);
        this.addDialog.getUnixRB().addActionListener(this);
        this.addDialog.getSaveButton().addActionListener(this);
        this.addDialog.getCancelButton().addActionListener(this);
        this.addDialog.getLdapBox().addActionListener(this);
    }

    private void addDialogClosed() {
        if (this.requestSubmitted) {
            this.guiMain.endRequestWait();
            this.addDialog.enableControls(true);
            this.filterAgents();
            this.requestSubmitted = false;
        }
        if (this.addDialog != null) {
            this.addDialog.dispose();
            this.addDialog = null;
        }
    }

    private void saveADD() {
        String name;
        String userid = null;
        String password = null;
        NameList agent = null;
        try {
            name = this.getRequiredField(this.addDialog.getNameField(), "NAG0108E");
            if (this.bAddNas && this.addDialog.getWindowsRB().isSelected()) {
                userid = this.getRequiredField(this.addDialog.getUseridField(), "SAG3002E");
                char[] pArray = this.addDialog.getPasswordField().getPassword();
                if (pArray == null || pArray.length == 0) {
                    this.addDialog.getPasswordField().requestFocus();
                    throw new GeneralException("SAG3003E");
                }
                password = String.valueOf(pArray);
            }
            agent = (NameList)this.addDialog.getAgentBox().getSelectedItem();
            if (agent.nlID3 < 0) {
                throw new GeneralException("NAG0109E");
            }
        }
        catch (GeneralException e) {
            String errorMsg = MessageLog.getMessageNoTS(e.getMessage());
            GuiUtil.displayErrorMessage(errorMsg);
            return;
        }
        ManNasReq request = new ManNasReq();
        request.mnNetworkName = name;
        request.mnAddNas = this.bAddNas;
        if (this.bAddNas) {
            request.mnUserid = userid;
            if (password != null) {
                request.mnPassword = Encrypt.encrypt(password);
            }
            request.mnAgentID = agent.nlID;
            request.mnCommunityName = this.addDialog.getSnmpField().getText();
            request.mnIsWindows = this.addDialog.getWindowsRB().isSelected();
            if (request.mnAgentID < 0) {
                String errorMsg = request.mnIsWindows ? MessageLog.getMessageNoTS("NAG0118E") : MessageLog.getMessageNoTS("NAG0117E");
                GuiUtil.displayErrorMessage(errorMsg);
                return;
            }
        } else {
            NameList ldap = (NameList)this.addDialog.getLdapBox().getSelectedItem();
            request.mnTreeName = ldap.nlName;
            request.mnAgentID = ldap.nlID2;
        }
        this.sendRequest(request);
    }

    private String getRequiredField(JTextField field, String msgID) throws GeneralException {
        String value = TextUtil.getTrimmedText(field);
        if (TextUtil.isNull(value)) {
            field.requestFocus();
            throw new GeneralException(msgID);
        }
        return value;
    }

    private void sendRequest(Serializable reqData) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.nas.NasGuiManEntryHndlr";
        request.requestData = reqData;
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
        this.requestSubmitted = true;
        if (this.addDialog != null) {
            this.addDialog.enableControls(false);
        }
    }

    public void handleResponse(short status, Response response) {
        this.requestSubmitted = false;
        if (status <= 4) {
            Object[] rData = (Object[])response.responseData;
            this.refreshTable((RespManNas[])rData[0]);
            if (this.addDialog != null) {
                this.addDialog.enableControls(true);
                this.filterAgents();
                this.addDialog.dispose();
                this.addDialog = null;
            }
        } else if (this.addDialog != null) {
            this.addDialog.enableControls(true);
        }
    }

    private void refreshTable(RespManNas[] dataArray) {
        this.remove(this.table);
        if (this.nonePanel != null) {
            this.remove(this.nonePanel);
            this.nonePanel = null;
        }
        if (dataArray == null || dataArray.length == 0) {
            this.nonePanel = new JPanel();
            this.nonePanel.add(new JLabel(MessageLog.getMessageNoID("STG0020M")));
            this.add((Component)this.nonePanel, "Center");
        } else {
            this.dataArray = dataArray;
            this.table.setBaseTableModel(new TableModel());
            this.table.setMouseListener(this.mouseListener);
            this.add((Component)this.table, "Center");
        }
        this.invalidate();
    }

    private class TableMouseListener
    extends TJCTableMouseAdapter {
        private TableMouseListener() {
        }

        public boolean select(int viewRow, int viewCol) {
            boolean selectIt = ((NasManualPanel)NasManualPanel.this).guiMain.getUserPrefs().administrator;
            return selectIt;
        }

        public void selectionChanged(boolean state) {
            NasManualPanel.this.deleteButton.setEnabled(state);
        }
    }

    private class TableModel
    extends BaseTableModel {
        public TableModel() {
            this.columnNames = colNames;
            this.rowCount = NasManualPanel.this.dataArray.length;
        }

        public Object getTableDataItem(int rowNum, int colNum) {
            String data = null;
            if (colNum == 0) {
                data = ((NasManualPanel)NasManualPanel.this).dataArray[rowNum].mnFiler;
            } else if (colNum == 1) {
                data = ((NasManualPanel)NasManualPanel.this).dataArray[rowNum].mnNetName;
            } else if (colNum == 3) {
                data = ((NasManualPanel)NasManualPanel.this).dataArray[rowNum].mnDomain;
            } else if (colNum == 2) {
                data = MessageLog.getMessageNoID(Constants.OSTYPES[((NasManualPanel)NasManualPanel.this).dataArray[rowNum].mnOsType]);
            } else if (colNum == 4) {
                data = ((NasManualPanel)NasManualPanel.this).dataArray[rowNum].mnUnixComp;
            }
            return data;
        }
    }
}

