/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import java.util.Date;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class LunAdjuster
extends CustomReportDataAdjuster {
    static final String SUBSYSTEM = MessageLog.getMessageNoID("SAG0001L");
    static final String LUN_NAME = MessageLog.getMessageNoID("SAG0514L");
    static final String LUN_WWN = MessageLog.getMessageNoID("SAG0620L");
    static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    static final String OVERHEAD = MessageLog.getMessageNoID("SAG0202L");
    static final String SURFACED = MessageLog.getMessageNoID("SAG0201L");
    static final String VCMDB = MessageLog.getMessageNoID("SAG0014L");
    static final String MIRROR = MessageLog.getMessageNoID("SAG0203L");
    static final String PRIMARY = MessageLog.getMessageNoID("SAG0204L");
    static final String REPLICATION = MessageLog.getMessageNoID("SAG0205L");
    static final String MANUFACTURER = MessageLog.getMessageNoID("STG1105L");
    static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    static final String FORMAT = MessageLog.getMessageNoID("SAG0033L");
    static final String YES = MessageLog.getMessageNoID("GUI0121T");
    static final String NO = MessageLog.getMessageNoID("GUI0122T");
    static final String UNKNOWN = MessageLog.getMessageNoID("GUI0129T");
    public static final String NA = MessageLog.getMessageNoID("STG0019T");
    public static final String FIXBLK = MessageLog.getMessageNoID("SAG0034L");
    public static final String ZSERIES = MessageLog.getMessageNoID("SAG0035L");
    public static final String SOURCE = MessageLog.getMessageNoID("SAG0206L");
    public static final String TARGET = MessageLog.getMessageNoID("SAG0207L");
    public static final String NONE = MessageLog.getMessageNoID("SAG0508L");
    public static final String VARBLK = MessageLog.getMessageNoID("SAG0087L");
    public String[] colNames = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, CAPACITY, OVERHEAD, SURFACED, VCMDB, MIRROR, PRIMARY, REPLICATION, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    private static final int SUBSYSTEM_COL = 0;
    private static final int LUN_NAME_COL = 1;
    private static final int LUN_WWN_COL = 2;
    private static final int CAPACITY_COL = 3;
    private static final int OVERHEAD_COL = 4;
    private static final int SURFACED_COL = 5;
    private static final int VCMDB_COL = 6;
    private static final int MIRROR_COL = 7;
    private static final int PRIMARY_COL = 8;
    private static final int REPLICATION_COL = 9;
    private static final int FORMAT_COL = 10;
    private static final int MANUFACTURER_COL = 11;
    private static final int MODEL_COL = 12;
    private static final int PROBE_TIME_COL = 13;
    private GuiReportReq grr;
    private Lun[] lunArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private int[] rendererArray;
    private int rowCount;
    public int frozenRows;
    public int totalRow;

    public LunAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 2;
        this.firstColumn = grr.reportSubtype == 18 ? 13 : 3;
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[13] = 1;
        this.rendererArray[3] = 7;
        this.rendererArray[4] = 7;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.lunArray = (Lun[])dataArray;
        this.rowCount = this.lunArray.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mDate = new Date[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            this.mDate[i] = new Date();
            this.mLong[i] = new MutableLong();
            this.mInt[i] = new MutableInteger();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rowCount; ++i) {
            Lun lun = this.lunArray[i];
            LogicalDisk lDisk = lun.lunLogicalDisk;
            lDisk.ldCapacity *= 512L;
            lDisk.ldOverhead *= 512L;
            if (i < this.totalRow || !lDisk.isSnapshot() || lun.lunPrimaryName != null) continue;
            lun.lunPrimaryName = UNKNOWN;
        }
    }

    public void undo() {
        Lun lun = this.lunArray[0];
        LogicalDisk lDisk = lun.lunLogicalDisk;
        lDisk.ldCapacity /= 512L;
        lDisk.ldOverhead /= 512L;
        if (lDisk.isSnapshot() && lun.lunPrimaryName == UNKNOWN) {
            lun.lunPrimaryName = null;
        }
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        int[] yesNo = new int[]{0, 1};
        int[] yesNoNA = new int[]{0, 1, 9};
        int[] format = new int[]{7, 8, 58, 9};
        int[] replication = new int[]{10, 11, 12, 9};
        colArray[5].cdValidValue = yesNo;
        colArray[6].cdValidValue = yesNoNA;
        colArray[7].cdValidValue = yesNoNA;
        colArray[9].cdValidValue = replication;
        colArray[10].cdValidValue = format;
    }

    public int getNumberRows() {
        return this.lunArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getArray() {
        return this.lunArray;
    }

    public Object getCellData(int row, int col) {
        if (row == 0 && this.bHasTotalRow && col != 0 && col != 3 && col != 4) {
            return " ";
        }
        switch (col) {
            case 0: {
                return this.lunArray[row].lunDaAlias;
            }
            case 1: {
                int index;
                String lunName = this.lunArray[row].lunName;
                if (this.lunArray[row].lunOSType == 21 && (index = lunName.indexOf(":")) > 0) {
                    lunName = lunName.substring(0, index);
                }
                return lunName;
            }
            case 2: {
                String lunWWN = this.lunArray[row].lunWWN;
                if (Util.isEmpty(lunWWN)) {
                    return UNKNOWN;
                }
                return lunWWN;
            }
            case 3: {
                this.mLong[row].value = this.lunArray[row].lunLogicalDisk.ldCapacity;
                return this.mLong[row];
            }
            case 4: {
                this.mLong[row].value = this.lunArray[row].lunLogicalDisk.ldOverhead;
                return this.mLong[row];
            }
            case 5: {
                return this.lunArray[row].lunLogicalDisk.notExposed() ? NO : YES;
            }
            case 6: {
                if (Constants.isCimomManaged(this.lunArray[row].lunOSType)) {
                    return NA;
                }
                return this.lunArray[row].lunLogicalDisk.isVCMDB() ? YES : NO;
            }
            case 7: {
                if (Constants.isCimomManaged(this.lunArray[row].lunOSType)) {
                    return NA;
                }
                return this.lunArray[row].lunLogicalDisk.isSnapshot() ? YES : NO;
            }
            case 8: {
                if (Constants.isCimomManaged(this.lunArray[row].lunOSType)) {
                    return NA;
                }
                String primary = this.lunArray[row].lunPrimaryName;
                return primary == null ? "" : primary;
            }
            case 9: {
                if (Constants.isCimomManaged(this.lunArray[row].lunOSType)) {
                    return NA;
                }
                byte mode = this.lunArray[row].lunLogicalDisk.getReplicationMode();
                if (mode == 0) {
                    return NONE;
                }
                return mode == 1 ? SOURCE : TARGET;
            }
            case 10: {
                return LogicalDisk.FORMATS[this.lunArray[row].lunLogicalDisk.ldStorageType];
            }
            case 11: {
                if (this.lunArray[row].lunDaManufacturer.toLowerCase().equals("unknown")) {
                    return MessageLog.getMessageNoID("STG1020L");
                }
                return this.lunArray[row].lunDaManufacturer;
            }
            case 12: {
                if (this.lunArray[row].lunOSType == 21) {
                    return "2145";
                }
                return this.lunArray[row].lunDaModel;
            }
            case 13: {
                this.mDate[row].setTime(this.lunArray[row].lunProbeTime);
                return this.mDate[row];
            }
        }
        return null;
    }

    private void addTotal() {
        Lun lun;
        long ldCapacity = 0L;
        long ldOverhead = 0L;
        Lun[] plusArray = new Lun[this.rowCount + 1];
        plusArray[0] = lun = new Lun();
        lun.lunLogicalDisk = new LogicalDisk();
        lun.lunDaAlias = MessageLog.getMessageNoID("STG4136L");
        for (int i = 0; i < this.rowCount; ++i) {
            if (this.lunArray[i].lunLogicalDisk.ldCapacity > -1L) {
                ldCapacity += this.lunArray[i].lunLogicalDisk.ldCapacity;
            }
            if (this.lunArray[i].lunLogicalDisk.ldOverhead > -1L) {
                ldOverhead += this.lunArray[i].lunLogicalDisk.ldOverhead;
            }
            plusArray[i + 1] = this.lunArray[i];
        }
        lun.lunLogicalDisk.ldCapacity = ldCapacity;
        lun.lunLogicalDisk.ldOverhead = ldOverhead;
        this.lunArray = plusArray;
        this.bHasTotalRow = true;
        this.totalRow = 1;
        ++this.frozenRows;
        ++this.rowCount;
    }
}

