/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.xmsg.MessageLog;

public class BatchReport
implements Serializable {
    static final long serialVersionUID = 4013739466987188629L;
    public int reportID;
    public GuiReportReq grr;
    public String fileMask;
    public byte reportType = 1;
    public Object data;
    public String historyHeader;
    public boolean includeHeaders;
    public boolean includeTotals;
    public byte spaceUnits;
    public Request saveChartSettingsReq;
    public static final int CSV_REPORT = 1;
    public static final int FORMATTED_REPORT = 2;
    public static final int IMPORT_REPORT = 3;
    public static final int PRINT_REPORT = 4;
    public static final int PDF_REPORT = 5;
    public static final int HTML_REPORT = 6;
    public static final int HISTORY_REPORT = 7;
    public static final int PDF_CHART_REPORT = 8;
    public static final int HTML_CHART_REPORT = 9;
    public static final String[] msgIDs = new String[]{"STG5161L", "STG5162L", "STG5163L", "STG5164L", "STG5165L", "STG5166L", "STG5167L"};
    public static final String[] keywords = new String[]{"{STG5161L}", "{STG5162L}", "{STG5163L}", "{STG5164L}", "{STG5165L}", "{STG5166L}", "{STG5167L}"};
    public static final String[] messageText = new String[]{"{" + MessageLog.getMessageNoID("STG5161L") + "}", "{" + MessageLog.getMessageNoID("STG5162L") + "}", "{" + MessageLog.getMessageNoID("STG5163L") + "}", "{" + MessageLog.getMessageNoID("STG5164L") + "}", "{" + MessageLog.getMessageNoID("STG5165L") + "}", "{" + MessageLog.getMessageNoID("STG5166L") + "}", "{" + MessageLog.getMessageNoID("STG5167L") + "}"};
    public String scriptName;
    public byte[] scriptBody;
    public String scriptExtension;

    public boolean equals(Object pOther) {
        BatchReport other = (BatchReport)pOther;
        return this.grr.equals(other.grr) && this.fileMask.equals(other.fileMask) && this.reportType == other.reportType && this.includeHeaders == other.includeHeaders && this.includeTotals == other.includeTotals && this.spaceUnits == other.spaceUnits && Util.stringsEqual(this.scriptName, other.scriptName);
    }

    public Object clone() {
        BatchReport result = new BatchReport();
        result.grr = (GuiReportReq)this.grr.clone();
        result.fileMask = this.fileMask;
        result.reportType = this.reportType;
        result.scriptName = this.scriptName;
        result.includeHeaders = this.includeHeaders;
        result.includeTotals = this.includeTotals;
        result.spaceUnits = this.spaceUnits;
        return result;
    }

    public boolean isEmpty() {
        return this.grr.reportType == 0 || this.fileMask == null;
    }

    public String maskToText(String mask, String[] text) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(BatchReport.class.getName(), "maskToText", "mask, text");
        }
        String returnMask = mask;
        if (mask == null) {
            returnMask = this.fileMask;
        }
        if (text == null) {
            text = messageText;
        }
        for (int i = 0; i < keywords.length; ++i) {
            int ix = returnMask.indexOf(keywords[i]);
            while (ix >= 0) {
                returnMask = ix == 0 ? text[i] + returnMask.substring(10) : returnMask.substring(0, ix) + text[i] + returnMask.substring(ix + 10);
                ix = returnMask.indexOf(keywords[i]);
            }
        }
        String traceResult = returnMask;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(BatchReport.class.getName(), "maskToText", traceResult);
        }
        return traceResult;
    }

    public String maskToIDs(String[] text) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(BatchReport.class.getName(), "maskToIDs", "text");
        }
        String returnMask = this.fileMask;
        if (text == null) {
            text = messageText;
        }
        for (int i = 0; i < keywords.length; ++i) {
            int ix = returnMask.indexOf(text[i]);
            while (ix >= 0) {
                returnMask = ix == 0 ? keywords[i] + returnMask.substring(text[i].length()) : returnMask.substring(0, ix) + keywords[i] + returnMask.substring(ix + text[i].length());
                ix = returnMask.indexOf(text[i]);
            }
        }
        String traceResult = returnMask;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(BatchReport.class.getName(), "maskToIDs", traceResult);
        }
        return traceResult;
    }
}

