/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;

public class ByteBuffer
implements Serializable {
    static final long serialVersionUID = -2279999246401676782L;
    public byte[] data;
    public int length;

    public ByteBuffer(byte[] pData, int pLength) {
        this.length = pLength;
        this.data = new byte[pLength];
        System.arraycopy(pData, 0, this.data, 0, pLength);
    }

    public ByteBuffer(String initial) {
        this.data = initial.getBytes();
        this.length = this.data.length;
    }

    public ByteBuffer(ByteBuffer template) {
        this.data = template.data;
        this.length = template.length;
    }

    public ByteBuffer(byte[] x) {
        this.data = x;
        this.length = x.length;
    }

    public void append(byte[] x) {
        if (this.length + x.length > this.data.length) {
            byte[] newData = new byte[this.length + x.length << 1];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        System.arraycopy(x, 0, this.data, this.length, x.length);
        this.length += x.length;
    }

    public void append(byte x) {
        byte[] foo = new byte[]{x};
        this.append(foo);
    }

    public void append(byte[] x, int firstByte, int appendLength) {
        if (this.length + appendLength > this.data.length) {
            byte[] newData = new byte[this.length + appendLength << 1];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        System.arraycopy(x, firstByte, this.data, this.length, appendLength);
        this.length += appendLength;
    }

    public int hashCode() {
        int i;
        int result = 0;
        int n = i = this.length < 5 ? this.length - 1 : 4;
        while (i > 0) {
            result = (result << 8) + this.data[i];
            --i;
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result;
        ByteBuffer other = (ByteBuffer)o;
        boolean bl = result = other.length == this.length;
        if (result) {
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.data[i] == other.data[i]) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

