/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Disk;

public class Chunk
implements Serializable,
Cloneable {
    static final long serialVersionUID = -699063184665304380L;
    public Disk chkDisk;
    public transient Chunk chkNextOnDisk;
    public int chkDiskID;
    public transient ChunkCollection chkCollection;
    public transient Chunk chkNextInCollection;
    public int chkCollectionID;
    public int chkLogicalDiskID;
    public short chkSeqno;
    public short chkPartition;
    public int chkUnitSize;
    public long chkSize;
    public long chkOffset;
    public boolean chkHasDB;

    public boolean equals(Object o) {
        Chunk that = (Chunk)o;
        return that.chkDiskID == this.chkDiskID && that.chkPartition == this.chkPartition && that.chkUnitSize == this.chkUnitSize && that.chkSize == this.chkSize && that.chkOffset == this.chkOffset && that.chkHasDB == this.chkHasDB;
    }

    public static Chunk[] packByCollection(Chunk head) {
        int count = 0;
        Chunk chunk = head;
        while (chunk != null) {
            ++count;
            chunk = chunk.chkNextInCollection;
        }
        Chunk[] result = new Chunk[count];
        count = 0;
        while (head != null) {
            result[count] = head;
            ++count;
            chunk = head.chkNextInCollection;
            head.chkNextInCollection = null;
            head = chunk;
        }
        return result;
    }

    public static Chunk unpackByCollection(Chunk[] array) {
        Chunk result;
        int count = 0;
        if (array != null) {
            count = array.length;
        }
        if (count == 0) {
            return null;
        }
        Chunk prev = result = array[0];
        for (int i = 1; i < count; ++i) {
            Chunk chunk = array[i];
            if (chunk == null) continue;
            prev.chkNextInCollection = chunk;
            prev = chunk;
        }
        return result;
    }

    public static Chunk[] packByDisk(Chunk head) {
        int count = 0;
        Chunk chunk = head;
        while (chunk != null) {
            ++count;
            chunk = chunk.chkNextOnDisk;
        }
        Chunk[] result = new Chunk[count];
        count = 0;
        while (head != null) {
            result[count] = head;
            ++count;
            chunk = head.chkNextOnDisk;
            head.chkNextOnDisk = null;
            head = chunk;
        }
        return result;
    }

    public static Chunk unpackByDisk(Chunk[] array) {
        Chunk result;
        int count = 0;
        if (array != null) {
            count = array.length;
        }
        if (count == 0) {
            return null;
        }
        Chunk prev = result = array[0];
        for (int i = 1; i < count; ++i) {
            Chunk chunk = array[i];
            if (chunk == null) continue;
            prev.chkNextOnDisk = chunk;
            prev = chunk;
        }
        return result;
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        buf.append("chkDiskID (disk_id): " + this.chkDiskID + "\n");
        buf.append("chkCollectionID (collection_id): " + this.chkCollectionID + "\n");
        buf.append("chkLogicalDiskID (logical_disk_id): " + this.chkLogicalDiskID + "\n");
        buf.append("chkSeqno (seqno): " + this.chkSeqno + "\n");
        buf.append("chkPartiton (partition): " + this.chkPartition + "\n");
        buf.append("chkUnitSize (unit_size): " + this.chkUnitSize + "\n");
        buf.append("chkSize (chunk_size): " + this.chkSize + "\n");
        buf.append("chkOffset (offset): " + this.chkOffset + "\n");
        buf.append("chkHasDB: " + this.chkHasDB + "\n");
        return buf.toString();
    }
}

