/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.San.common.LunAdjuster;
import org.eclipse.aperi.TStorm.common.AgentAdjuster;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskAdjuster;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class ColumnDescriptor
implements Serializable,
Packable {
    static final long serialVersionUID = -973376719458617133L;
    public ColumnDescriptor cdNext;
    public short cdID;
    public short cdDataType;
    public String cdReportName;
    public String cdShortName;
    public transient int[] cdValidValue;
    public boolean cdIsFrozen;
    public byte cdScale;
    public ColumnDescriptor cdTwin;
    private static final short DO_NOT_USE = 0;
    public static final short STRING = 1;
    public static final short INTEGER = 2;
    public static final short TIMESTAMP = 3;
    public static final short DURATION = 4;
    public static final short STORAGE = 5;
    public static final short TIMESTAMP_OFFSET = 6;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int FILESYSTEM = 2;
    public static final int COMPUTER = 3;
    public static final int NETWORK_WIDE = 4;
    public static final int ON = 5;
    public static final int OFF = 6;
    public static final int ESS_FIXBLK = 7;
    public static final int ESS_ZSERIES = 8;
    public static final int NA = 9;
    public static final int SS_REP_NONE = 10;
    public static final int SS_REP_SOURCE = 11;
    public static final int SS_REP_TARGET = 12;
    public static final int INSTANCE = 13;
    public static final int DATABASE_TABLESPACE = 14;
    public static final int DATABASE = 15;
    public static final int TABLESPACE = 16;
    public static final int CLUSTER = 17;
    public static final int TABLEX = 18;
    public static final int PARTITIONED = 19;
    public static final int SUBPARTED = 20;
    public static final int PARTITION = 21;
    public static final int UDB_SMS = 22;
    public static final int UDB_DMS = 23;
    public static final int LOG_DATA = 24;
    public static final int OBJ_DATA = 25;
    public static final int MIX_DATA = 26;
    public static final int ONLINE = 27;
    public static final int OFFLINE = 28;
    public static final int RECOVER = 29;
    public static final int UDB_REGULAR = 30;
    public static final int UDB_LONG = 31;
    public static final int UDB_DECLARED_TEMP = 32;
    public static final int UDB_SYSTEM_TEMP = 33;
    public static final int NEVER_PROBED = 34;
    public static final int DROPPED = 35;
    public static final int QUIESCE_NONSHARE = 36;
    public static final int LOAD_PENDING = 37;
    public static final int BACKUP_PENDING = 38;
    public static final int RESTORE_PENDING = 39;
    public static final int REORG_IN_PROGRESS = 40;
    public static final int SUSPECT = 41;
    public static final int READ_ONLY = 42;
    public static final int READ_WRITE = 43;
    public static final int DBO_ONLY = 44;
    public static final int SINGLE_USER = 45;
    public static final int ROLLFORWARD_PENDING = 49;
    public static final int NOT_CONSISTENT = 50;
    public static final int UNKNOWN = 51;
    public static final int UP = 52;
    public static final int DOWN = 53;
    public static final int UNREACHABLE = 54;
    public static final int UPGRADE_NEEDED = 55;
    public static final int UPGRADING = 56;
    public static final int DEFECTED = 57;
    public static final int SQUADRON_VBLOCK = 58;
    private static final int MAX_NAMED_VALUE = 59;
    private static final int NAMED_VALUES_INDEX = 0;
    private static final int OS_TYPES_INDEX = 1;
    private static final int DISK_STATES_INDEX = 2;
    private static final int PROBE_STATUS_INDEX = 3;
    private static final int FSLV_TYPES_INDEX = 4;
    private static final int DBMS_TYPES_INDEX = 5;
    private static final int DB_LOG_MODES_INDEX = 6;
    private static final int DB_SEGMENT_TYPES_INDEX = 7;
    private static final int VOLGROUP_TYPES_INDEX = 8;
    private static final int EXPORT_PROTOCOLS_INDEX = 9;
    private static final int CPU_ARCHITECTURE_INDEX = 10;
    private static final int MAX_INDEX = 11;
    public static final String[][] VALID_VALUES;
    public static final int[] OS_TYPES;
    public static final int[] OS_TYPES_PLUS_UNKNOWN;
    public static final int[] SS_TYPES;
    public static final int[] PROBE_STATUS;
    public static final int[] DISK_STATES;
    public static final int[] FSLV_TYPES;
    public static final int[] VOLGROUP_TYPES;
    public static final int[] EXPORT_PROTOCOLS;
    public static final String[] NAMED_VALUES;
    public static final String[] FSLV_VALUES;
    public static final int[] CPU_ARCHITECTURES;

    private static void initValueIDArray(int validValuesIndex, int[] valueIDArray, String[] valuesArray) {
        int valueID = validValuesIndex << 16;
        ColumnDescriptor.VALID_VALUES[validValuesIndex] = valuesArray;
        for (int i = 0; i < valuesArray.length; ++i) {
            valueIDArray[i] = valueID + i;
        }
    }

    public static String getValue(int valueID) {
        try {
            return ColumnDescriptor.getValue(valueID, -1, -1);
        }
        catch (GeneralException ignored) {
            return "***ERROR***";
        }
    }

    public static String getValue(int valueID, int columnID, int reportType) throws GeneralException {
        int index;
        String[] valueArray = ColumnDescriptor.getValueArray(valueID);
        if (valueArray != null && (index = ColumnDescriptor.extractValueIndex(valueID)) >= 0 && index < valueArray.length) {
            return valueArray[index];
        }
        Object[] args = new Object[]{Integer.toString(reportType), Integer.toString(columnID), Integer.toString(valueID)};
        throw new GeneralException("STS0309E", args);
    }

    private static String[] getValueArray(int valueID) {
        int index = valueID >>> 16;
        return index < VALID_VALUES.length ? VALID_VALUES[index] : null;
    }

    private static int extractValueIndex(int valueID) {
        return valueID & 0xFFFF;
    }

    public Packable getNext() {
        return this.cdNext;
    }

    public void setNext(Packable next) {
        this.cdNext = (ColumnDescriptor)next;
    }

    public static void printCols(CustomReportDataAdjuster adjuster) {
        ColumnDescriptor col = adjuster.getColumnDescriptors();
        while (col != null) {
            col.print();
            System.out.println("");
            col = col.cdNext;
        }
    }

    public void print() {
        System.out.println("Column...... " + this.cdID);
        System.out.println("  DataType.. " + this.cdDataType);
        System.out.println("  Scale..... " + this.cdScale);
        System.out.println("  ReportName " + this.cdReportName);
        System.out.println("  ShortName. " + this.cdShortName);
        System.out.println("  IsFrozen.. " + this.cdIsFrozen);
        System.out.println("  HasTwin... " + (this.cdTwin != null));
        if (this.cdTwin != null) {
            System.out.println("  TwinID.... " + this.cdTwin.cdID);
            System.out.println("  TwinName.. " + this.cdTwin.cdReportName);
        }
        if (this.cdValidValue != null) {
            for (int i = 0; i < this.cdValidValue.length; ++i) {
                try {
                    int valueID = this.cdValidValue[i];
                    String value = ColumnDescriptor.getValue(valueID, 0, 0);
                    System.out.println("  ValidValue " + value + " (" + valueID + ")");
                    continue;
                }
                catch (GeneralException e) {
                    System.out.println("Exception " + e);
                }
            }
        }
    }

    static {
        int i;
        VALID_VALUES = new String[11][];
        OS_TYPES = new int[Constants.OSTYPES.length - 1];
        OS_TYPES_PLUS_UNKNOWN = new int[Constants.OSTYPES.length];
        PROBE_STATUS = new int[ComputersAdjuster.probeStatus.length];
        DISK_STATES = new int[Disk.STATES.length];
        FSLV_TYPES = new int[Filesystem.TYPES.length + LogicalDisk.TYPES.length];
        VOLGROUP_TYPES = new int[VolGroup.TYPES.length];
        EXPORT_PROTOCOLS = new int[Export.PROTOCOL.length];
        NAMED_VALUES = new String[59];
        FSLV_VALUES = new String[Filesystem.TYPES.length + LogicalDisk.TYPES.length];
        CPU_ARCHITECTURES = new int[6];
        ColumnDescriptor.NAMED_VALUES[0] = DiskAdjuster.YES;
        ColumnDescriptor.NAMED_VALUES[1] = DiskAdjuster.NO;
        ColumnDescriptor.NAMED_VALUES[5] = DiskAdjuster.ON;
        ColumnDescriptor.NAMED_VALUES[6] = DiskAdjuster.OFF;
        ColumnDescriptor.NAMED_VALUES[9] = LunAdjuster.NA;
        ColumnDescriptor.NAMED_VALUES[7] = LunAdjuster.FIXBLK;
        ColumnDescriptor.NAMED_VALUES[8] = LunAdjuster.ZSERIES;
        ColumnDescriptor.NAMED_VALUES[10] = LunAdjuster.NONE;
        ColumnDescriptor.NAMED_VALUES[11] = LunAdjuster.SOURCE;
        ColumnDescriptor.NAMED_VALUES[12] = LunAdjuster.TARGET;
        ColumnDescriptor.NAMED_VALUES[51] = MessageLog.getMessageNoID(Constants.OSTYPES[0]);
        ColumnDescriptor.NAMED_VALUES[52] = AgentAdjuster.AGENT_UP;
        ColumnDescriptor.NAMED_VALUES[53] = AgentAdjuster.AGENT_DOWN;
        ColumnDescriptor.NAMED_VALUES[54] = AgentAdjuster.AGENT_UNREACHABLE;
        ColumnDescriptor.NAMED_VALUES[55] = AgentAdjuster.AGENT_UPGRADE_NEEDED;
        ColumnDescriptor.NAMED_VALUES[56] = AgentAdjuster.AGENT_UPGRADING;
        ColumnDescriptor.NAMED_VALUES[57] = AgentAdjuster.AGENT_DEFECTED;
        ColumnDescriptor.NAMED_VALUES[58] = LunAdjuster.VARBLK;
        ColumnDescriptor.VALID_VALUES[0] = NAMED_VALUES;
        String[] tempArray = new String[Constants.OSTYPES.length];
        for (int h = 0; h < Constants.OSTYPES.length; ++h) {
            tempArray[h] = Util.getString(Constants.OSTYPES[h]);
        }
        ColumnDescriptor.VALID_VALUES[1] = tempArray;
        int valueID = 65536;
        ColumnDescriptor.OS_TYPES_PLUS_UNKNOWN[0] = valueID++;
        int ssTypes = 0;
        for (int i2 = 1; i2 < Constants.OSTYPES.length; ++i2) {
            ColumnDescriptor.OS_TYPES[i2 - 1] = valueID;
            ColumnDescriptor.OS_TYPES_PLUS_UNKNOWN[i2] = valueID++;
            if (!Constants.isDiskArray((short)i2)) continue;
            ++ssTypes;
        }
        valueID = 65536;
        SS_TYPES = new int[ssTypes];
        int index = 0;
        for (i = 0; i < Constants.OSTYPES.length; ++i) {
            if (!Constants.isDiskArray((short)i)) continue;
            ColumnDescriptor.SS_TYPES[index++] = valueID + i;
        }
        ColumnDescriptor.initValueIDArray(3, PROBE_STATUS, ComputersAdjuster.probeStatus);
        ColumnDescriptor.initValueIDArray(2, DISK_STATES, Disk.STATES);
        valueID = 262144;
        ColumnDescriptor.VALID_VALUES[4] = FSLV_VALUES;
        index = 0;
        for (i = 0; i < Filesystem.TYPES.length; ++i) {
            ColumnDescriptor.FSLV_VALUES[index] = Filesystem.TYPES[i];
            ColumnDescriptor.FSLV_TYPES[index] = valueID + index;
            ++index;
        }
        for (i = 0; i < LogicalDisk.TYPES.length; ++i) {
            ColumnDescriptor.FSLV_VALUES[index] = LogicalDisk.TYPES[i];
            ColumnDescriptor.FSLV_TYPES[index] = valueID + index;
            ++index;
        }
        ColumnDescriptor.initValueIDArray(8, VOLGROUP_TYPES, VolGroup.TYPES);
        ColumnDescriptor.initValueIDArray(9, EXPORT_PROTOCOLS, Export.PROTOCOL);
        ColumnDescriptor.initValueIDArray(10, CPU_ARCHITECTURES, Constants.cpuArchDisplayNames);
    }
}

