/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.common.UpTimeReport;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableLongExt;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerUpTimeAdjuster
extends CustomReportDataAdjuster {
    private GuiReportReq grr;
    private Comparator sorter;
    private UpTimeReport[] tableData;
    private MutableLong[] mLong;
    private MutableLongExt[] mLongExt;
    private MutableInteger[] mInteger;
    private Date[] mDate;
    public String[] colNames;
    private int name1Col = -1;
    private int name2Col = -1;
    private int[] rendererArray;
    private boolean batch;
    public static final int PERCENT_COL = 0;
    public static final int REBOOT_COL = 1;
    private static final int DOWN_TIME_COL = 2;
    private static final int AVG_DOWN_TIME_COL = 3;
    private static final int START_TIME_COL = 4;
    private static final int END_TIME_COL = 5;
    private static final int STAT_TYPE_COL = 6;
    private static final String[] COL_LABELS = new String[]{MessageLog.getMessageNoID("STG4071L"), MessageLog.getMessageNoID("STG4088L"), MessageLog.getMessageNoID("STG4086L"), MessageLog.getMessageNoID("STG4089L"), MessageLog.getMessageNoID("STG4078L"), MessageLog.getMessageNoID("STG4079L")};
    public static final byte PERCENT_SCALE = 3;
    private static final int TEN_RAISED_PERCENT_SCALE = 1000;
    private String[] statTypeValues;
    private static final int N_STATISTIC_TYPES = 5;

    public ComputerUpTimeAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 1;
        switch (grr.reportSubtype) {
            case 12: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 82: {
                this.sorter = new OneNameSorter();
                this.frozenColumns = 1;
                this.name2Col = -1;
                this.name1Col = -2;
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1136L");
                break;
            }
            case 28: {
                this.sorter = new HistorySorter();
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 13: {
                this.sorter = new TwoNameSorter();
                this.name1Col = -2;
                this.frozenColumns = 2;
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG0021L");
                this.colNames[1] = MessageLog.getMessageNoID("STG1103L");
                break;
            }
            case 14: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1104L");
                break;
            }
            case 15: {
                this.frozenColumns = 0;
                this.colNames = new String[COL_LABELS.length];
            }
        }
        System.arraycopy(COL_LABELS, 0, this.colNames, this.frozenColumns, COL_LABELS.length);
        if (grr.reportSubtype == 28) {
            this.colNames[this.colNames.length - 1] = MessageLog.getMessageNoID("STG1214L");
            this.statTypeValues = new String[5];
            this.statTypeValues[0] = MessageLog.getMessageNoID("STG4094L");
            this.statTypeValues[1] = MessageLog.getMessageNoID("STG4095L");
            this.statTypeValues[2] = MessageLog.getMessageNoID("STG4096L");
            this.statTypeValues[3] = this.statTypeValues[1];
            this.statTypeValues[4] = this.statTypeValues[2];
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[this.frozenColumns + 0] = 2;
        this.rendererArray[this.frozenColumns + 1] = 5;
        this.rendererArray[this.frozenColumns + 2] = 3;
        this.rendererArray[this.frozenColumns + 3] = 3;
        this.rendererArray[this.frozenColumns + 4] = 1;
        this.rendererArray[this.frozenColumns + 5] = 1;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        if (this.sorter != null) {
            Arrays.sort(this.tableData, this.sorter);
        }
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.tableData = (UpTimeReport[])dataArray;
        int rows = this.tableData.length;
        this.mDate = new Date[rows];
        this.mInteger = new MutableInteger[rows];
        this.mLong = new MutableLong[rows];
        this.mLongExt = new MutableLongExt[rows];
        for (int i = 0; i < rows; ++i) {
            this.mDate[i] = new Date();
            this.mInteger[i] = new MutableInteger();
            this.mLong[i] = new MutableLong();
            this.mLongExt[i] = new MutableLongExt();
        }
    }

    public void adjustData() {
        for (UpTimeReport dataRow : this.tableData) {
            long monitorTime = dataRow.crUpTime + (long)dataRow.chDownTime;
            dataRow.crUpTimePercent = (int)((double)dataRow.crUpTime / (double)monitorTime * 100000.0);
            if (dataRow.chPowerCycles > 0) {
                dataRow.crAvgDownTime = dataRow.chDownTime / dataRow.chPowerCycles;
            }
            if (this.batch || this.grr.reportSubtype != 12 && this.grr.reportSubtype != 28) continue;
            dataRow.crName1 = GuiUtil.getComputer((int)dataRow.crID).gcTSName;
        }
    }

    public int getNumberRows() {
        return this.tableData.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getScale() {
        return 1000;
    }

    public String getSuffix() {
        return " %";
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        for (int i = 0; i < this.tableData.length; ++i) {
            UpTimeReport dataRow = this.tableData[i];
            HistChartProcessor.addLegend(this.grr, dataRow.crName1, dataRow.getCrName2(), dataRow.crID);
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] IDarray = new int[this.tableData.length];
        for (int i = 0; i < this.tableData.length; ++i) {
            UpTimeReport dataRow = this.tableData[i];
            IDarray[i] = dataRow.crID;
        }
        return IDarray;
    }

    public Object getArray() {
        return this.tableData;
    }

    public Object getCellData(int row, int col) {
        if ((col -= this.frozenColumns) == this.name1Col) {
            return this.tableData[row].crName1;
        }
        if (col == this.name2Col) {
            return this.tableData[row].getCrName2();
        }
        if (col == 0) {
            this.mInteger[row].value = this.tableData[row].crUpTimePercent;
            return this.mInteger[row];
        }
        if (col == 1) {
            this.mLong[row].value = this.tableData[row].chPowerCycles;
            return this.mLong[row];
        }
        if (col == 2) {
            this.mLongExt[row].value = this.tableData[row].chDownTime;
            return this.mLongExt[row];
        }
        if (col == 3) {
            this.mLongExt[row].value = this.tableData[row].crAvgDownTime;
            return this.mLongExt[row];
        }
        if (col == 4) {
            this.mDate[row].setTime(this.tableData[row].chMonitorStart);
            return this.mDate[row];
        }
        if (col == 5) {
            this.mDate[row].setTime(this.tableData[row].chMonitorEnd);
            return this.mDate[row];
        }
        return this.statTypeValues[this.tableData[row].chStatisticType];
    }

    private class HistorySorter
    implements Comparator {
        private HistorySorter() {
        }

        public int compare(Object o1, Object o2) {
            UpTimeReport r1 = (UpTimeReport)o1;
            UpTimeReport r2 = (UpTimeReport)o2;
            if (r1.chMonitorStart > r2.chMonitorStart) {
                return 1;
            }
            if (r1.chMonitorStart < r2.chMonitorStart) {
                return -1;
            }
            if (r1.chMonitorEnd > r2.chMonitorEnd) {
                return 1;
            }
            if (r1.chMonitorEnd < r2.chMonitorEnd) {
                return -1;
            }
            return 0;
        }
    }

    private class TwoNameSorter
    implements Comparator {
        private TwoNameSorter() {
        }

        public int compare(Object o1, Object o2) {
            UpTimeReport r1 = (UpTimeReport)o1;
            UpTimeReport r2 = (UpTimeReport)o2;
            int x = r1.crName1.compareTo(r2.crName1);
            if (x != 0) {
                return x;
            }
            return r1.getCrName2().compareTo(r2.getCrName2());
        }
    }

    private class OneNameSorter
    implements Comparator {
        private OneNameSorter() {
        }

        public int compare(Object o1, Object o2) {
            UpTimeReport r1 = (UpTimeReport)o1;
            UpTimeReport r2 = (UpTimeReport)o2;
            return r1.crName1.compareTo(r2.crName1);
        }
    }
}

