/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.ComputerUpTimeAdjuster;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.UpTimeReport;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerUpTimeGrapher
extends Grapher {
    public int rowChartIcon;
    public static final byte CHART_AVAILABILITY = 101;
    public static final byte CHART_AVAILABILITY_X = 102;
    public static final String GRAPH_AVAILABILITY = "STG7527L";
    public static final String GRAPH_AVAILABILITY_SEL = "STG4121L";
    public static final String GRAPH_AVAILABILITY_ALL = "STG4122L";
    public static final String GRAPH_AVAILABILITY_HIST = "STG4123L";

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        if (grr.chartSubtype > 0) {
            return null;
        }
        return MessageLog.getMessageNoID(GRAPH_AVAILABILITY_HIST);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        AperiChart chart = null;
        this.setIcon(grr);
        if (grr.chartSubtype > 0) {
            chart = this.createChart(grr, pData, rows, pAdjuster, null, gcsr);
        } else {
            GuiReportReq newGrr = this.createHistory(grr, pData, rows);
            chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        }
        return chart;
    }

    public void setIcon(GuiReportReq grr) {
        this.rowChartIcon = grr.reportSubtype == 15 ? 11 : (grr.reportSubtype == 28 ? 10 : 12);
    }

    public AperiCustomizableChart createChart(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, ReportingDDI ddi, GuiChartSettingsReq gcsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ComputerUpTimeGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        UpTimeReport[] data = (UpTimeReport[])pData;
        ComputerUpTimeAdjuster adjuster = (ComputerUpTimeAdjuster)pAdjuster;
        Number[][] chartY = new Number[2][rows.length];
        String[] pointL = new String[rows.length];
        String[] seriesL = new String[2];
        for (int r = 0; r < rows.length; ++r) {
            int row = rows[r];
            UpTimeReport dataRow = data[row];
            chartY[0][r] = new Long(dataRow.crUpTime);
            chartY[1][r] = new Long(dataRow.chDownTime);
            pointL[r] = this.getRowName(data, row, adjuster, grr);
        }
        seriesL[0] = MessageLog.getMessageNoID("STG4128L");
        seriesL[1] = MessageLog.getMessageNoID("STG4127L");
        ChartOptions defaults = new ChartOptions();
        if (this.rowChartIcon == 12) {
            defaults.chartType = 5;
            defaults.chartsPerView = 1;
        }
        AperiCustomizableChart chart = new AperiCustomizableChart(6, 7, chartY, seriesL, pointL, defaults, grr);
        if (ddi != null) {
            ddi.addChart(grr, chart, "");
        }
        AperiCustomizableChart traceResult = chart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ComputerUpTimeGrapher.class.getName(), "createChart", traceResult);
        }
        return traceResult;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ComputerUpTimeGrapher.class.getName(), "createHistory", "grr, pData, rows");
        }
        UpTimeReport[] data = (UpTimeReport[])pData;
        GuiReportReq newGrr = grr.explode(-1);
        newGrr.reportSubtype = grr.reportSubtype;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        newGrr.selectedResources = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            UpTimeReport dataRow = data[rows[i]];
            newGrr.selectedResources[i] = dataRow.crID;
            SpaceHistChart.addLegend(newGrr, dataRow.crName1, dataRow.getCrName2(), dataRow.crID);
        }
        newGrr.chartLabelType = (byte)8;
        newGrr.histSubtype = (byte)6;
        newGrr.historyTitle = GRAPH_AVAILABILITY_HIST;
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        newGrr.reportSubtype = 28;
        GuiReportReq traceResult = newGrr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ComputerUpTimeGrapher.class.getName(), "createHistory", traceResult);
        }
        return traceResult;
    }

    public String getRowName(UpTimeReport[] tableData, int row, ComputerUpTimeAdjuster adjuster, GuiReportReq grr) {
        if (grr.reportSubtype == 82) {
            return tableData[row].getCrName2();
        }
        StringBuffer buffer = new StringBuffer(64);
        if (adjuster.frozenColumns > 0) {
            buffer.append(tableData[row].crName1);
            if (adjuster.frozenColumns > 1) {
                buffer.append('.');
                buffer.append(tableData[row].getCrName2());
            }
            buffer.append(' ');
            return buffer.toString();
        }
        return MessageLog.getMessageNoID("STG5048L");
    }
}

