/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.DiskAdjuster;
import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskGrapher
extends Grapher {
    public String actionCommand;
    public static final String SELECTED_HIST = "STG3207L";
    public static final String ALL_HIST = "STG7556L";

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        return MessageLog.getMessageNoID(SELECTED_HIST);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        DiskAdjuster adjuster = (DiskAdjuster)pAdjuster;
        AperiChart chart = null;
        GuiReportReq newGrr = this.createHistory(grr, pData, rows, adjuster, "bogus");
        chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        return chart;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows, DiskAdjuster adjuster, String actionCommand) {
        Share[] data = (Share[])pData;
        GuiReportReq newGrr = grr.explode(-1);
        newGrr.reportSubtype = grr.reportSubtype;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        newGrr.selectedResources = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            Share dataRow = data[rows[i]];
            newGrr.selectedResources[i] = dataRow.shResourceID;
            SpaceHistChart.addLegend(newGrr, GuiUtil.formatFilesystem(dataRow.shComputerName, adjuster.daArray[rows[i]].daPath), null, dataRow.shResourceID);
        }
        newGrr.histSubtype = actionCommand == ALL_HIST ? (byte)3 : (byte)8;
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        if (grr.reportSubtype == 24) {
            newGrr.reportSubtype = -24;
            newGrr.chartLabelType = (byte)6;
            newGrr.historyTitle = "STG1287T";
        } else if (grr.reportSubtype == 25) {
            newGrr.reportSubtype = -25;
            newGrr.chartLabelType = (byte)6;
            newGrr.historyTitle = "STG7524T";
        } else if (grr.reportSubtype == 26) {
            newGrr.reportSubtype = -26;
            newGrr.chartLabelType = (byte)6;
            newGrr.historyTitle = "STG7525T";
        } else if (grr.reportSubtype == 39) {
            newGrr.reportSubtype = -39;
            newGrr.chartLabelType = 1;
            newGrr.historyTitle = "STG7526T";
        } else {
            newGrr.reportSubtype = -23;
            newGrr.chartLabelType = (byte)6;
            newGrr.historyTitle = "STG7523T";
        }
        return newGrr;
    }
}

