/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

public class Like {
    private int saveStrIndex;
    private int saveMaskIndex;
    private int strLength;
    private int maskLength;
    private String str;
    private String mask;
    private char wildCard;
    private char positionMarker;
    private boolean ignoreCase;
    private static final char DEFAULT_WILD_CARD = '%';
    private static final char DEFAULT_POSITION_MARKER = '_';

    public static boolean isMask(String str) {
        return Like.isMask(str, '%', '_');
    }

    public static boolean isMask(String str, char wildCard, char positionMarker) {
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c != wildCard && c != positionMarker) continue;
            return true;
        }
        return false;
    }

    public Like() {
        this('%', '_', false);
    }

    public Like(char wildCard, char positionMarker, boolean ignoreCase) {
        this.wildCard = wildCard;
        this.positionMarker = positionMarker;
        this.ignoreCase = ignoreCase;
    }

    public boolean isLike(String str, String mask) {
        this.str = str;
        this.mask = mask;
        this.strLength = str.length();
        this.maskLength = mask.length();
        return this.isLike(0, 0);
    }

    private boolean isLike(int strIndex, int maskIndex) {
        while (strIndex != this.strLength || maskIndex != this.maskLength) {
            if (maskIndex == this.maskLength) {
                return false;
            }
            if (this.mask.charAt(maskIndex) == this.wildCard) {
                while (this.mask.charAt(maskIndex) == this.wildCard) {
                    if (++maskIndex != this.maskLength) continue;
                    return true;
                }
                while (strIndex < this.strLength) {
                    this.saveStrIndex = strIndex;
                    this.saveMaskIndex = maskIndex;
                    if (this.isLike(strIndex, maskIndex)) {
                        return true;
                    }
                    strIndex = this.saveStrIndex;
                    maskIndex = this.saveMaskIndex;
                    ++strIndex;
                }
            }
            if (strIndex == this.strLength) {
                return false;
            }
            if (this.mask.charAt(maskIndex) != this.positionMarker && (this.ignoreCase ? Character.toUpperCase(this.mask.charAt(maskIndex)) != Character.toUpperCase(this.str.charAt(strIndex)) : this.mask.charAt(maskIndex) != this.str.charAt(strIndex))) {
                return false;
            }
            ++strIndex;
            ++maskIndex;
        }
        return true;
    }
}

