/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String MOUNTPNT = MessageLog.getMessageNoID("STG1230L");
    private static final String PATH = MessageLog.getMessageNoID("STG1219L");
    private static final String TYPE = MessageLog.getMessageNoID("STG1132L");
    private static final String SIZE = MessageLog.getMessageNoID("STG1231L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1220L");
    public static final String USED = MessageLog.getMessageNoID("STG1237L");
    public static final String FREE = MessageLog.getMessageNoID("STG1184L");
    private static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    private static final String SCAN_TIME = MessageLog.getMessageNoID("STG1233L");
    private static final String DISCOVERED_TIME = MessageLog.getMessageNoID("STG1134L");
    private static final String LV_CAPACITY = MessageLog.getMessageNoID("STG3258L");
    private static final String OVERHEAD = MessageLog.getMessageNoID("STG6054L");
    public static final String[] COL_NAMES = new String[]{COMPUTER, MOUNTPNT, USED, FREE, CAPACITY, SIZE, LV_CAPACITY, OVERHEAD, SCAN_TIME, PROBE_TIME, DISCOVERED_TIME, TYPE, PATH};
    private static final int COMPUTER_COL = 0;
    private static final int MOUNTPNT_COL = 1;
    private static final int USED_COL = 2;
    private static final int FREE_COL = 3;
    private static final int CAPACITY_COL = 4;
    private static final int SIZE_COL = 5;
    private static final int LV_CAPACITY_COL = 6;
    private static final int OVERHEAD_COL = 7;
    private static final int SCAN_TIME_COL = 8;
    private static final int PROBE_TIME_COL = 9;
    private static final int DISCOVERED_TIME_COL = 10;
    private static final int TYPE_COL = 11;
    private static final int PATH_COL = 12;
    private Share[] shArray;
    private MutableLong[] mLong;
    private Date[] mDate;
    private Filesystem noFS = new Filesystem();
    private GuiReportReq grr;
    private int[] rendererArray;
    private int[] columnMap;
    public String[] colNames;
    private boolean batch;
    public int frozenRows;
    private int rowCount;

    public LogicalVolumeAdjuster(GuiReportReq pGRR) {
        super(pGRR);
        this.grr = pGRR;
        this.noFS.fsID = -2;
        this.noFS.fsComputerID = -2;
        this.noFS.fsGroupID = -2;
        this.noFS.fsLogicalDiskID = -2;
        this.noFS.fsLogDiskID = -2;
        this.noFS.fsMaxFiles = -2;
        this.noFS.fsUsedInodes = -2;
        this.noFS.fsFreeInodes = -2;
        this.noFS.fsPhysicalSize = -2L;
        this.noFS.fsCapacity = -2L;
        this.noFS.fsUsedSpace = -2L;
        this.noFS.fsFreeSpace = -2L;
        this.noFS.fsScanTime = 0L;
        this.noFS.fsType = (short)-1;
        this.noFS.fsUseCount = (short)-2;
        this.noFS.fsMountPoint = " ";
        this.noFS.fsDiscoveredTime = 0L;
        if (this.grr.reportSubtype != 21) {
            this.colNames = COL_NAMES;
            this.columnMap = null;
        } else {
            this.colNames = new String[6];
            this.colNames[0] = COMPUTER;
            this.colNames[1] = PATH;
            this.colNames[2] = LV_CAPACITY;
            this.colNames[3] = OVERHEAD;
            this.colNames[4] = TYPE;
            this.colNames[5] = PROBE_TIME;
            this.columnMap = new int[6];
            this.columnMap[0] = 0;
            this.columnMap[1] = 12;
            this.columnMap[2] = 6;
            this.columnMap[3] = 7;
            this.columnMap[4] = 11;
            this.columnMap[5] = 9;
        }
        this.frozenColumns = 2;
        int[] renderers = new int[COL_NAMES.length];
        renderers[2] = 7;
        renderers[3] = 7;
        renderers[4] = 7;
        renderers[5] = 7;
        renderers[6] = 7;
        renderers[7] = 7;
        renderers[8] = 1;
        renderers[9] = 1;
        renderers[10] = 1;
        if (this.grr.reportSubtype != 21) {
            this.rendererArray = renderers;
        } else {
            this.rendererArray = new int[this.columnMap.length];
            for (int i = 0; i < this.rendererArray.length; ++i) {
                this.rendererArray[i] = renderers[this.columnMap[i]];
            }
            renderers = null;
        }
        switch (this.grr.reportSubtype) {
            case 17: {
                this.firstColumn = 3;
                break;
            }
            case 18: {
                this.firstColumn = 9;
                break;
            }
            case 19: {
                this.firstColumn = 8;
                break;
            }
            case 37: {
                this.firstColumn = 10;
            }
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        if (this.bHasTotalRow) {
            this.shArray[0].shComputerName = MessageLog.getMessageNoID("STG4136L");
        }
        if (this.grr.reportSubtype == 2 || this.grr.reportSubtype == 20 || this.grr.reportSubtype == 21) {
            Arrays.sort(this.shArray, this.frozenRows, this.shArray.length, new Sorter());
        }
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.shArray = (Share[])dataArray;
        this.rowCount = this.shArray.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mLong = new MutableLong[this.rowCount];
        this.mDate = new Date[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            this.mDate[i] = new Date();
            this.mLong[i] = new MutableLong();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rowCount; ++i) {
            Share share = this.shArray[i];
            share.shLogicalDisk = (LogicalDisk)share.shResource;
            share.shFilesystem = share.shLogicalDisk.ldFilesystem;
            if (share.shFilesystem == null) {
                share.shFilesystem = this.noFS;
            } else {
                share.shFilesystem.fsPhysicalSize *= 512L;
                share.shFilesystem.fsCapacity *= 512L;
                share.shFilesystem.fsUsedSpace *= 512L;
                share.shFilesystem.fsFreeSpace *= 512L;
            }
            share.shLogicalDisk.ldCapacity *= 512L;
            share.shLogicalDisk.ldOverhead *= 512L;
            if (this.batch) continue;
            share.shComputerName = GuiUtil.getComputer((int)share.shComputerID).gcTSName;
        }
    }

    public void undo() {
        Share share = this.shArray[0];
        if (share.shFilesystem != this.noFS) {
            share.shFilesystem.fsPhysicalSize /= 512L;
            share.shFilesystem.fsCapacity /= 512L;
            share.shFilesystem.fsUsedSpace /= 512L;
            share.shFilesystem.fsFreeSpace /= 512L;
        }
        share.shLogicalDisk.ldCapacity /= 512L;
        share.shLogicalDisk.ldOverhead /= 512L;
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        int typeColumn = 11;
        if (this.columnMap != null) {
            typeColumn = -1;
            for (int i = 0; i < this.columnMap.length; ++i) {
                if (11 != this.columnMap[i]) continue;
                typeColumn = i;
                break;
            }
        }
        if (typeColumn >= 0) {
            colArray[typeColumn].cdValidValue = ColumnDescriptor.FSLV_TYPES;
        }
    }

    public Object getArray() {
        return this.shArray;
    }

    public int getNumberRows() {
        return this.shArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    private String displayedType(Share sh) {
        String[] array;
        int numericType;
        if (sh.shFilesystem != this.noFS) {
            numericType = sh.shFilesystem.fsType + 1;
            array = Filesystem.TYPES;
        } else {
            numericType = sh.shLogicalDisk.ldType;
            array = LogicalDisk.TYPES;
        }
        String result = " ";
        try {
            result = array[numericType];
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            // empty catch block
        }
        return result;
    }

    public Object getCellData(int row, int col) {
        int mappedColumn = this.columnMap == null ? col : this.columnMap[col];
        switch (mappedColumn) {
            case 0: {
                return this.shArray[row].shComputerName;
            }
            case 12: {
                return this.shArray[row].shPath;
            }
            case 1: {
                return this.shArray[row].shFilesystem.fsMountPoint;
            }
            case 11: {
                return this.displayedType(this.shArray[row]);
            }
            case 5: {
                this.mLong[row].value = this.shArray[row].shFilesystem.fsPhysicalSize;
                return this.mLong[row];
            }
            case 4: {
                this.mLong[row].value = this.shArray[row].shFilesystem.fsCapacity;
                return this.mLong[row];
            }
            case 2: {
                this.mLong[row].value = this.shArray[row].shFilesystem.fsUsedSpace;
                return this.mLong[row];
            }
            case 3: {
                this.mLong[row].value = this.shArray[row].shFilesystem.fsFreeSpace;
                return this.mLong[row];
            }
            case 6: {
                this.mLong[row].value = this.shArray[row].shLogicalDisk.ldCapacity;
                return this.mLong[row];
            }
            case 7: {
                this.mLong[row].value = this.shArray[row].shLogicalDisk.ldOverhead;
                return this.mLong[row];
            }
            case 9: {
                this.mDate[row].setTime(this.shArray[row].shScanTime);
                if (this.mDate[row].getTime() < 0L) {
                    return NA;
                }
                return this.mDate[row];
            }
            case 8: {
                this.mDate[row].setTime(this.shArray[row].shFilesystem.fsScanTime);
                if (this.mDate[row].getTime() < 0L) {
                    return NA;
                }
                return this.mDate[row];
            }
            case 10: {
                this.mDate[row].setTime(this.shArray[row].shFilesystem.fsDiscoveredTime);
                if (this.mDate[row].getTime() < 0L) {
                    return NA;
                }
                return this.mDate[row];
            }
        }
        return null;
    }

    private void addTotal() {
        this.bHasTotalRow = true;
        Share[] plusArray = new Share[this.rowCount + 1];
        Share shTotal = new Share();
        Filesystem fsTotal = new Filesystem();
        LogicalDisk ldTotal = new LogicalDisk();
        shTotal.shResource = ldTotal;
        ldTotal.ldFilesystem = fsTotal;
        shTotal.shPath = "";
        fsTotal.fsMountPoint = "";
        fsTotal.fsType = (short)-2;
        fsTotal.fsID = 777;
        plusArray[0] = shTotal;
        for (int ix = 0; ix < this.rowCount; ++ix) {
            LogicalDisk ldRow = (LogicalDisk)this.shArray[ix].shResource;
            Filesystem fsRow = ldRow.ldFilesystem;
            if (fsRow != null) {
                fsTotal.fsPhysicalSize += fsRow.fsPhysicalSize;
                fsTotal.fsCapacity += fsRow.fsCapacity;
                fsTotal.fsUsedSpace += fsRow.fsUsedSpace;
                fsTotal.fsFreeSpace += fsRow.fsFreeSpace;
            }
            ldTotal.ldCapacity += ldRow.ldCapacity;
            ldTotal.ldOverhead += ldRow.ldOverhead;
            plusArray[ix + 1] = this.shArray[ix];
        }
        this.shArray = plusArray;
        this.frozenRows = 1;
        ++this.rowCount;
    }

    public int[] getSelectedIDs() {
        if (this.grr.reportSubtype == 21) {
            return null;
        }
        int[] IDarray = new int[this.shArray.length];
        for (int i = 0; i < this.shArray.length; ++i) {
            Share shareRow = this.shArray[i];
            int objectID = shareRow.shFilesystem != null ? shareRow.shFilesystem.fsID : -1;
            IDarray[i] = objectID;
        }
        return IDarray;
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object o1, Object o2) {
            Share r1 = (Share)o1;
            Share r2 = (Share)o2;
            int x = r1.shComputerName.compareTo(r2.shComputerName);
            if (x > 0) {
                return 1;
            }
            if (x < 0) {
                return -1;
            }
            return r1.shFilesystem.fsMountPoint.compareTo(r2.shFilesystem.fsMountPoint);
        }
    }
}

