/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Grapher;
import org.eclipse.aperi.TStorm.common.PingAdjuster;
import org.eclipse.aperi.TStorm.common.PingReport;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.SpaceHistChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingGrapher
extends Grapher {
    String title;
    public static final byte CHART_AVAILABILITY = 101;
    public static final byte CHART_AVAILABILITY_X = 102;
    public static final String GRAPH_AVAILABILITY_SEL = "STG4121L";
    public static final String GRAPH_AVAILABILITY = "STG7554L";
    public static final String GRAPH_AVAILABILITY_ALL = "STG4122L";
    public static final String GRAPH_AVAILABILITY_HIST = "STG4123L";
    public static final String GRAPH_TRANSIT_TIME_HIST = "STG4124L";

    public String getChartType(GuiReportReq grr, ReportDataAdjuster pAdjuster) {
        if (grr.chartSubtype > 0) {
            return null;
        }
        this.title = grr.histSubtype == 6 ? GRAPH_AVAILABILITY_HIST : GRAPH_TRANSIT_TIME_HIST;
        return MessageLog.getMessageNoID(this.title);
    }

    public int graphsPerPage(GuiReportReq grr) {
        return 2;
    }

    public AperiChart processBatch(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, GuiChartSettingsReq gcsr) {
        AperiChart chart = null;
        if (grr.chartSubtype > 0) {
            chart = this.createChart(grr, pData, rows, pAdjuster, null, gcsr);
        } else {
            GuiReportReq newGrr = this.createHistory(grr, pData, rows, this.title);
            chart = (AperiChart)new SpaceHistChart().batch(newGrr, gcsr);
        }
        return chart;
    }

    public AperiCustomizableChart createChart(GuiReportReq grr, Object[] pData, int[] rows, ReportDataAdjuster pAdjuster, ReportingDDI ddi, GuiChartSettingsReq gcsr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(PingGrapher.class.getName(), "createChart", "grr, pData, rows, pAdjuster, ddi, gcsr");
        }
        PingReport[] data = (PingReport[])pData;
        PingAdjuster adjuster = (PingAdjuster)pAdjuster;
        int rowCount = rows.length;
        Number[][] chartY = new Number[2][rowCount];
        String[] pointL = new String[rowCount];
        String[] seriesL = new String[2];
        for (int r = 0; r < rowCount; ++r) {
            int row = rows[r];
            PingReport dataRow = data[row];
            chartY[0][r] = new Double(dataRow.pngReceived);
            chartY[1][r] = new Double(dataRow.pngTransmitted - dataRow.pngReceived);
            pointL[r] = this.getRowName(data, row, adjuster);
        }
        seriesL[0] = MessageLog.getMessageNoID("STG4125L");
        seriesL[1] = MessageLog.getMessageNoID("STG4126L");
        ChartOptions options = new ChartOptions();
        options.chartType = 7;
        AperiCustomizableChart chart = new AperiCustomizableChart(6, 7, chartY, seriesL, pointL, options, grr);
        if (ddi != null) {
            ddi.addChart(grr, chart, "");
        }
        AperiCustomizableChart traceResult = chart;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(PingGrapher.class.getName(), "createChart", traceResult);
        }
        return traceResult;
    }

    public GuiReportReq createHistory(GuiReportReq grr, Object[] pData, int[] rows, String actionCommand) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(PingGrapher.class.getName(), "createHistory", "grr, pData, rows, actionCommand");
        }
        PingReport[] tableData = (PingReport[])pData;
        GuiReportReq newGrr = grr.explode(-1);
        newGrr.reportSubtype = grr.reportSubtype;
        newGrr.idSubtype = -1;
        SpaceHistChart.initLegend(newGrr);
        newGrr.selectedResources = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            PingReport dataRow = tableData[rows[i]];
            newGrr.selectedResources[i] = dataRow.prID;
            SpaceHistChart.addLegend(newGrr, dataRow.prName1, dataRow.getPrName2(), dataRow.prID);
        }
        if (actionCommand == GRAPH_AVAILABILITY_HIST) {
            newGrr.chartLabelType = (byte)8;
            newGrr.histSubtype = (byte)6;
            newGrr.historyTitle = GRAPH_AVAILABILITY_HIST;
        } else {
            newGrr.chartLabelType = (byte)3;
            newGrr.histSubtype = (byte)7;
            newGrr.historyTitle = GRAPH_TRANSIT_TIME_HIST;
        }
        newGrr.reportSubtypeOrig = grr.reportSubtype;
        newGrr.reportSubtype = 28;
        GuiReportReq traceResult = newGrr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(PingGrapher.class.getName(), "createHistory", traceResult);
        }
        return traceResult;
    }

    public String getRowName(PingReport[] tableData, int row, PingAdjuster adjuster) {
        StringBuffer buffer = new StringBuffer(64);
        if (adjuster.frozenColumns > 0) {
            buffer.append(tableData[row].prName1);
            if (adjuster.frozenColumns > 1) {
                buffer.append('.');
                buffer.append(tableData[row].getPrName2());
            }
            buffer.append(' ');
            return buffer.toString();
        }
        return MessageLog.getMessageNoID("STG5048L");
    }
}

