/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class ProbePing
extends ScheduleHeader {
    static final long serialVersionUID = -2817533105300124997L;
    public static final int PING_PINGS = 0;
    public static final int PING_MINUTES = 1;
    public static final int PING_HOURS = 2;
    public static final int PING_DAYS = 3;
    public NameList pbComputers;
    public NameList pbComputerGroups;
    public NameList pbClusters;
    public NameList pbDiskArrays;
    public NameList pbDiskArrayGroups;
    public NameList pbFabrics;
    public NameList pbFabricGroups;
    public NameList pbLibraries;
    public NameList pbLibrariesGroups;
    public boolean pbAllLibraries;
    public boolean pbAllComputers;
    public boolean pbAllDiskArrays;
    public boolean pbAllFabrics;
    public NameList pbSnmpCommunities;
    public AlertDefinition pbAlert;
    public NameList pbManualSlpDAs;
    public NameList pbSnmpIPAddresses;
    public String pbBrocadeUserName;
    public String pbBrocadePassword;
    public boolean validateIPs = false;

    public ProbePing(short pJobType) {
        this.jobType = pJobType;
    }

    private boolean communitiesEqual(ProbePing other) {
        NameList otherComm;
        int count = 0;
        boolean equal = true;
        NameList thisComm = this.pbSnmpCommunities;
        while (equal && thisComm != null) {
            String community = thisComm.nlName;
            otherComm = other.pbSnmpCommunities;
            while (otherComm != null && !community.equals(otherComm.nlName)) {
                otherComm = otherComm.nlNext;
            }
            if (otherComm == null) {
                equal = false;
                continue;
            }
            ++count;
            thisComm = thisComm.nlNext;
        }
        if (equal) {
            otherComm = other.pbSnmpCommunities;
            while (otherComm != null) {
                --count;
                otherComm = otherComm.nlNext;
            }
            if (count != 0) {
                equal = false;
            }
        }
        return equal;
    }

    public boolean equals(Object pOther) {
        if (!super.equals(pOther)) {
            return false;
        }
        ProbePing other = (ProbePing)pOther;
        return AlertDefinition.alertDefsEqual(this.pbAlert, other.pbAlert) && NameList.nameListsEqual(this.pbComputers, other.pbComputers) && NameList.nameListsEqual(this.pbComputerGroups, other.pbComputerGroups) && this.pbAllComputers == other.pbAllComputers && NameList.nameListsEqual(this.pbDiskArrays, other.pbDiskArrays) && NameList.nameListsEqual(this.pbDiskArrayGroups, other.pbDiskArrayGroups) && this.pbAllDiskArrays == other.pbAllDiskArrays && NameList.nameListsEqual(this.pbFabrics, other.pbFabrics) && NameList.nameListsEqual(this.pbFabricGroups, other.pbFabricGroups) && this.pbAllFabrics == other.pbAllFabrics && NameList.nameListsEqual(this.pbLibraries, other.pbLibraries) && NameList.nameListsEqual(this.pbLibrariesGroups, other.pbLibrariesGroups) && this.pbAllLibraries == other.pbAllLibraries && this.communitiesEqual(other) && Util.stringsEqual(this.pbBrocadeUserName, other.pbBrocadeUserName) && Util.stringsEqual(this.pbBrocadePassword, other.pbBrocadePassword) && NameList.nameMasksListsEqual(this.pbManualSlpDAs, other.pbManualSlpDAs) && NameList.nameMasksListsEqual(this.pbSnmpIPAddresses, other.pbSnmpIPAddresses) && NameList.nameListsEqual(this.pbClusters, other.pbClusters);
    }

    public Object clone() {
        ProbePing result = (ProbePing)super.clone();
        result.pbComputers = NameList.cloneNameList(this.pbComputers);
        result.pbComputerGroups = NameList.cloneNameList(this.pbComputerGroups);
        result.pbClusters = NameList.cloneNameList(this.pbClusters);
        result.pbDiskArrays = NameList.cloneNameList(this.pbDiskArrays);
        result.pbDiskArrayGroups = NameList.cloneNameList(this.pbDiskArrayGroups);
        result.pbFabrics = NameList.cloneNameList(this.pbFabrics);
        result.pbFabricGroups = NameList.cloneNameList(this.pbFabricGroups);
        result.pbLibraries = NameList.cloneNameList(this.pbLibraries);
        result.pbLibrariesGroups = NameList.cloneNameList(this.pbLibrariesGroups);
        result.pbSnmpCommunities = NameList.cloneNameList(this.pbSnmpCommunities);
        result.pbManualSlpDAs = NameList.cloneNameList(this.pbManualSlpDAs);
        result.pbSnmpIPAddresses = NameList.cloneNameList(this.pbSnmpIPAddresses);
        if (this.pbAlert != null) {
            result.pbAlert = (AlertDefinition)this.pbAlert.clone();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.pbComputers == null && this.pbComputerGroups == null && this.pbClusters == null && !this.pbAllComputers && this.pbDiskArrays == null && this.pbDiskArrayGroups == null && !this.pbAllDiskArrays && this.pbFabrics == null && this.pbFabricGroups == null && !this.pbAllFabrics && this.pbManualSlpDAs == null && this.pbSnmpIPAddresses == null && this.pbBrocadeUserName == null && this.pbBrocadePassword == null && this.pbLibraries == null && this.pbLibrariesGroups == null && !this.pbAllLibraries;
    }
}

