/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.common.MutableByte;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.AlertLogTablePrintAdjuster;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.ExtAlertLog;

public abstract class BaseAlertLogTableData
extends BaseTableModel
implements AlertLogTable.AlertLogTableAdjuster {
    public ExtAlertLog[] array;
    protected Date[] dateArray;
    protected MutableInteger[] intArray;
    protected MutableByte[] byteArray;

    public BaseAlertLogTableData(AlertLogTable logTable, ExtAlertLog[] pArray) {
        this.array = pArray;
        Arrays.sort(this.array, new Sorter());
        this.rowCount = this.array.length;
        this.dateArray = new Date[this.rowCount];
        this.intArray = new MutableInteger[this.rowCount];
        this.byteArray = new MutableByte[this.rowCount];
        for (int index = 0; index < this.rowCount; ++index) {
            this.dateArray[index] = new Date();
            this.intArray[index] = new MutableInteger();
            this.byteArray[index] = new MutableByte();
        }
        this.commonAdjuster = new AlertLogTablePrintAdjuster(this);
    }

    protected MutableByte byteToObject(int row, byte b) {
        this.byteArray[row].value = b;
        return this.byteArray[row];
    }

    protected MutableInteger intToObject(int row, int i) {
        this.intArray[row].value = i;
        return this.intArray[row];
    }

    protected Date timestampToObject(int row, long timestamp) {
        this.dateArray[row].setTime(timestamp);
        return this.dateArray[row];
    }

    public String[] getLabels() {
        return this.columnNames;
    }

    public int getNumberRows() {
        return this.array.length;
    }

    public abstract Object getTableDataItem(int var1, int var2);

    public abstract void hideColumns(MegaTable var1);

    public abstract int[] getRenderers();

    public abstract int[] getHiddenColumns();

    private static class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object o1, Object o2) {
            ExtAlertLog r1 = (ExtAlertLog)o1;
            ExtAlertLog r2 = (ExtAlertLog)o2;
            if (r1.alState > r2.alState) {
                return 1;
            }
            if (r1.alState < r2.alState) {
                return -1;
            }
            if (r1.alLastAlertTime < r2.alLastAlertTime) {
                return 1;
            }
            if (r1.alLastAlertTime > r2.alLastAlertTime) {
                return -1;
            }
            return 0;
        }
    }
}

