/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList memberSelections;
    private NameList groupSelections;
    private NameList clusterSelections;
    private NameList rootName;
    private short memberType;
    private short groupType;
    private TreeSet memberSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private String groupRootLabel;
    private String memberRootLabel;
    private String allMembersLabel;
    private String clustersRootLabel;
    private TreeSelectorNode sourceGroupLabel;
    private TreeSelectorNode sourceClusterLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    public boolean allMembersSelected;
    private boolean excludeNAS;
    private boolean getVersions;
    private boolean includeClusters;
    private boolean excludeVS;
    private boolean clusterExpanding = false;
    private boolean groupExpanding = false;
    private static final int ROOT_ID = -6;
    private static final int GROUP_ID = -5;
    private static final int MEMBER_ID = -4;
    private static final int CLUSTER_ID = -3;
    private static final int ALL_MEMBER_ID = Integer.MAX_VALUE;

    public ComputerGroupSelector(short pMemberType, NameList pMemberSelections, NameList pGroupSelections, NameList pClusterSelections, boolean pAllMembersSelected) {
        this.memberType = pMemberType;
        this.memberSelections = pMemberSelections;
        this.groupSelections = pGroupSelections;
        this.clusterSelections = pClusterSelections;
        this.allMembersSelected = pAllMembersSelected;
        this.excludeNAS = false;
        this.getVersions = false;
        this.clustersRootLabel = "LABEL_CLUSTERS";
        this.includeClusters = true;
        this.excludeVS = false;
        this.groupType = 0;
        this.memberRootLabel = "STG4041L";
        this.groupRootLabel = "STG3012L";
        this.allMembersLabel = "STG3100L";
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList prevMember = null;
        NameList prevGroup = null;
        NameList prevCluster = null;
        NameList[] returnLists = new NameList[]{null, null, null, null};
        this.allMembersSelected = false;
        NameList selectedList = this.selector.getNameList();
        while (selectedList != null) {
            NameList cloan = (NameList)selectedList.clone();
            cloan.nlNext = null;
            if (cloan.nlInfo == this.groupType) {
                if (prevGroup == null) {
                    returnLists[1] = cloan;
                } else {
                    prevGroup.nlNext = cloan;
                }
                prevGroup = cloan;
            } else if (cloan.nlInfo == 13) {
                this.allMembersSelected = true;
            } else if (cloan.nlInfo == 99) {
                if (prevCluster == null) {
                    returnLists[2] = cloan;
                } else {
                    prevCluster.nlNext = cloan;
                }
                prevCluster = cloan;
            } else {
                if (prevMember == null) {
                    returnLists[0] = cloan;
                } else {
                    prevMember.nlNext = cloan;
                }
                prevMember = cloan;
            }
            selectedList = selectedList.nlNext;
        }
        return returnLists;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        this.sourceGroupLabel = this.addGroupLabel(root);
        this.addMemberLabel(root);
        if (this.includeClusters) {
            this.sourceClusterLabel = this.addClusterLabel(root);
        }
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode groupLabel = null;
        TreeSelectorNode memberLabel = null;
        TreeSelectorNode excludeLabel = null;
        TreeSelectorNode clustersLabel = null;
        TreeSelectorNode root = this.newRoot();
        NameList name = this.clusterSelections;
        while (name != null) {
            if (clustersLabel == null) {
                clustersLabel = this.addClusterLabel(root);
            }
            clustersLabel.add(new TreeSelectorNode(name, true, false, true, true, null, false, this.includeClusters));
            name = name.nlNext;
        }
        name = this.groupSelections;
        while (name != null) {
            if (groupLabel == null) {
                groupLabel = this.addGroupLabel(root);
            }
            groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null, this.includeClusters, this.includeClusters));
            name = name.nlNext;
        }
        this.fillSets(this.memberSelections, true, false);
        if (this.allMembersSelected || !this.memberSet.isEmpty()) {
            memberLabel = this.addMemberLabel(root);
            if (this.allMembersSelected) {
                this.addAllMembersNode(memberLabel, true);
            }
            this.addTreeSet(memberLabel, this.memberSet);
        }
        if (!this.excludeSet.isEmpty()) {
            excludeLabel = TreeSelector.makeExcludeRoot();
            root.add(excludeLabel);
            this.addTreeSet(excludeLabel, this.excludeSet);
        }
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList pMemberSelections, NameList pGroupSelections, NameList pClusterSelections, boolean pAllMembersSelected) {
        this.memberSelections = pMemberSelections;
        this.groupSelections = pGroupSelections;
        this.clusterSelections = pClusterSelections;
        this.allMembersSelected = pAllMembersSelected;
        this.memberSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        this.selectedTree.setModel(model);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList memberList, boolean memberSelectable, boolean memberExcludeable) {
        TreeSelectorNode member = null;
        boolean showClusterName = this.includeClusters;
        boolean showVsName = this.includeClusters;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if ((memberList.nlState & 1) != 0) {
                set = this.excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = this.memberSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            if (this.clusterExpanding) {
                showClusterName = false;
                selectable = false;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, showClusterName, showVsName);
            if (this.clusterExpanding || this.groupExpanding) {
                member.setButtonFlag(false);
            }
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public void invalidateGroups(short groupType) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    public void addGroup(NameList name) {
        if (!this.sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, this.sourceGroupLabel, newNode);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        this.clusterExpanding = false;
        this.groupExpanding = false;
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (name.nlID == -5) {
                this.sendRequest(this.groupType, -1);
            } else if (name.nlID == -4) {
                this.sendRequest(this.memberType, -1);
            } else if (name.nlID == -3) {
                this.sendRequest((short)101, -1);
            }
        } else if (name.nlInfo == this.groupType) {
            this.sendRequest(this.memberType, name.nlID);
            this.groupExpanding = true;
        } else if (name.nlInfo == 99) {
            this.clusterExpanding = true;
            this.sendRequest(name.nlInfo, name.nlID);
        } else if (name.nlInfo == 13) {
            this.sendRequest(this.memberType, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    protected GuiListReq makeListRequestData(short resourceType, int groupID) {
        GuiListReq requestData = new GuiListReq();
        if (resourceType == 99) {
            requestData.listRequested = 11;
        } else {
            if (resourceType == 101) {
                resourceType = (short)99;
            }
            requestData.listRequested = 10000 + resourceType;
            requestData.groupID = groupID;
        }
        if (this.excludeNAS) {
            requestData.excludeNAS = true;
        }
        if (this.excludeVS) {
            requestData.excludeVS = true;
        }
        if (this.getVersions) {
            requestData.getVersions = true;
            requestData.excludeVS = true;
        }
        return requestData;
    }

    protected GroupDefinition makeGroupRequestData(short resourceType, int groupID) {
        GroupDefinition requestData = new GroupDefinition();
        requestData.groupType = resourceType;
        requestData.ID = groupID;
        return requestData;
    }

    private void sendRequest(short resourceType, int groupID) {
        Request request;
        if (resourceType == 99) {
            GroupDefinition lData = this.makeGroupRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", lData);
        } else {
            GuiListReq gData = this.makeListRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", gData);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        boolean showClusterName = this.includeClusters;
        boolean showVsName = this.includeClusters;
        Serializable obj = response.responseData;
        NameList nameList = null;
        if (obj instanceof GroupDefinition) {
            GroupDefinition gdef = (GroupDefinition)response.responseData;
            nameList = gdef.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == this.groupType || nameList.nlInfo == 99) {
            if (nameList.nlInfo == 99) {
                showClusterName = false;
            }
            while (nameList != null) {
                TreeSelectorNode group = new TreeSelectorNode(nameList, true, false, false, true, null, showClusterName, showVsName);
                this.expansionNode.add(group);
                nameList = nameList.nlNext;
            }
        } else {
            boolean exclude;
            boolean select = this.expansionTree == this.sourceTree;
            boolean bl = exclude = !select;
            if (select) {
                this.addAllMembersNode(this.expansionNode, false);
            }
            this.memberSet.clear();
            this.fillSets(nameList, select, exclude);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -6, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.groupRootLabel, -5, root);
    }

    private TreeSelectorNode addClusterLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.clustersRootLabel, -3, root);
    }

    private TreeSelectorNode addMemberLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.memberRootLabel, -4, root);
    }

    private TreeSelectorNode addLabelNode(String labelMsgID, int id, TreeSelectorNode root) {
        String label = Util.getString(labelMsgID);
        NameList name = this.newNameList(label, id, -1);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllMembersNode(TreeSelectorNode root, boolean expandable) {
        String label = MessageLog.getMessageNoID(this.allMembersLabel);
        NameList name = this.newNameList(label, Integer.MAX_VALUE, 13);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        root.add(node);
    }

    private NameList newNameList(String name, int id, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        return nameList;
    }
}

