/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTable;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTableDialog;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiSelectionReq;
import org.eclipse.aperi.TStorm.server.guireq.RespSelectionObject;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataReportingSelectionTable
extends ReportingSelectionTable {
    short quotaType;
    short members;
    GuiSelectionReq gsr;
    RespSelectionObject[] nodeArray;
    RespSelectionObject node;
    boolean byNetwork;

    public DataReportingSelectionTable(ReportingSelectionTableDialog pDialog, GuiReportReq grr, int reportSubtype, Object[] objectName) {
        super(pDialog, grr, reportSubtype, objectName);
        switch (reportSubtype) {
            case 10: {
                this.objectType = 3;
                break;
            }
            case 11: {
                this.objectType = 4;
                break;
            }
            case 12: {
                if (grr.reportType == 5) {
                    this.objectType = 29;
                    break;
                }
                this.objectType = 5;
                break;
            }
            case 13: {
                this.objectType = 6;
                break;
            }
            case 82: {
                this.objectType = 28;
                break;
            }
            case 14: {
                this.objectType = 7;
                break;
            }
            case 27: {
                this.objectType = 11;
                break;
            }
            case 74: {
                this.objectType = 24;
                break;
            }
            case 77: 
            case 89: 
            case 90: {
                this.objectType = 24;
                break;
            }
            case 75: {
                this.objectType = 25;
                break;
            }
            case 76: {
                this.objectType = 26;
                break;
            }
            case 73: {
                this.objectType = 27;
            }
        }
        if (this.objectType == -1) {
            this.status = -1;
        }
    }

    protected Request getRequest() {
        Request request = new Request();
        GuiRequest.selectionList(request);
        this.gsr = (GuiSelectionReq)request.requestData;
        this.gsr.objectType = this.objectType;
        this.gsr.reportType = this.grr.reportType;
        this.gsr.quotaType = this.quotaType;
        this.gsr.productCode = this.grr.productCode;
        this.gsr.dbmsType = this.grr.dbmsType;
        this.gsr.quotaMembers = this.members;
        return request;
    }

    public void handleResponse(short responseStatus, Response response) {
        if (responseStatus > 4) {
            this.status = -1;
        } else {
            int count;
            this.gsr = (GuiSelectionReq)response.responseData;
            this.nodeArray = this.gsr.objectHdr;
            if (this.nodeArray != null) {
                for (count = 0; count < this.nodeArray.length; ++count) {
                    this.node = this.nodeArray[count];
                    if (this.gsr.computerColumn <= 0 || this.node.CID <= 0) continue;
                    if (this.gsr.appendUserComputerColumn > 0) {
                        this.node.stringArray[this.gsr.computerColumn] = this.node.stringArray[this.gsr.computerColumn] + " @ " + GuiUtil.getComputer((int)this.node.CID).gcTSName;
                        continue;
                    }
                    this.node.stringArray[this.gsr.computerColumn] = GuiUtil.getComputer((int)this.node.CID).gcTSName;
                }
            }
            if (count != 0) {
                this.status = 2;
            } else {
                this.status = -1;
                GuiUtil.displayErrorMessage(MessageLog.getMessageNoTS("STG5011L", this.objectName));
            }
        }
        this.dialog.show();
    }

    protected int getCountValue() {
        return this.nodeArray.length;
    }

    protected void sortData() {
        if (this.gsr.sortColumns > 0) {
            int[] cols = new int[this.gsr.sortColumns];
            int[] order = new int[this.gsr.sortColumns];
            for (int ix = 0; ix < this.gsr.sortColumns; ++ix) {
                cols[ix] = ix + 1;
                order[ix] = 1;
            }
            this.table.sortByColumn(cols[0], order[0]);
        }
    }

    public void selectRows(boolean redraw) {
        if (this.reportSubtype == 30 || this.reportSubtype == 31 || this.reportSubtype == 88) {
            this.selectRows(this.grr.selectedUsers, this.grr.isUserInList);
        } else {
            this.selectRows(this.grr.selectedResources, this.grr.isResourceInList);
        }
        if (redraw) {
            this.dataModel.fireTableDataChanged();
        }
    }

    protected void selectRows(int[] prevArray, boolean isInList) {
        if (prevArray == null) {
            isInList = false;
        }
        block0: for (int ix = 0; ix < this.nodeArray.length; ++ix) {
            boolean bl = this.nodeArray[ix].selected = !isInList;
            if (prevArray == null) continue;
            for (int ix2 = 0; ix2 < prevArray.length; ++ix2) {
                if (prevArray[ix2] != this.nodeArray[ix].ID) continue;
                this.nodeArray[ix].selected = isInList;
                continue block0;
            }
        }
    }

    public void setArray() throws GeneralException {
        int[] intArray = null;
        boolean error = false;
        boolean isInList = true;
        if (this.nodeArray == null) {
            error = true;
        } else {
            int selected = 0;
            for (int ix = 0; ix < this.nodeArray.length; ++ix) {
                if (!this.nodeArray[ix].selected) continue;
                ++selected;
            }
            if (selected == 0) {
                error = true;
            } else if (selected < this.nodeArray.length) {
                int notSelected = this.nodeArray.length - selected;
                isInList = selected <= 100 || selected < notSelected;
                intArray = new int[isInList ? selected : notSelected];
                int ix2 = 0;
                for (int ix = 0; ix < this.nodeArray.length; ++ix) {
                    if (this.nodeArray[ix].selected != isInList) continue;
                    intArray[ix2] = this.nodeArray[ix].ID;
                    ++ix2;
                }
            }
        }
        if (error) {
            String s = MessageLog.getMessageNoTS("STG5038L", this.objectName);
            throw new GeneralException(s);
        }
        if (this.reportSubtype == 30 || this.reportSubtype == 31 || this.reportSubtype == 88) {
            this.grr.selectedUsers = intArray;
            this.grr.isUserInList = isInList;
        } else {
            this.grr.selectedResources = intArray;
            this.grr.isResourceInList = isInList;
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.selectButton) {
            for (int index = 0; index < this.nodeArray.length; ++index) {
                this.nodeArray[index].selected = true;
            }
        } else if (source == this.clearButton) {
            for (int index = 0; index < this.nodeArray.length; ++index) {
                this.nodeArray[index].selected = false;
            }
        }
        this.getDataModel().fireTableDataChanged();
    }

    protected BaseTableModel getDataModel() {
        return new SelectionModel();
    }

    protected boolean isSelectedRow(int row) {
        return this.nodeArray[row].selected;
    }

    protected void setSelectedRow(int row, boolean selected) {
        this.nodeArray[row].selected = selected;
    }

    public boolean selectionChanged() {
        return this.grr.selectedResources != null || this.grr.selectedUsers != null;
    }

    class SelectionModel
    extends BaseTableModel {
        public SelectionModel() {
            this.columnNames = DataReportingSelectionTable.this.gsr.nameArray;
            this.rowCount = DataReportingSelectionTable.this.nodeArray.length;
        }

        public Object getTableDataItem(int rowNum, int colNum) {
            if (colNum == 0) {
                return new Boolean(DataReportingSelectionTable.this.nodeArray[rowNum].selected);
            }
            if (DataReportingSelectionTable.this.gsr.typeArray[colNum] == 1) {
                return Util.getTranslatedName(DataReportingSelectionTable.this.nodeArray[rowNum].stringArray[colNum]);
            }
            if (DataReportingSelectionTable.this.gsr.typeArray[colNum] == 2) {
                DataReportingSelectionTable.this.mLong[rowNum].value = DataReportingSelectionTable.this.nodeArray[rowNum].longArray[colNum];
                return DataReportingSelectionTable.this.mLong[rowNum];
            }
            if (DataReportingSelectionTable.this.gsr.typeArray[colNum] == 3) {
                DataReportingSelectionTable.this.mInt[rowNum].value = (int)DataReportingSelectionTable.this.nodeArray[rowNum].longArray[colNum];
                return DataReportingSelectionTable.this.mInt[rowNum];
            }
            return null;
        }
    }
}

