/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.TStorm.gui.DiscoveryCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.HistoryHelper;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiscoveryTreeNode
extends BaseTreeNode
implements ActionListener,
GuiRequestor {
    private static final String label = MessageLog.getMessageNoID("STG4091L");
    private static final String RUN_NOW = "R";
    private static final String EDIT = "E";
    private static final String HISTORY = "H";
    private static final String REFRESH = "F";
    private JMenuItem runNow;
    private JMenuItem edit;
    private JMenuItem history;
    private JMenuItem refresh;
    private HistoryHelper historyHelper;

    public DiscoveryTreeNode() {
        super(label, true);
        String s = MessageLog.getMessageNoID("JSS1002L");
        this.runNow = new JMenuItem(s);
        this.runNow.setActionCommand(RUN_NOW);
        this.runNow.addActionListener(this);
        this.runNow.setEnabled(DiscoveryTreeNode.guiMain.getUserPrefs().administrator);
        s = MessageLog.getMessageNoID("GUI0046L");
        this.edit = new JMenuItem(s);
        this.edit.setActionCommand(EDIT);
        this.edit.addActionListener(this);
        s = MessageLog.getMessageNoID("GUI0052L");
        this.history = new JMenuItem(s);
        this.history.setActionCommand(HISTORY);
        this.history.addActionListener(this);
        s = MessageLog.getMessageNoID("STG0003L");
        this.refresh = new JMenuItem(s);
        this.refresh.setActionCommand(REFRESH);
        this.refresh.addActionListener(this);
        this.historyHelper = new HistoryHelper(this, label, 100);
    }

    public void showPopupMenu(MouseEvent event) {
        JPopupMenu menu = this.getPopupMenu();
        menu.add(this.edit);
        menu.add(this.refresh);
        menu.add(this.history);
        menu.add(this.runNow);
        this.showPopupMenu(menu, event);
    }

    private void submitToRun() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
        request.flags = (byte)4;
        NameList element = new NameList();
        element.nlID = 100;
        element.nlInfo = (short)32;
        request.requestData = element;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        Object[] args = new Object[]{MessageLog.getMessageNoID("STG3197L"), null};
        JSgcScheduleCreateWhenData.displayJobSubmittedMessage(args);
    }

    private void createEditor() {
        CreateOrEditDDI ddi = new CreateOrEditDDI();
        ddi.buildEditor(DiscoveryCreateOrEdit.class, "", 100, (short)32);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command == RUN_NOW) {
            this.submitToRun();
        } else if (command == EDIT) {
            this.createEditor();
        } else if (command == HISTORY) {
            this.historyHelper.makeRunDDI();
        } else if (command == REFRESH) {
            this.historyHelper.sendRequest();
        }
    }

    public void select(TreeSelectionEvent event) {
        this.createEditor();
    }

    public void expand(TreeExpansionEvent ignored) {
        if (this.getChildCount() == 0) {
            this.historyHelper.sendRequest();
        }
    }
}

