/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.DiskCapacityAdjuster;
import org.eclipse.aperi.TStorm.common.DiskCapacityGrapher;
import org.eclipse.aperi.TStorm.gui.DiskDDI;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskCapacityTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    DiskCapacityModel diskCapacityModel;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespFSspace[] data;
    private DiskCapacityAdjuster adjuster;
    private DiskCapacityGrapher grapher;
    private TJCTableMouseAdapter myMouseListener = new SelectListener();

    public DiskCapacityTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.setLayout(new BorderLayout());
        this.adjuster = new DiskCapacityAdjuster(grr);
        this.grapher = new DiskCapacityGrapher();
        this.grapher.setLegend(grr);
    }

    public void handleResponse(short status, Response response) {
        this.data = status <= 4 ? (RespFSspace[])response.responseData : null;
        int cnt = this.data != null ? this.data.length : 0;
        if (cnt == 0) {
            this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespFSspace[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.diskCapacityModel = new DiskCapacityModel();
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setFrozenRows(this.adjuster.frozenRows);
        if (this.grr.reportSubtype == 15) {
            this.table.setRowIcon(11, true);
        } else {
            this.table.setRowIcon(10, true);
            this.table.iconChanger = this.diskCapacityModel;
        }
        int[] hiddenColumns = this.adjuster.getHiddenColumns();
        if (hiddenColumns != null) {
            for (int i = 0; i < hiddenColumns.length; ++i) {
                this.table.setColumnHidden(hiddenColumns[i], true);
            }
        }
        this.table.setBaseTableModel(this.diskCapacityModel);
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public void showJumpChart() {
        String command = this.grr.reportSubtype == 15 ? "STG5525L" : "STG1294T";
        ActionEvent event = new ActionEvent(this, 777, command);
        ((ActionListener)((Object)this.myMouseListener)).actionPerformed(event);
    }

    public DiskCapacityTable(String a, String b, String c, String d) {
    }

    public Object[] getChoices(int reportType, int reportSubtype) {
        Object[] array = new Object[3];
        String[] messageArray = new String[]{"STG7530L", "STG7531L", "STG7555L"};
        byte[] labelArray = new byte[]{1, 8, 1};
        byte[] reportArray = new byte[]{1, 2, 5};
        array[0] = messageArray;
        array[1] = labelArray;
        array[2] = reportArray;
        return array;
    }

    public Object[] getCharts(int reportType, int reportSubtype) {
        Object[] array = new Object[2];
        if (reportSubtype == 15) {
            String[] messageArray = new String[]{"STG5525L", "STG7529L"};
            byte[] reportArray = new byte[]{103, 104};
            array[0] = messageArray;
            array[1] = reportArray;
        } else {
            String[] messageArray = new String[]{"STG1294T"};
            byte[] reportArray = new byte[]{101};
            array[0] = messageArray;
            array[1] = reportArray;
        }
        return array;
    }

    public int[] getGraphID(String selectedCommand) {
        int[] array = new int[2];
        array[0] = selectedCommand == "STG5556T" ? 101 : (selectedCommand == "STG1294T" ? 102 : (selectedCommand == "STG5525L" ? 103 : (selectedCommand == "STG5524L" ? 104 : (selectedCommand == "STG5105L" ? 1 : (selectedCommand == "STG5106L" ? 2 : 5)))));
        return array;
    }

    public class SelectListener
    extends TJCTableMouseAdapter
    implements ActionListener {
        public boolean select(int viewRow, int viewCol) {
            return viewRow >= ((DiskCapacityTable)DiskCapacityTable.this).adjuster.frozenLabels;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if (dataRow < 0 || DiskCapacityTable.this.adjuster.hasTotalsRow() && dataRow == 0) {
                return;
            }
            if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype == 82) {
                GuiReportReq newGrr = DiskCapacityTable.this.grr.explode(((DiskCapacityTable)DiskCapacityTable.this).data[dataRow].id);
                DiskCapacityTable.this.ddi.addReport(DiskCapacityTable.this.grr, newGrr, DiskCapacityTable.this.data[dataRow].getName());
            } else if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype != 27) {
                GuiReportReq newGrr = DiskCapacityTable.this.grr.explode(((DiskCapacityTable)DiskCapacityTable.this).data[dataRow].id);
                if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportType == 72) {
                    newGrr.reportType = 8;
                    newGrr.reportSubtype = 27;
                }
                DiskCapacityTable.this.ddi.addReport(DiskCapacityTable.this.grr, newGrr, Util.getDotName(((DiskCapacityTable)DiskCapacityTable.this).data[dataRow].creator, DiskCapacityTable.this.data[dataRow].getName()));
            } else if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype == 27) {
                new DiskDDI(null, ((DiskCapacityTable)DiskCapacityTable.this).data[dataRow].fs_id, DiskCapacityTable.this.data[dataRow].getName(), ((DiskCapacityTable)DiskCapacityTable.this).data[dataRow].id);
            }
        }

        public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
            JMenuItem mi;
            boolean showPopup = false;
            if (DiskCapacityTable.this.data != null && DiskCapacityTable.this.data.length > 0) {
                showPopup = true;
            }
            boolean rowsSelected = DiskCapacityTable.this.table.rowsSelected();
            JPopupMenu menu = new JPopupMenu();
            if (((DiskCapacityTable)DiskCapacityTable.this).grr.reportSubtype == 15) {
                mi = menu.add(MessageLog.getMessageNoID("STG5525L"));
                mi.setEnabled(showPopup);
                mi.setActionCommand("STG5525L");
                mi.addActionListener(this);
                mi = menu.add(MessageLog.getMessageNoID("STG5524L"));
                mi.setEnabled(showPopup);
                mi.setActionCommand("STG5524L");
                mi.addActionListener(this);
            } else {
                mi = menu.add(MessageLog.getMessageNoID("STG5556T"));
                mi.setActionCommand("STG5556T");
                mi.setEnabled(rowsSelected);
                mi.addActionListener(this);
                mi = menu.add(MessageLog.getMessageNoID("STG1294T"));
                mi.setEnabled(showPopup);
                mi.setActionCommand("STG1294T");
                mi.addActionListener(this);
            }
            menu.addSeparator();
            mi = menu.add(MessageLog.getMessageNoID("STG5105L"));
            mi.setActionCommand("STG5105L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5106L"));
            mi.setActionCommand("STG5106L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            mi = menu.add(MessageLog.getMessageNoID("STG5109L"));
            mi.setActionCommand("STG5109L");
            mi.setEnabled(rowsSelected);
            mi.addActionListener(this);
            menu.show(c, x, y);
            menu.requestFocus();
        }

        public void showDefaultChart(int dataRow) {
            int[] ix = DiskCapacityTable.this.getGraphID("STG5525L");
            ((DiskCapacityTable)DiskCapacityTable.this).grr.chartSubtype = (byte)ix[0];
            DiskCapacityTable.this.grapher.createPieChart(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, DiskCapacityTable.this.adjuster, DiskCapacityTable.this.ddi, null);
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows;
            String actionCommand = e.getActionCommand();
            if (actionCommand == "STG5525L") {
                int[] ix = DiskCapacityTable.this.getGraphID("STG5525L");
                ((DiskCapacityTable)DiskCapacityTable.this).grr.chartSubtype = (byte)ix[0];
                DiskCapacityTable.this.grapher.createPieChart(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, DiskCapacityTable.this.adjuster, DiskCapacityTable.this.ddi, null);
                return;
            }
            if (actionCommand == "STG1294T" || actionCommand == "STG5524L") {
                rows = DiskCapacityTable.this.adjuster.hasTotalsRow() ? new int[DiskCapacityTable.this.data.length - 1] : new int[DiskCapacityTable.this.data.length];
                for (int i = rows.length - 1; i >= 0; --i) {
                    rows[i] = DiskCapacityTable.this.table.getDataRow(i + ((DiskCapacityTable)DiskCapacityTable.this).adjuster.frozenRows);
                }
            } else {
                rows = DiskCapacityTable.this.table.getSelectedRows();
            }
            if (actionCommand == "STG1294T" || actionCommand == "STG5556T" || actionCommand == "STG5524L") {
                int[] ix = DiskCapacityTable.this.getGraphID(actionCommand);
                ((DiskCapacityTable)DiskCapacityTable.this).grr.chartSubtype = (byte)ix[0];
                DiskCapacityTable.this.grapher.createChart(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, rows, DiskCapacityTable.this.adjuster, DiskCapacityTable.this.ddi, null);
            } else {
                GuiReportReq newGrr = DiskCapacityTable.this.grapher.createHistory(DiskCapacityTable.this.grr, DiskCapacityTable.this.data, rows, actionCommand);
                DiskCapacityTable.this.ddi.addObject(DiskCapacityTable.this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", newGrr, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(newGrr.historyTitle), DiskCapacityTable.this);
            }
        }
    }

    private class DiskCapacityModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        DiskCapacityModel() {
            this.columnNames = ((DiskCapacityTable)DiskCapacityTable.this).adjuster.colNames;
            this.rowCount = DiskCapacityTable.this.data.length;
            this.commonAdjuster = DiskCapacityTable.this.adjuster;
        }

        public boolean changeIcon(int rowNum) {
            return false;
        }

        public Object getTableDataItem(int row, int col) {
            return DiskCapacityTable.this.adjuster.getCellData(row, DiskCapacityTable.this.adjuster.translateColumn(col));
        }
    }
}

