/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.gui.HistoryChart;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskHistChart
extends HistoryChart {
    private String[] computerPath;

    public DiskHistChart(String[] computerPath) {
        this.computerPath = computerPath;
    }

    protected boolean processResponse(Object responseData, GuiReportReq grr) {
        this.sourceName = MessageLog.getMessageNoID("STG1288T");
        DiskHistory[] array = (DiskHistory[])responseData;
        int cnt = array != null ? array.length : 0;
        if (cnt == 0) {
            return false;
        }
        this.seriesL = new String[cnt];
        this.xvalues = new double[cnt];
        this.yvalues = new double[cnt];
        int id = -1;
        String series = " ";
        block7: for (int i = 0; i < cnt; ++i) {
            DiskHistory info = array[i];
            if (id != info.dkhDiskID) {
                id = info.dkhDiskID;
                int j = 0;
                while (grr.selectedResources[j] != id) {
                    ++j;
                }
                series = this.computerPath[j];
            }
            this.seriesL[i] = series;
            this.xvalues[i] = info.dkhTimestamp;
            switch (grr.reportSubtype) {
                case -24: {
                    this.yvalues[i] = info.dkhGrownDefects;
                    continue block7;
                }
                case -25: {
                    this.yvalues[i] = info.dkhRecoveredReadErrors + info.dkhRecoveredWriteErrors + info.dkhRecoveredVerifyErrors;
                    continue block7;
                }
                case -26: {
                    this.yvalues[i] = info.dkhUnrecoveredReadErrors + info.dkhUnrecoveredWriteErrors + info.dkhUnrecoveredVerifyErrors;
                    continue block7;
                }
                case -39: {
                    this.yvalues[i] = info.dkhFreeSpace *= 512L;
                    continue block7;
                }
                case -23: {
                    this.yvalues[i] = info.dkhPrimaryDefects;
                    continue block7;
                }
            }
        }
        return true;
    }
}

