/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.gui.DiskTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    protected NameList computer;
    protected int controllerID;
    protected int volgroupID;

    protected String getMsgID() {
        if (this.computer.nlID2 == 21) {
            return "SAG0072L";
        }
        return "STG1004L";
    }

    protected short getQualifier() {
        return 0;
    }

    public DiskTreeLabel(NameList pComputer, int controllerID) {
        this(pComputer, controllerID, -1);
    }

    public DiskTreeLabel(NameList pComputer, int controllerID, int volgroupID) {
        this.computer = pComputer;
        this.controllerID = controllerID;
        this.volgroupID = volgroupID;
        this.setUserObject(MessageLog.getMessageNoID(this.getMsgID(), null));
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            GuiRequest.diskList(request, this.computer.nlID, this.controllerID, this.getQualifier());
            GuiListReq glr = (GuiListReq)request.requestData;
            glr.groupID = this.volgroupID;
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short status, Response response) {
        NameList finder;
        boolean byComp = this.controllerID <= 0;
        NameList head = finder = new NameList();
        NameList disk = null;
        if (status <= 4) {
            disk = (NameList)response.responseData;
        }
        while (disk != null) {
            finder = head;
            if (byComp && this.findDisk(disk.nlID, finder)) {
                disk = disk.nlNext;
                continue;
            }
            this.add(new DiskTreeNode(this.computer, disk.nlID, disk.nlName));
            disk = disk.nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    public boolean findDisk(int id, NameList findList) {
        NameList last = findList;
        while (findList != null) {
            if (findList.nlID == id) {
                return true;
            }
            last = findList;
            findList = findList.nlNext;
        }
        last.nlID = id;
        last.nlNext = new NameList();
        return false;
    }
}

