/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class EditableJobHistoryNode
extends BaseTreeNode
implements ActionListener,
GuiRequestor {
    protected static final String RUN_NOW = "R";
    private static final String EDIT = "E";
    private static final String HISTORY = "H";
    private static final String REFRESH = "F";
    private static final String UPDATE = "U";
    private JMenuItem runNow;
    private JMenuItem edit;
    private JMenuItem history;
    private JMenuItem refresh;
    private JMenuItem update;
    private String label;
    private String labelMsgID;
    private String submitMsgID;
    private int scheduleID;
    private short resourceType;
    private int adminType;
    public JPopupMenu menu;

    protected abstract NameListToTreeNode getNameListToTreeNode();

    public EditableJobHistoryNode(String labelMsgID, String submitMsgID, short resourceType, int scheduleID) {
        this(labelMsgID, submitMsgID, resourceType, scheduleID, 5);
    }

    public EditableJobHistoryNode(String labelMsgID, String submitMsgID, short resourceType, int scheduleID, int adminType) {
        super(MessageLog.getMessageNoID(labelMsgID), true);
        this.labelMsgID = labelMsgID;
        this.submitMsgID = submitMsgID;
        this.scheduleID = scheduleID;
        this.resourceType = resourceType;
        this.adminType = adminType;
        this.label = MessageLog.getMessageNoID(labelMsgID);
        String s = MessageLog.getMessageNoID("JSS1002L");
        this.runNow = new JMenuItem(s);
        this.runNow.setName(s);
        this.runNow.setActionCommand(RUN_NOW);
        this.runNow.addActionListener(this);
        this.runNow.setEnabled(this.capabilities.adminCapable(adminType));
        s = MessageLog.getMessageNoID("GUI0052L");
        this.history = new JMenuItem(s);
        this.history.setName(s);
        this.history.setActionCommand(HISTORY);
        this.history.addActionListener(this);
        s = Util.getString("REFRESH_JOB_LIST");
        this.refresh = new JMenuItem(s);
        this.refresh = new JMenuItem(s);
        this.refresh.setActionCommand(REFRESH);
        this.refresh.addActionListener(this);
        s = Util.getString("UPDATE_JOB_STATUS");
        this.update = new JMenuItem(s);
        this.update.setActionCommand(UPDATE);
        this.update.addActionListener(this);
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.menu;
    }

    public void showPopupMenu(MouseEvent event) {
        this.menu = this.getPopupMenu();
        this.menu.add(this.refresh);
        this.menu.add(this.update);
        this.menu.add(this.history);
        this.menu.add(this.runNow);
        if (event != null) {
            this.showPopupMenu(this.menu, event);
        }
    }

    private void submitToRun() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
        request.flags = (byte)4;
        NameList element = new NameList();
        element.nlID = this.scheduleID;
        element.nlInfo = this.resourceType;
        request.requestData = element;
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status > 4) {
                    return;
                }
                Object[] args = new Object[]{MessageLog.getMessageNoID(EditableJobHistoryNode.this.submitMsgID), null};
                JSgcScheduleCreateWhenData.displayJobSubmittedMessage(args);
            }
        }, request);
    }

    protected abstract void createEditor();

    public void sendRefreshRequest() {
        SchHistoryRequestNode historyRequest = new SchHistoryRequestNode();
        historyRequest.queryType = 1;
        historyRequest.queryID = this.scheduleID;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleGuiHandler";
        request.requestData = historyRequest;
        GuiClient.doRequest(this, request);
    }

    public void sendUpdateRequest() {
        SchHistoryRequestNode historyRequest = new SchHistoryRequestNode();
        Request request = new Request();
        historyRequest.queryID = this.scheduleID;
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.UpdateJobStatusHndlr";
        request.requestData = historyRequest;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        EditableObjectLabel.refresh(this, response, this.getNameListToTreeNode());
        DataDisplayInfo current = DataDisplayInfo.getCurrent();
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            BaseTreeNode node = (BaseTreeNode)e.nextElement();
            DataDisplayInfo ddi = node.ddi;
            if (ddi == null) continue;
            ddi.nullOutPanel();
            if (ddi != current) continue;
            ddi.reDisplay();
        }
    }

    protected abstract void makeRunDDI();

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command == RUN_NOW) {
            this.submitToRun();
        } else if (command == EDIT) {
            this.createEditor();
        } else if (command == HISTORY) {
            this.makeRunDDI();
        } else if (command == REFRESH) {
            this.sendRefreshRequest();
        } else if (command == UPDATE) {
            this.sendUpdateRequest();
        }
    }

    public void select(TreeSelectionEvent event) {
        this.createEditor();
    }

    public void expand(TreeExpansionEvent ignored) {
        if (this.getChildCount() == 0) {
            this.sendRefreshRequest();
        }
    }

    public int getAdminType() {
        return this.adminType;
    }

    public void setAdminType(int adminType) {
        this.adminType = adminType;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabelMsgID() {
        return this.labelMsgID;
    }

    public void setLabelMsgID(String labelMsgID) {
        this.labelMsgID = labelMsgID;
    }

    public short getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(short resourceType) {
        this.resourceType = resourceType;
    }

    public int getScheduleID() {
        return this.scheduleID;
    }

    public void setScheduleID(int scheduleID) {
        this.scheduleID = scheduleID;
    }

    public String getSubmitMsgID() {
        return this.submitMsgID;
    }

    public void setSubmitMsgID(String submitMsgID) {
        this.submitMsgID = submitMsgID;
    }
}

