/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.scheduler.SchHistoryJobNode;
import org.eclipse.aperi.scheduler.SchHistoryNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectHistoryJobTable
extends JPanel {
    MegaTable jobTable = new MegaTable();
    SchHistoryNameList element;
    BaseTreeNode node;
    SchHistoryJobNode[] jobNodeArray;
    DateFormat df = DateFormat.getDateTimeInstance();
    Date date = new Date();
    String statusText;
    TJCTableMouseInterface selectListener;
    static final String COMPUTER = MessageLog.getMessageNoID("JSS0039L");
    static final String START_TIME = MessageLog.getMessageNoID("JSS0029L");
    static final String FINISH_TIME = MessageLog.getMessageNoID("JSS0031L");
    static final String PROCESS_ID = MessageLog.getMessageNoID("JSS0042L");
    static final String LOG_FILE_NAME = MessageLog.getMessageNoID("JSS0043L");
    static final String DEVICE = MessageLog.getMessageNoID("JSS0083L");
    static final String RUN = MessageLog.getMessageNoID("JSS0028L");
    static final String STATUS = MessageLog.getMessageNoID("JSS0030L");
    static final String NUMBER_JOBS = MessageLog.getMessageNoID("JSS0032L");
    static final String NUMBER_FAILED = MessageLog.getMessageNoID("JSS0033L");
    static final String SUCCESS = MessageLog.getMessageNoID("JSS0034L");
    static final String FAILED = MessageLog.getMessageNoID("JSS0035L");
    static final String RUNNING = MessageLog.getMessageNoID("JSS0036L");
    static final String WARNINGS = MessageLog.getMessageNoID("JSS0037L");
    static final String WAITING = MessageLog.getMessageNoID("JSS0080L");
    static final String SUBMITTED = MessageLog.getMessageNoID("JSS0047L");
    static final String SUCCESSFUL = MessageLog.getMessageNoID("JSS0048L");
    static final String JOB_WARNING = MessageLog.getMessageNoID("JSS0049L");
    static final String JOB_ERROR = MessageLog.getMessageNoID("JSS0050L");
    static final String SYSTEM_ERROR = MessageLog.getMessageNoID("JSS0051L");
    static final String AGENT_DOWN = MessageLog.getMessageNoID("JSS0052L");
    static final String EXCEEDED_LIMIT = MessageLog.getMessageNoID("JSS0053L");
    static final String NEVER_RETURNED = MessageLog.getMessageNoID("JSS0054L");
    static final String AGENT_UPGRADING = MessageLog.getMessageNoID("JSS0067L");
    static final String AGENT_NOT_FOUND = MessageLog.getMessageNoID("JSS0069L");
    static final String AGENT_NOT_LICENSED = MessageLog.getMessageNoID("JSS0068L");
    static final String AGENT_UNREACHABLE = MessageLog.getMessageNoID("JSS0070L");
    static final String HOST_RECYCLED = MessageLog.getMessageNoID("JSS0079L");
    static final String JOB_RUNNING_WARNING = MessageLog.getMessageNoID("JSS0081L");
    static final String JOB_RUNNING_OK = MessageLog.getMessageNoID("JSS0082L");
    static final String[] colNames = new String[]{COMPUTER, STATUS, START_TIME, FINISH_TIME, LOG_FILE_NAME};
    static final String[] perfMonitorColNames = new String[]{DEVICE, STATUS, START_TIME, FINISH_TIME, LOG_FILE_NAME};
    static final int COMPUTER_COL = 0;
    static final int STATUS_COL = 1;
    static final int START_TIME_COL = 2;
    static final int FINISH_TIME_COL = 3;
    static final int LOG_FILE_NAME_COL = 4;

    public EditableObjectHistoryJobTable(NameList element, SchHistoryJobNode[] jobNodeArray) {
        this.element = (SchHistoryNameList)element;
        this.jobNodeArray = jobNodeArray;
        this.buildPanel();
    }

    public void buildPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getRunPanel(), "North");
        int count = this.jobNodeArray == null ? 0 : this.jobNodeArray.length;
        if (count == 0) {
            JPanel nonePanel = new JPanel();
            nonePanel.add(new JLabel(MessageLog.getMessageNoID("JSS0045L")));
            this.add((Component)nonePanel, "Center");
        } else {
            for (int i = 0; i < count; ++i) {
                SchHistoryJobNode jobNode = this.jobNodeArray[i];
                if (jobNode.computerID == -999999999 || jobNode.computerID == -999999998 || jobNode.computerID == -999999997) {
                    jobNode.computer = GuiClient.serverStatusResp.serverName;
                    continue;
                }
                if (jobNode.computerID <= 0) {
                    jobNode.computer = MessageLog.getMessageNoID("STG0019T");
                    continue;
                }
                if (jobNode.deviceRunNumber >= 1) continue;
                jobNode.computer = GuiUtil.getComputer((int)jobNode.computerID).gcTSName;
            }
            this.selectListener = new SelectListener();
            this.jobTable.setFrozenColumns(1);
            this.jobTable.setMouseListener(this.selectListener);
            this.jobTable.iconChanger = (AskForRowIconInterface)((Object)this.selectListener);
            this.jobTable.setCellRenderer(Integer.class, TableCellRenderers.number);
            this.jobTable.setCellRenderer(Date.class, TableCellRenderers.date);
            this.jobTable.setRowIcon(10, true);
            this.jobTable.setBaseTableModel(new JobTableModel());
            this.add((Component)this.jobTable, "Center");
        }
    }

    public static String runStateToStatusText(NameList element) {
        String statusText;
        switch (element.nlState) {
            case 1: {
                statusText = SUCCESS;
                break;
            }
            case 2: {
                statusText = RUNNING;
                break;
            }
            case 3: {
                statusText = WARNINGS;
                break;
            }
            default: {
                statusText = FAILED;
            }
        }
        return statusText;
    }

    private JPanel getRunPanel() {
        JLabel finishTime;
        JLabel startTime;
        GridBagConstraints gbcIndent = new GridBagConstraints();
        GridBagConstraints gbcPlop = new GridBagConstraints();
        GridBagConstraints gbcPlop2 = new GridBagConstraints();
        GridBagConstraints gbcLast = new GridBagConstraints();
        Insets insetA = new Insets(0, 20, 10, 15);
        Insets insetB = new Insets(0, 0, 10, 0);
        gbcIndent.anchor = 17;
        gbcIndent.insets = insetA;
        gbcIndent.fill = 2;
        gbcPlop.anchor = 17;
        gbcPlop.insets = insetB;
        gbcPlop2.anchor = 17;
        gbcPlop2.gridwidth = 2;
        gbcPlop2.insets = insetB;
        gbcLast.gridwidth = 0;
        gbcLast.insets = insetB;
        JLabel x1 = new JLabel(" ");
        JLabel x2 = new JLabel(" ");
        JLabel x3 = new JLabel(" ");
        JLabel x4 = new JLabel(" ");
        JLabel x5 = new JLabel(" ");
        JLabel x6 = new JLabel(" ");
        JPanel runPanel = GuiUtil.getPanel();
        JLabel runNumberLabel = new JLabel(RUN);
        runNumberLabel.setFont(BaseTree.boldFont);
        JLabel runNumber = new JLabel(Integer.toString(this.element.nlID2));
        JLabel statusLabel = new JLabel(STATUS);
        statusLabel.setFont(BaseTree.boldFont);
        this.statusText = EditableObjectHistoryJobTable.runStateToStatusText(this.element);
        JLabel status = new JLabel(this.statusText);
        JLabel startTimeLabel = new JLabel(START_TIME);
        startTimeLabel.setFont(BaseTree.boldFont);
        if (this.element.startTime < 1L) {
            startTime = new JLabel("-");
        } else {
            this.date.setTime(this.element.startTime);
            startTime = new JLabel(this.df.format(this.date));
        }
        JLabel finishTimeLabel = new JLabel(FINISH_TIME);
        finishTimeLabel.setFont(BaseTree.boldFont);
        if (this.element.finishTime < 1L) {
            finishTime = new JLabel("-");
        } else {
            this.date.setTime(this.element.finishTime);
            finishTime = new JLabel(this.df.format(this.date));
        }
        JLabel numberJobsLabel = new JLabel(NUMBER_JOBS);
        numberJobsLabel.setFont(BaseTree.boldFont);
        JLabel numberJobs = new JLabel(Integer.toString(this.element.numberJobs));
        JLabel numberFailedLabel = new JLabel(NUMBER_FAILED);
        numberFailedLabel.setFont(BaseTree.boldFont);
        int failed = this.element.successfulJobs < 0 ? 0 : this.element.numberJobs - this.element.successfulJobs;
        JLabel numberFailed = new JLabel(Integer.toString(failed));
        runPanel.add((Component)runNumberLabel, gbcIndent);
        runPanel.add((Component)runNumber, gbcPlop);
        runPanel.add((Component)x1, gbcPlop);
        runPanel.add((Component)statusLabel, gbcIndent);
        runPanel.add((Component)status, gbcPlop);
        runPanel.add((Component)x2, gbcLast);
        runPanel.add((Component)startTimeLabel, gbcIndent);
        runPanel.add((Component)startTime, gbcPlop2);
        runPanel.add((Component)x3, gbcLast);
        runPanel.add((Component)finishTimeLabel, gbcIndent);
        runPanel.add((Component)finishTime, gbcPlop2);
        runPanel.add((Component)x4, gbcLast);
        runPanel.add((Component)numberJobsLabel, gbcIndent);
        runPanel.add((Component)numberJobs, gbcPlop);
        runPanel.add((Component)x5, gbcPlop);
        runPanel.add((Component)numberFailedLabel, gbcIndent);
        runPanel.add((Component)numberFailed, gbcPlop);
        runPanel.add((Component)x6, gbcLast);
        GuiUtil.completePanel(runPanel);
        return runPanel;
    }

    public class JobTableModel
    extends BaseTableModel {
        JobTableModel() {
            this.columnNames = colNames;
            this.rowCount = EditableObjectHistoryJobTable.this.jobNodeArray.length;
        }

        public Object getTableDataItem(int rowNum, int colNum) {
            switch (colNum) {
                case 0: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[rowNum].computer;
                }
                case 1: {
                    switch (EditableObjectHistoryJobTable.this.jobNodeArray[rowNum].returnCode) {
                        case -2: {
                            return WAITING;
                        }
                        case -1: {
                            return SUBMITTED;
                        }
                        case 0: {
                            return SUCCESSFUL;
                        }
                        case 4: {
                            return JOB_WARNING;
                        }
                        case 8: {
                            return JOB_ERROR;
                        }
                        case 12: {
                            return SYSTEM_ERROR;
                        }
                        case 16: {
                            return AGENT_DOWN;
                        }
                        case 28: {
                            return AGENT_UPGRADING;
                        }
                        case 32: {
                            return AGENT_NOT_LICENSED;
                        }
                        case 34: {
                            return AGENT_NOT_FOUND;
                        }
                        case 36: {
                            return AGENT_UNREACHABLE;
                        }
                        case 20: {
                            return EXCEEDED_LIMIT;
                        }
                        case 24: {
                            return NEVER_RETURNED;
                        }
                        case 40: {
                            return HOST_RECYCLED;
                        }
                    }
                }
                case 2: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[rowNum].startTimeString;
                }
                case 3: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[rowNum].finishTimeString;
                }
                case 4: {
                    return EditableObjectHistoryJobTable.this.jobNodeArray[rowNum].logFileName;
                }
            }
            return null;
        }
    }

    private class SelectListener
    extends TJCTableMouseAdapter
    implements AskForRowIconInterface {
        private SelectListener() {
        }

        public boolean select(int viewRow, int viewCol) {
            return true;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if (this.haveLogFile(dataRow)) {
                new LogViewer(EditableObjectHistoryJobTable.this.jobNodeArray[dataRow].computerID, EditableObjectHistoryJobTable.this.node, EditableObjectHistoryJobTable.this.jobNodeArray[dataRow].logFileName, 0, EditableObjectHistoryJobTable.this.jobNodeArray[dataRow].deviceRunNumber);
            }
        }

        public boolean changeIcon(int dataRow) {
            return !this.haveLogFile(dataRow);
        }

        private boolean haveLogFile(int dataRow) {
            return EditableObjectHistoryJobTable.this.jobNodeArray[dataRow].logFileName != null && EditableObjectHistoryJobTable.this.jobNodeArray[dataRow].logFileName.charAt(0) != ' ';
        }
    }
}

