/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class FSSelector
implements TreeExpansionListener,
GuiRequestor,
TreeSelector.Reparenter {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList[] selections;
    private NameList rootName;
    private TreeSelectorNode sourceFSGroupLabel;
    private TreeSelectorNode sourceCompGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean expandedComputer;
    private TreeSet fsSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private boolean compsOnly;
    private String allObjectsLabel;
    public boolean allFSSelected;
    private boolean includeClusters;
    private boolean clusterExpanding;
    private boolean groupExpanding;
    private static final int ROOT_ID = -7;
    private static final int FS_GROUP_ID = -6;
    private static final int FS_ID = -5;
    private static final int COMP_GROUP_ID = -4;
    private static final int COMP_ID = -3;
    private static final int CLUSTER_ID = -2;
    private static final int ALL_FS_ID = Integer.MAX_VALUE;
    private static final int N_INDICES = 5;
    public static final int CLUSTER_INDEX = 4;

    public FSSelector() {
    }

    public FSSelector(NameList[] pSelections, boolean pAllFSSelected, boolean pCompsOnly) {
        this(pSelections, pAllFSSelected, pCompsOnly, false);
    }

    public FSSelector(NameList[] pSelections, boolean pAllFSSelected, boolean pCompsOnly, boolean pClusters) {
        this.selections = pSelections;
        this.allFSSelected = pAllFSSelected;
        this.compsOnly = pCompsOnly;
        this.includeClusters = pClusters;
        String msgID = this.compsOnly ? "STG3100L" : "STG4033L";
        this.allObjectsLabel = MessageLog.getMessageNoID(msgID);
    }

    public FSSelector(NameList[] pSelections, boolean pAllFSSelected) {
        this(pSelections, pAllFSSelected, false, false);
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree, this);
        return this.selector;
    }

    public NameList[] getData() {
        this.allFSSelected = false;
        NameList[] listHead = new NameList[5];
        NameList[] listTail = new NameList[5];
        int index = 0;
        NameList selectedList = this.selector.getNameList();
        while (selectedList != null) {
            index = selectedList.nlInfo;
            if (index == 99) {
                index = 4;
            }
            if (index > 4) {
                if (index == 13) {
                    this.allFSSelected = true;
                }
                selectedList = selectedList.nlNext;
                continue;
            }
            NameList element = selectedList;
            selectedList = element.nlNext;
            element.nlNext = null;
            if (listTail[index] == null) {
                listHead[index] = element;
            } else {
                listTail[index].nlNext = element;
            }
            listTail[index] = element;
        }
        return listHead;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        if (!this.compsOnly) {
            this.sourceFSGroupLabel = this.addFSGroupLabel(root);
            this.addFSLabel(root);
        }
        this.sourceCompGroupLabel = this.addCompGroupLabel(root);
        this.addCompLabel(root);
        if (this.includeClusters) {
            this.addClusterLabel(root);
        }
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode groupLabel = null;
        TreeSelectorNode fsLabel = null;
        TreeSelectorNode excludeLabel = null;
        NameList excludedComputers = null;
        NameList tail = null;
        TreeSelectorNode root = this.newRoot();
        NameList name = this.selections[2];
        while (name != null) {
            if (groupLabel == null) {
                groupLabel = this.addFSGroupLabel(root);
            }
            groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        this.fillSets(this.selections[3], true, false);
        if (this.allFSSelected && !this.compsOnly || !this.fsSet.isEmpty()) {
            fsLabel = this.addFSLabel(root);
            if (this.allFSSelected) {
                this.addAllFSNode(fsLabel, true);
            }
            this.addTreeSet(fsLabel, this.fsSet);
        }
        groupLabel = null;
        name = this.selections[0];
        while (name != null) {
            if (groupLabel == null) {
                groupLabel = this.addCompGroupLabel(root);
            }
            groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            name = name.nlNext;
        }
        groupLabel = null;
        name = this.selections[1];
        while (name != null) {
            NameList next = name.nlNext;
            name.nlNext = null;
            if ((name.nlState & 1) == 0) {
                if (groupLabel == null) {
                    groupLabel = this.addCompLabel(root);
                }
                groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
            } else {
                if (tail == null) {
                    excludedComputers = name;
                } else {
                    tail.nlNext = name;
                }
                tail = name;
            }
            name = next;
        }
        if (this.allFSSelected && this.compsOnly) {
            if (groupLabel == null) {
                groupLabel = this.addCompLabel(root);
            }
            this.addAllFSNode(groupLabel, true);
        }
        if (excludedComputers != null || !this.excludeSet.isEmpty()) {
            excludeLabel = TreeSelector.makeExcludeRoot();
            root.add(excludeLabel);
            if (!this.excludeSet.isEmpty()) {
                fsLabel = this.addFSLabel(excludeLabel);
                this.addTreeSet(fsLabel, this.excludeSet);
            }
            if (excludedComputers != null) {
                groupLabel = this.addCompLabel(excludeLabel);
                while (excludedComputers != null) {
                    groupLabel.add(new TreeSelectorNode(excludedComputers, false, true, false, false, null));
                    excludedComputers = excludedComputers.nlNext;
                }
            }
        }
        if (this.includeClusters) {
            groupLabel = null;
            name = this.selections[4];
            while (name != null) {
                if (groupLabel == null) {
                    groupLabel = this.addClusterLabel(root);
                }
                groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null));
                name = name.nlNext;
            }
        }
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList[] pSelections, boolean pAllFSSelected) {
        this.selections = pSelections;
        this.allFSSelected = pAllFSSelected;
        this.fsSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
        model.setRoot(root);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList fsList, boolean fsSelectable, boolean fsExcludeable) {
        boolean showClusterName = this.includeClusters;
        boolean showVsHostName = this.includeClusters;
        if (this.clusterExpanding) {
            showClusterName = false;
        }
        int lastFSComputerID = -1;
        int lastExcludeComputerID = -1;
        DefaultMutableTreeNode fsComputer = null;
        DefaultMutableTreeNode excludedComputer = null;
        DefaultMutableTreeNode computer = null;
        while (fsList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            int lastComputerID;
            if ((fsList.nlState & 1) != 0) {
                lastComputerID = lastExcludeComputerID;
                set = this.excludeSet;
                selectable = false;
                excludeable = true;
                computer = excludedComputer;
            } else {
                lastComputerID = lastFSComputerID;
                set = this.fsSet;
                selectable = fsSelectable;
                excludeable = fsExcludeable;
                computer = fsComputer;
            }
            if (fsList.nlID2 != lastComputerID) {
                NameList n = this.newNameList(GuiUtil.getComputer(fsList.nlID2), null, fsList.nlID2, 1, GuiUtil.getComputer((int)fsList.nlID2).gcOsType);
                computer = new TreeSelectorNode(n, false, false, true, false, null, showClusterName, showVsHostName);
                ((TreeSelectorNode)computer).setButtonFlag(false);
                if (this.clusterExpanding || this.groupExpanding) {
                    ((TreeSelectorNode)computer).setButtonFlag(false);
                }
                set.add(computer);
                if ((fsList.nlState & 1) != 0) {
                    lastExcludeComputerID = fsList.nlID2;
                    excludedComputer = computer;
                } else {
                    lastFSComputerID = fsList.nlID2;
                    fsComputer = computer;
                }
            }
            TreeSelectorNode tsn = new TreeSelectorNode(fsList, selectable, excludeable, false, false, null, showClusterName, showVsHostName);
            computer.add(tsn);
            if (this.clusterExpanding || this.groupExpanding) {
                tsn.setButtonFlag(false);
            }
            fsList = fsList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public static void invalidateGroups(TreeSelector selector, JTree selectedTree, short groupType) {
        FSSelector.invalidateGroups(selector, selectedTree, groupType, false);
    }

    public static void invalidateGroups(TreeSelector selector, JTree selectedTree, short groupType, boolean pIncludeClusters) {
        DefaultTreeModel model = (DefaultTreeModel)selectedTree.getModel();
        TreeSelectorNode node = (TreeSelectorNode)model.getRoot();
        Enumeration<TreeNode> e = node.breadthFirstEnumeration();
        boolean going = true;
        while (going && e.hasMoreElements()) {
            node = (TreeSelectorNode)e.nextElement();
            int level = node.getLevel();
            if (level != 2) {
                if (level <= 2) continue;
                going = false;
                continue;
            }
            NameList object = node.getNameList();
            if (object.nlInfo != groupType) continue;
            selector.nodeUnselected(node);
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            int index = parent.getIndex(node);
            model.removeNodeFromParent(node);
            node = new TreeSelectorNode(object, true, false, true, true, null, pIncludeClusters, pIncludeClusters);
            model.insertNodeInto(node, parent, index);
        }
    }

    public void invalidateGroups(short groupType) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    private void addGroup(TreeSelectorNode groupLabel, NameList name) {
        if (!groupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null, this.includeClusters, this.includeClusters);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, groupLabel, newNode);
    }

    public void addFSGroup(NameList name) {
        this.addGroup(this.sourceFSGroupLabel, name);
    }

    public void addComputerGroup(NameList name) {
        this.addGroup(this.sourceCompGroupLabel, name);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        Request request;
        Serializable requestData;
        this.clusterExpanding = false;
        this.groupExpanding = false;
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        int type = -1;
        int groupID = -1;
        int computerID = -1;
        this.expandedComputer = false;
        if (this.expansionTree == this.sourceTree) {
            switch (name.nlID) {
                case -6: {
                    type = 2;
                    break;
                }
                case -4: {
                    type = 0;
                    break;
                }
                case -5: {
                    type = 3;
                    break;
                }
                case -3: {
                    type = 1;
                    break;
                }
                case -2: {
                    type = 99;
                }
            }
        } else if (name.nlInfo == 2 || name.nlInfo == 0) {
            type = name.nlInfo + 1;
            groupID = name.nlID;
            this.groupExpanding = true;
        } else if (name.nlInfo == 99) {
            type = -1;
            this.clusterExpanding = true;
            requestData = new GroupDefinition();
            ((GroupDefinition)requestData).groupType = (short)99;
            ((GroupDefinition)requestData).ID = name.nlID;
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", requestData);
            request.flags = (byte)5;
            GuiClient.doRequest(this, request);
        } else if (name.nlInfo == 1 && this.expansionNode.selectable) {
            type = 3;
            computerID = name.nlID;
            this.expandedComputer = true;
        } else if (name.nlInfo == 13) {
            type = this.compsOnly ? 1 : 3;
        }
        if (type >= 0) {
            requestData = new GuiListReq();
            requestData.listRequested = 10000 + type;
            requestData.groupID = groupID;
            requestData.computerID = computerID;
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", requestData);
            request.flags = (byte)5;
            GuiClient.doRequest(this, request);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        Serializable obj = response.responseData;
        NameList nameList = null;
        TreeSelectorNode group = null;
        boolean showClusterName = this.includeClusters;
        boolean showVsHostName = this.includeClusters;
        if (obj instanceof GroupDefinition) {
            GroupDefinition gdef = (GroupDefinition)response.responseData;
            nameList = gdef.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == 2 || nameList.nlInfo == 0 || nameList.nlInfo == 99) {
            if (nameList.nlInfo == 99) {
                showClusterName = false;
            }
            while (nameList != null) {
                group = new TreeSelectorNode(nameList, true, false, false, true, null, showClusterName, showVsHostName);
                this.expansionNode.add(group);
                nameList = nameList.nlNext;
            }
        } else {
            boolean excludable;
            boolean selectable = this.expansionTree == this.sourceTree;
            boolean bl = excludable = !selectable;
            if (nameList.nlInfo == 3) {
                if (selectable && !this.compsOnly) {
                    this.addAllFSNode(this.expansionNode, false);
                }
                if (this.expandedComputer) {
                    while (nameList != null) {
                        TreeSelectorNode node = new TreeSelectorNode(nameList, selectable, excludable, false, false, null);
                        this.expansionNode.add(node);
                        nameList = nameList.nlNext;
                    }
                } else {
                    this.fsSet.clear();
                    this.fillSets(nameList, selectable, excludable);
                    this.addTreeSet(this.expansionNode, this.fsSet);
                }
            } else {
                boolean expandable;
                boolean bl2 = expandable = selectable && nameList.nlInfo == 1;
                if (expandable && this.compsOnly) {
                    this.addAllFSNode(this.expansionNode, false);
                }
                if (this.clusterExpanding) {
                    showClusterName = false;
                }
                while (nameList != null) {
                    TreeSelectorNode node = new TreeSelectorNode(nameList, selectable, excludable, false, expandable, null, showClusterName, showVsHostName);
                    if (this.clusterExpanding || this.groupExpanding) {
                        node.setButtonFlag(false);
                    }
                    this.expansionNode.add(node);
                    nameList = nameList.nlNext;
                }
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -7, -1, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true, false, null);
    }

    private TreeSelectorNode addFSGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode("STG4032L", -6, root);
    }

    private TreeSelectorNode makeFSLabel() {
        return this.makeLabelNode("STG1006L", -5);
    }

    private TreeSelectorNode addFSLabel(TreeSelectorNode root) {
        TreeSelectorNode fsLabel = this.makeFSLabel();
        root.add(fsLabel);
        return fsLabel;
    }

    private TreeSelectorNode addCompGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode("STG3012L", -4, root);
    }

    private TreeSelectorNode makeCompLabel() {
        return this.makeLabelNode("STG4041L", -3);
    }

    private TreeSelectorNode addCompLabel(TreeSelectorNode root) {
        TreeSelectorNode compLabel = this.makeCompLabel();
        root.add(compLabel);
        return compLabel;
    }

    private TreeSelectorNode addClusterLabel(TreeSelectorNode root) {
        TreeSelectorNode clustLabel = this.makeLabelNode("LABEL_CLUSTERS", -2);
        root.add(clustLabel);
        return clustLabel;
    }

    private TreeSelectorNode makeLabelNode(String labelMsgID, int id) {
        String label = Util.getString(labelMsgID);
        NameList name = this.newNameList(label, id, -1, GuiUtil.getComputer((int)id).gcOsType);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        return labelNode;
    }

    private TreeSelectorNode addLabelNode(String labelMsgID, int id, TreeSelectorNode root) {
        TreeSelectorNode labelNode = this.makeLabelNode(labelMsgID, id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllFSNode(TreeSelectorNode addBelow, boolean expandable) {
        NameList name = this.newNameList(this.allObjectsLabel, Integer.MAX_VALUE, 13, -1);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        addBelow.insert(node, 0);
    }

    private NameList newNameList(String name, int id, int type, int osType) {
        return this.newNameList(null, name, id, type, osType);
    }

    private NameList newNameList(GComputer gc, String name, int id, int type, int osType) {
        NameList nameList = new NameList();
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        nameList.nlID2 = (short)osType;
        if (gc != null) {
            nameList.nlName = gc.gcTSName;
            nameList.nlClusterDomain = gc.gcDomainName;
            nameList.nlClusterID = gc.gcClusterID;
            nameList.nlClusterName = gc.gcClusterName;
            nameList.nlHostName = gc.gcHostedNodeName;
        } else {
            nameList.nlName = name;
        }
        return nameList;
    }

    public TreeSelectorNode reparent(TreeSelectorNode excludeRoot, NameList name, MutableInteger levels) {
        int reservedID;
        if (name.nlInfo == 1) {
            reservedID = -3;
        } else {
            reservedID = -5;
            levels.value = 2;
        }
        TreeSelectorNode result = null;
        Enumeration<TreeNode> e = excludeRoot.children();
        boolean looking = true;
        int index = 0;
        while (looking && e.hasMoreElements()) {
            result = (TreeSelectorNode)e.nextElement();
            if (result.hiOrderSortKey == reservedID) {
                looking = false;
                continue;
            }
            ++index;
        }
        if (looking) {
            if (reservedID == -3) {
                result = this.makeCompLabel();
            } else {
                result = this.makeFSLabel();
                index = 0;
            }
            DefaultTreeModel model = (DefaultTreeModel)this.selectedTree.getModel();
            model.insertNodeInto(result, excludeRoot, index);
        }
        return result;
    }
}

