/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JTabbedPane;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.AlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.FabricAlertEditor;
import org.eclipse.aperi.TStorm.gui.FabricGroupSelector;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class FabricAlertCreateOrEdit
extends AlertCreateOrEdit {
    private FabricGroupSelector fabricSelector;
    private static final int ALERT_TAB = 0;
    private static final int FABRIC_TAB = 1;

    public FabricAlertCreateOrEdit(CreateOrEditDDI pDdi) {
        super(pDdi);
    }

    protected void makeTabbedPane(AlertHeader compAlert) {
        this.fabricSelector = new FabricGroupSelector(compAlert.alertElements, compAlert.alertElements2, compAlert.alertElements3, compAlert.allObjects, compAlert.allElements1, compAlert.allElements2);
        this.alertEditor = compAlert.alert == null ? new FabricAlertEditor(this) : new FabricAlertEditor(this, compAlert.alert);
        this.tabbedPane = new JTabbedPane();
        String title = MessageLog.getMessageNoID("STG4036L");
        this.tabbedPane.addTab(title, this.alertEditor.getComponent());
        title = Util.getString("FabricAlert_FabricTabTitle");
        this.tabbedPane.addTab(title, this.fabricSelector.getComponent());
        if (((FabricAlertEditor)this.alertEditor).getConditionValue() == 103) {
            this.tabbedPane.setEnabledAt(1, false);
        }
    }

    public CreateHeader getData() {
        AlertHeader compAlert = (AlertHeader)super.getData();
        NameList[] compLists = this.fabricSelector.getData();
        compAlert.alertElements = compLists[0];
        compAlert.alertElements2 = compLists[1];
        compAlert.alertElements3 = compLists[2];
        compAlert.allObjects = this.fabricSelector.allFabricsSelected;
        compAlert.allElements1 = this.fabricSelector.allZonesSelected;
        compAlert.allElements2 = this.fabricSelector.allZoneSetsSelected;
        return compAlert;
    }

    public void replace(CreateHeader newHeader) {
        super.replace(newHeader);
        AlertHeader compAlert = (AlertHeader)newHeader;
        this.fabricSelector.replace(compAlert.alertElements, compAlert.alertElements2, compAlert.alertElements3, compAlert.allObjects, compAlert.allElements1, compAlert.allElements2);
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.fabricSelector.invalidateGroups(name.nlInfo);
        }
        if (changeType != 1) {
            return;
        }
        if (name.nlInfo == 0) {
            this.fabricSelector.addGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return FabricGuiUtil.FHELP_ALERT_FABRIC;
            }
            case 1: {
                return FabricGuiUtil.FHELP_ALERT_SELECT;
            }
        }
        return null;
    }
}

