/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.FabricDiscoveryOptions;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.IPScanListEditor;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.TextUtil;

public class FabricOptionsEditor
extends JPanel {
    private JLabel defaultCommunityLabel;
    private JTextField defaultCommunity;
    private JLabel scanTimeoutLabel;
    private JTextField scanTimeout;
    private JLabel scanUnitsLabel;
    private JLabel baseIPAddressLabel;
    private IPScanListEditor ipAddresses;
    private JLabel userNameLabel;
    private JTextField userName;
    private JLabel passwordLabel;
    private JPasswordField password;
    private boolean panelBuilt;
    private FabricDiscoveryOptions options;
    private ProbePing schedule;
    private String defaultTimeout = "500";

    public FabricOptionsEditor(ProbePing sched) {
        this.options = new FabricDiscoveryOptions(sched.arguments);
        this.schedule = sched;
    }

    public Component getComponent() {
        if (this.panelBuilt) {
            return this;
        }
        String s = Util.getString("SNMP_DEFAULT_COMMUNITY");
        this.defaultCommunityLabel = new BlackLabel(s);
        this.defaultCommunity = TTextField.newTTextField(null, 12, 64, false);
        TextUtil.setText(this.defaultCommunity, this.options.getDefaultCommunity());
        GuiUtil.setAccessibleLabel(this.defaultCommunityLabel, this.defaultCommunity, "", this.defaultCommunityLabel.getText(), this.defaultCommunityLabel.getText());
        s = Util.getString("SNMP_SCAN_TIMEOUT");
        this.scanTimeoutLabel = new BlackLabel(s);
        this.scanTimeout = TTextField.newTTextField(null, 8, 64, true);
        String timeout = this.options.getScanTimeoutString();
        if (Util.isEmpty(timeout)) {
            TextUtil.setText(this.scanTimeout, this.defaultTimeout);
        } else {
            TextUtil.setText(this.scanTimeout, timeout);
        }
        GuiUtil.setAccessibleLabel(this.scanTimeoutLabel, this.scanTimeout, "", this.scanTimeoutLabel.getText(), this.scanTimeoutLabel.getText());
        s = Util.getString("MILLISECS");
        this.scanUnitsLabel = new BlackLabel(s);
        s = Util.getString("BASE_IP_ADDRESSES");
        this.ipAddresses = new IPScanListEditor(this.schedule.pbSnmpIPAddresses, s);
        s = Util.getString("LABEL_USERNAME");
        this.userNameLabel = new BlackLabel(s);
        s = this.schedule.pbBrocadeUserName;
        this.userName = TTextField.newTTextField(null, 12, 64, false);
        TextUtil.setText(this.userName, this.options.getUserName());
        GuiUtil.setAccessibleLabel(this.userNameLabel, this.userName, "", this.userNameLabel.getText(), this.userNameLabel.getText());
        s = Util.getString("LABEL_PASSWORD");
        this.passwordLabel = new BlackLabel(s);
        s = this.schedule.pbBrocadePassword;
        this.password = new JPasswordField(12);
        TextUtil.setText(this.password, this.options.getPasword());
        GuiUtil.setAccessibleLabel(this.passwordLabel, this.password, "", this.passwordLabel.getText(), this.passwordLabel.getText());
        JPanel commPanel = GuiUtil.getTitledBorderedPanel(Util.getString("SNMP_PARAMETERS"));
        GridBagConstraints cLabel = new GridBagConstraints();
        cLabel.insets.top = 4;
        cLabel.insets.left = 4;
        cLabel.insets.bottom = 4;
        cLabel.insets.right = 4;
        cLabel.anchor = 17;
        cLabel.gridwidth = 1;
        GridBagConstraints cEntryField = new GridBagConstraints();
        cEntryField.insets.top = 4;
        cEntryField.insets.left = 4;
        cEntryField.insets.bottom = 4;
        cEntryField.insets.right = 4;
        cEntryField.weightx = 1.0;
        cEntryField.anchor = 17;
        cEntryField.gridwidth = 0;
        commPanel.add((Component)this.defaultCommunityLabel, cLabel);
        commPanel.add((Component)this.defaultCommunity, cEntryField);
        GuiUtil.completePanel(commPanel);
        JPanel addressPanel = GuiUtil.getTitledBorderedPanel(Util.getString("SNMP_ADDRESS_SCAN"));
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 1));
        GridBagConstraints c1 = new GridBagConstraints();
        c1.insets.top = 4;
        c1.insets.left = 4;
        c1.insets.bottom = 4;
        c1.insets.right = 4;
        c1.weightx = 1.0;
        c1.anchor = 17;
        c1.fill = 2;
        c1.gridwidth = 0;
        JPanel timeoutPanel = new JPanel(new GridBagLayout());
        cLabel.gridwidth = 1;
        timeoutPanel.add((Component)this.scanTimeoutLabel, cLabel);
        cLabel.gridwidth = 1;
        JPanel entryUnitPanel = new JPanel(new FlowLayout());
        entryUnitPanel.add(this.scanTimeout);
        entryUnitPanel.add(this.scanUnitsLabel);
        timeoutPanel.add((Component)entryUnitPanel, cEntryField);
        subPanel.add(timeoutPanel);
        subPanel.add(this.ipAddresses.getComponent());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.insets.top = 4;
        c2.insets.left = 4;
        c2.insets.bottom = 4;
        c2.insets.right = 4;
        c2.weightx = 1.0;
        c2.anchor = 17;
        c2.fill = 2;
        c2.gridwidth = -1;
        addressPanel.add((Component)subPanel, c2);
        GuiUtil.completePanel(addressPanel);
        JPanel panel = GuiUtil.getPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(commPanel);
        panel.add(addressPanel);
        GuiUtil.completePanel(panel);
        this.setPanelSize(panel);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        this.panelBuilt = true;
        return this;
    }

    private void setPanelSize(JPanel panel) {
        int maxWidth = (int)panel.getMaximumSize().getWidth();
        int maxHeight = (int)panel.getMaximumSize().getHeight();
        panel.setMaximumSize(new Dimension(maxWidth, maxHeight));
    }

    public String getArgumentsData() {
        this.options.setScanTimeout(this.scanTimeout.getText());
        this.options.setDefaultCommunity(this.defaultCommunity.getText());
        this.options.setUserName(this.userName.getText());
        String pwd = new String(this.password.getPassword());
        this.options.setPasswordStr(pwd);
        return this.options.getOptionsString();
    }

    public String getEncryptedArgumentsData() {
        this.options.setScanTimeout(this.scanTimeout.getText());
        this.options.setDefaultCommunity(this.defaultCommunity.getText());
        this.options.setUserName(this.userName.getText());
        String pwd = new String(this.password.getPassword());
        this.options.setPassword(pwd);
        return this.options.getOptionsString();
    }

    public NameList getAddressesData() {
        return this.ipAddresses.getData();
    }
}

