/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeDDI;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeData
extends JTabbedPane
implements ChangeListener,
ReportingObjectBuilder,
GuiRequestor {
    private static GridBagLayout gridBag = new GridBagLayout();
    private static GridBagConstraints gbcFill_1 = new GridBagConstraints();
    private static GridBagConstraints gbcFill_2 = new GridBagConstraints();
    private static GridBagConstraints gbcLabel = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private static final Dimension DIM11 = new Dimension(1, 1);
    private static final String LOGICALVOLUME = "  " + MessageLog.getMessageNoID("STG1215T") + "  ";
    private static final String FILESYSTEM = "  " + MessageLog.getMessageNoID("STG1216T") + "  ";
    private static final String YES = MessageLog.getMessageNoID("GUI0121T");
    private static final String NO = MessageLog.getMessageNoID("GUI0122T");
    private static final String DISK = MessageLog.getMessageNoID("STG1240L");
    private static final String LUN = MessageLog.getMessageNoID("SAG0515L");
    private static final String NOT_MOUNTED = "                     " + MessageLog.getMessageNoID("STG1133T");
    private int lvID;
    private int fsID;
    private int computerID;
    private int tabToDisplay;
    private LogicalVolumeDDI ddi;
    private FilesystemSettable fsSettable;
    private JPanel lvPanel = new JPanel();
    private JScrollPane fsPanel = new JScrollPane();
    private DecimalFormat d0Fmt = new DecimalFormat();

    public LogicalVolumeData(int lvID, int fsID, int computerID, int tabToDisplay, LogicalVolumeDDI ddi) {
        this(lvID, fsID, computerID, tabToDisplay, ddi, null);
    }

    private LogicalVolumeData(int lvID, int fsID, int computerID, int tabToDisplay, LogicalVolumeDDI ddi, FilesystemSettable fsSettable) {
        this.lvID = lvID;
        this.fsID = fsID;
        this.computerID = computerID;
        this.tabToDisplay = tabToDisplay;
        this.ddi = ddi;
        this.fsSettable = fsSettable;
        this.getInfo();
        if (ddi != null) {
            this.setPreferredSize(DIM11);
            this.addChangeListener(this);
        }
        LogicalVolumeData.gbcFill_1.gridheight = 40;
        LogicalVolumeData.gbcFill_1.weighty = 1.0;
        LogicalVolumeData.gbcFill_1.ipadx = 60;
        LogicalVolumeData.gbcFill_2.gridwidth = 4;
        LogicalVolumeData.gbcFill_2.weightx = 1.0;
        LogicalVolumeData.gbcLabel.anchor = 17;
        LogicalVolumeData.gbcLabel.ipadx = 30;
        LogicalVolumeData.gbcLast.anchor = 17;
        LogicalVolumeData.gbcLast.gridwidth = 0;
    }

    public LogicalVolumeData() {
    }

    public Component build(Object object) {
        Filesystem fs = (Filesystem)object;
        return LogicalVolumeData.getLvPanel(fs.fsLogicalDiskID, fs.fsComputerID);
    }

    public static JComponent getFsPanel(int fsID, FilesystemSettable fsSettable) {
        LogicalVolumeData lvd = new LogicalVolumeData(-1, fsID, -1, 0, null, fsSettable);
        return lvd.fsPanel;
    }

    public static JComponent getLvPanel(int lvID, int computerID) {
        LogicalVolumeData lvd = new LogicalVolumeData(lvID, -1, computerID, 0, null, null);
        return lvd.lvPanel;
    }

    public void stateChanged(ChangeEvent e) {
        this.ddi.tabDisplayed = this.getSelectedIndex();
    }

    private void getInfo() {
        Request request = new Request();
        if (this.lvID > 0) {
            GuiRequest.logicalVolumeInfo(request, this.lvID, this.computerID);
        } else {
            GuiRequest.filesystemInfo(request, this.fsID);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            if (this.lvID > 0) {
                Share sh = (Share)response.responseData;
                LogicalDisk ld = (LogicalDisk)sh.shResource;
                if (this.ddi != null) {
                    this.createFS(ld.ldFilesystem, sh);
                }
                this.createLV(ld);
                if (this.ddi != null && ld.ldFilesystem != null) {
                    this.setSelectedIndex(this.tabToDisplay);
                }
            } else {
                Share sh = (Share)response.responseData;
                this.createFS((Filesystem)sh.shResource, sh);
                if (this.fsSettable != null) {
                    this.fsSettable.setFilesystem((Filesystem)sh.shResource);
                }
            }
        }
    }

    private void createFS(Filesystem fs, Share sh) {
        if (fs == null) {
            return;
        }
        JPanel panel = new JPanel(gridBag);
        this.fsPanel.setViewportView(panel);
        if (this.ddi != null) {
            this.add(FILESYSTEM, this.fsPanel);
        }
        JLabel lComputerID = new JLabel(MessageLog.getMessageNoID("STG1102L"));
        JLabel lType = new JLabel(MessageLog.getMessageNoID("STG1232L"));
        JLabel lUseCount = new JLabel(MessageLog.getMessageNoID("STG1221L"));
        JLabel lMountPoint = new JLabel(MessageLog.getMessageNoID("STG1230L"));
        JLabel lPhysicalSize = new JLabel(MessageLog.getMessageNoID("STG1231L"));
        JLabel lCapacity = new JLabel(MessageLog.getMessageNoID("STG1220L"));
        JLabel lProbeTime = new JLabel(MessageLog.getMessageNoID("STG1182L"));
        JLabel lScanTime = new JLabel(MessageLog.getMessageNoID("STG1233L"));
        JLabel lDiscovered = new JLabel(MessageLog.getMessageNoID("STG1134L") + "    ");
        JLabel lRemovedTime = new JLabel(MessageLog.getMessageNoID("STG1229L"));
        JLabel lMaxFiles = new JLabel(MessageLog.getMessageNoID("STG1234L") + "    ");
        JLabel lUsedInodes = new JLabel(MessageLog.getMessageNoID("STG1235L"));
        JLabel lFreeInodes = new JLabel(MessageLog.getMessageNoID("STG1236L"));
        String sUsedSpace = MessageLog.getMessageNoID("STG1237L");
        String sFreeSpace = MessageLog.getMessageNoID("STG1184L");
        JLabel lUsedSpace = new JLabel(sUsedSpace);
        JLabel lFreeSpace = new JLabel(sFreeSpace);
        JLabel dComputerID = new JLabel();
        JLabel dType = new JLabel();
        JLabel dUseCount = new JLabel();
        JLabel dMountPoint = new JLabel();
        JLabel dPhysicalSize = new JLabel();
        JLabel dCapacity = new JLabel();
        JLabel dScanTime = new JLabel();
        JLabel dProbeTime = new JLabel();
        JLabel dDiscovered = new JLabel();
        JLabel dRemovedTime = new JLabel();
        JLabel dMaxFiles = new JLabel();
        JLabel dUsedInodes = new JLabel();
        JLabel dFreeInodes = new JLabel();
        JLabel dUsedSpace = new JLabel();
        JLabel dFreeSpace = new JLabel();
        ChartOptions defaults = new ChartOptions();
        defaults.isTitleCustomizable = false;
        defaults.title = (this.ddi == null ? DataDisplayInfo.getCurrent() : this.ddi).getDescription();
        GuiReportReq dummyGrr = new GuiReportReq();
        dummyGrr.reportType = 2;
        AperiCustomizableChart chart = new AperiCustomizableChart(1, 7, new Number[][]{{new Double(fs.fsUsedSpace * 512L)}, {new Double(fs.fsFreeSpace * 512L)}}, new String[]{sUsedSpace, sFreeSpace}, new String[]{""}, defaults, dummyGrr);
        dComputerID.setText(GuiUtil.getComputer((int)fs.fsComputerID).gcTSName);
        if (fs.fsType == -1) {
            dType.setText(MessageLog.getMessageNoID("STG1020L"));
        } else {
            dType.setText(Filesystem.TYPES[fs.fsType + 1]);
        }
        dUseCount.setText(this.numFormat(fs.fsUseCount));
        dMountPoint.setText(fs.fsMountPoint + (this.lvID < 0 && this.ddi != null ? NOT_MOUNTED : " "));
        dPhysicalSize.setText(Util.formatBytes(fs.fsPhysicalSize * 512L));
        dCapacity.setText(Util.formatBytes(fs.fsCapacity * 512L));
        dScanTime.setText(fs.fsScanTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(fs.fsScanTime)));
        dProbeTime.setText(sh.shScanTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(sh.shScanTime)));
        dDiscovered.setText(fs.fsDiscoveredTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(fs.fsDiscoveredTime)));
        dRemovedTime.setText(sh.shRemovedTime < 86400000L ? " " : DateFormat.getDateTimeInstance().format(new Date(sh.shRemovedTime)));
        if (Filesystem.TYPES[fs.fsType + 1].equalsIgnoreCase(Filesystem.TYPES[9])) {
            dMaxFiles.setText(MessageLog.getMessageNoID("STG0019T"));
            dUsedInodes.setText(MessageLog.getMessageNoID("STG0019T"));
            dFreeInodes.setText(MessageLog.getMessageNoID("STG0019T"));
        } else {
            dMaxFiles.setText(this.numFormat(fs.fsMaxFiles));
            dUsedInodes.setText(this.numFormat(fs.fsUsedInodes));
            dFreeInodes.setText(this.numFormat(fs.fsFreeInodes));
        }
        dUsedSpace.setText(Util.formatBytes(fs.fsUsedSpace * 512L));
        dFreeSpace.setText(Util.formatBytes(fs.fsFreeSpace * 512L));
        panel.add((Component)new JLabel(" "), gbcFill_1);
        panel.add((Component)new JLabel(" "), gbcFill_2);
        panel.add((Component)new JLabel("     "), gbcLast);
        panel.add((Component)lComputerID, gbcLabel);
        panel.add((Component)dComputerID, gbcLast);
        panel.add((Component)lType, gbcLabel);
        panel.add((Component)dType, gbcLast);
        panel.add((Component)lUseCount, gbcLabel);
        panel.add((Component)dUseCount, gbcLast);
        panel.add((Component)lMountPoint, gbcLabel);
        panel.add((Component)dMountPoint, gbcLast);
        panel.add((Component)lPhysicalSize, gbcLabel);
        panel.add((Component)dPhysicalSize, gbcLast);
        panel.add((Component)lCapacity, gbcLabel);
        panel.add((Component)dCapacity, gbcLast);
        panel.add((Component)new JLabel(" "), gbcLast);
        panel.add((Component)lProbeTime, gbcLabel);
        panel.add((Component)dProbeTime, gbcLast);
        panel.add((Component)lScanTime, gbcLabel);
        panel.add((Component)dScanTime, gbcLast);
        panel.add((Component)lDiscovered, gbcLabel);
        panel.add((Component)dDiscovered, gbcLast);
        panel.add((Component)lRemovedTime, gbcLabel);
        panel.add((Component)dRemovedTime, gbcLast);
        panel.add((Component)lMaxFiles, gbcLabel);
        panel.add((Component)dMaxFiles, gbcLast);
        panel.add((Component)lUsedInodes, gbcLabel);
        panel.add((Component)dUsedInodes, gbcLast);
        panel.add((Component)lFreeInodes, gbcLabel);
        panel.add((Component)dFreeInodes, gbcLast);
        panel.add((Component)lUsedSpace, gbcLabel);
        panel.add((Component)dUsedSpace, gbcLast);
        panel.add((Component)lFreeSpace, gbcLabel);
        panel.add((Component)dFreeSpace, gbcLast);
        panel.add((Component)new JLabel(" "), gbcLast);
        panel.add((Component)new JLabel(" "), gbcLabel);
        panel.add((Component)chart, gbcLast);
    }

    private void createLV(LogicalDisk ld) {
        JPanel dPanel = GuiUtil.getBorderedPanel();
        BorderLayout bLayout = new BorderLayout();
        short osType = -1;
        this.lvPanel.setLayout(bLayout);
        this.lvPanel.add((Component)dPanel, "North");
        if (this.ddi != null) {
            this.add(LOGICALVOLUME, this.lvPanel);
            osType = this.ddi.getOSType();
        }
        JLabel lPath = new JLabel(MessageLog.getMessageNoID("STG1219L"));
        JLabel lCapacity = new JLabel(MessageLog.getMessageNoID("STG1220L"));
        JLabel lUseCount = new JLabel(MessageLog.getMessageNoID("STG1221L"));
        JLabel lType = new JLabel(MessageLog.getMessageNoID("STG1222L") + "    ");
        JLabel lIsSwap = new JLabel(MessageLog.getMessageNoID("STG1223L"));
        JLabel lOverhead = new JLabel(MessageLog.getMessageNoID("STG6054L"));
        JLabel dPath = new JLabel();
        JLabel dCapacity = new JLabel();
        JLabel dUseCount = new JLabel();
        JLabel dType = new JLabel();
        JLabel dIsSwap = new JLabel();
        JLabel dOverhead = new JLabel();
        dPath.setText(ld.ldPath);
        dCapacity.setText(Util.formatBytes(ld.ldCapacity * 512L));
        dUseCount.setText(this.numFormat(ld.ldUseCount));
        dType.setText(LogicalDisk.TYPES[ld.ldType]);
        dIsSwap.setText(ld.ldIsSwap ? YES : NO);
        dOverhead.setText(Util.formatBytes(ld.ldOverhead * 512L));
        dPanel.add((Component)new JLabel(" "), gbcFill_1);
        dPanel.add((Component)new JLabel(" "), gbcFill_2);
        dPanel.add((Component)new JLabel("     "), gbcLast);
        dPanel.add((Component)lPath, gbcLabel);
        dPanel.add((Component)dPath, gbcLast);
        dPanel.add((Component)lCapacity, gbcLabel);
        dPanel.add((Component)dCapacity, gbcLast);
        dPanel.add((Component)lUseCount, gbcLabel);
        dPanel.add((Component)dUseCount, gbcLast);
        dPanel.add((Component)lType, gbcLabel);
        dPanel.add((Component)dType, gbcLast);
        dPanel.add((Component)lIsSwap, gbcLabel);
        dPanel.add((Component)dIsSwap, gbcLast);
        dPanel.add((Component)lOverhead, gbcLabel);
        dPanel.add((Component)dOverhead, gbcLast);
        dPanel.add((Component)new JLabel(" "), gbcLast);
        this.lvPanel.add((Component)LogicalVolumeData.getLvTree(ld, osType), "Center");
    }

    public static JComponent getLvTree(LogicalDisk ld, short osType) {
        JScrollPane sPanel = new JScrollPane();
        String lunName = ld.ldPath;
        if (osType == 21) {
            int index = ld.ldPath.indexOf(":");
            if (index > 0) {
                lunName = ld.ldPath.substring(0, index);
            }
        } else if (osType == 14) {
            lunName = ld.ldName;
        } else if (osType == 25 || osType == 27) {
            lunName = !Util.isEmpty(lunName) ? lunName + " (" + ld.ldDeviceId + ")" : "(" + ld.ldDeviceId + ")";
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(lunName);
        JTree myTree = new JTree(root, true);
        DefaultTreeModel myModel = (DefaultTreeModel)myTree.getModel();
        myTree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultMutableTreeNode lvNode = root;
        ld.unpack();
        while (ld != null) {
            if (lvNode != root) {
                String ldType = osType == 21 ? LogicalDisk.VDISK_TYPES[ld.ldType] : LogicalDisk.TYPES[ld.ldType];
                if (!Util.isEmpty(ld.ldPath)) {
                    ldType = ld.ldPath;
                }
                lvNode = new DefaultMutableTreeNode(ldType);
                root.add(lvNode);
            }
            ChunkCollection cc = ld.ldCollectionList;
            DefaultMutableTreeNode ccNode = null;
            while (cc != null) {
                if (ld.ldType != 0) {
                    ccNode = new DefaultMutableTreeNode(ChunkCollection.TYPES[cc.ccType]);
                    lvNode.add(ccNode);
                }
                Chunk chk = cc.ccChunkList;
                int disk = -1;
                DefaultMutableTreeNode dNode = null;
                while (chk != null) {
                    String endLength;
                    String startLength;
                    if (chk.chkDiskID != disk) {
                        String type = chk.chkDisk.devType == 5 ? LUN : DISK;
                        dNode = new DefaultMutableTreeNode(type + " -  " + chk.chkDisk.devManufacturer);
                        if (ld.ldType != 0) {
                            ccNode.add(dNode);
                        } else {
                            lvNode.add(dNode);
                        }
                        disk = chk.chkDiskID;
                    }
                    if (osType == 21) {
                        startLength = Util.formatBytes(chk.chkOffset * 0x100000L);
                        endLength = Util.formatBytes(chk.chkSize * 0x100000L);
                    } else {
                        startLength = Util.formatBytes(chk.chkOffset * (long)chk.chkUnitSize);
                        endLength = Util.formatBytes(chk.chkSize * (long)chk.chkUnitSize);
                    }
                    DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(MessageLog.getMessageNoID("STG1241L", new Object[]{startLength, endLength}));
                    dNode.add(cNode);
                    cNode.setAllowsChildren(false);
                    chk = chk.chkNextInCollection;
                }
                cc = cc.ccNext;
            }
            ld = ld.ldNextMirror;
            lvNode = null;
        }
        myModel.nodeStructureChanged(root);
        TreeSelector.expandAll(myTree);
        sPanel.setViewportView(myTree);
        return sPanel;
    }

    private String numFormat(int num) {
        return this.numFormat((long)num);
    }

    private String numFormat(short num) {
        return this.numFormat((long)num);
    }

    private String numFormat(long num) {
        this.d0Fmt.setMaximumFractionDigits(2);
        return num < 0L ? MessageLog.getMessageNoID("STG0019T") : this.d0Fmt.format(num);
    }

    public static interface FilesystemSettable {
        public void setFilesystem(Filesystem var1);
    }
}

