/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    protected NameList computer;
    protected int diskID;
    protected int volgroupID;

    public LogicalVolumeTreeLabel(NameList pComputer, int diskID, int volgroupID) {
        this.computer = pComputer;
        this.diskID = diskID;
        this.volgroupID = volgroupID;
        if (pComputer.nlID2 == 23) {
            this.setUserObject(MessageLog.getMessageNoID("STG1045L"));
        } else {
            this.setUserObject(MessageLog.getMessageNoID("STG1005L"));
        }
    }

    public LogicalVolumeTreeLabel(NameList pComputer, int diskID) {
        this(pComputer, diskID, -1);
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            GuiRequest.logicalVolumeList(request, this.computer.nlID, this.diskID);
            GuiListReq glr = (GuiListReq)request.requestData;
            glr.groupID = this.volgroupID;
            GuiClient.doRequest(this, request);
        }
    }

    protected BaseTreeNode makeChild(NameList lv) {
        return new LogicalVolumeTreeNode(lv.nlID, lv.nlName, lv.nlName2, lv.nlID2, this.computer);
    }

    public void handleResponse(short status, Response response) {
        NameList lv = null;
        NameList lvGood = null;
        NameList x = null;
        if (status <= 4) {
            lv = (NameList)response.responseData;
        }
        if (Constants.isDiskArray((short)this.computer.nlID2)) {
            while (lv != null) {
                x = lv.nlNext;
                lv.nlNext = lvGood;
                lvGood = lv;
                lv = x;
            }
            lv = lvGood;
        }
        while (lv != null) {
            this.add(this.makeChild(lv));
            lv = lv.nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }
}

