/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeDDI;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AlertableTreeNode;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalVolumeTreeNode
extends AlertableTreeNode {
    protected int logicalVolumeID;
    protected NameList computer;
    private static final String NOT_MOUNTED = "    " + MessageLog.getMessageNoID("STG1133T");

    public LogicalVolumeTreeNode(int logicalVolumeID, String path, String name, int filesystemID, NameList pComputer) {
        super(filesystemID);
        int index;
        this.logicalVolumeID = logicalVolumeID;
        this.computer = pComputer;
        if (logicalVolumeID < 0) {
            path = path + NOT_MOUNTED;
        }
        if ((index = path.indexOf(":")) > 0 && this.computer.nlID2 == 21) {
            path = path.substring(0, index);
        }
        if (this.computer.nlID2 == 15 || this.computer.nlID2 == 14 || this.computer.nlID2 == 18) {
            this.setUserObject(name);
        } else if (this.computer.nlID2 == 12) {
            if (path.charAt(0) == '0') {
                this.setUserObject(path + " (CKD)");
            } else {
                this.setUserObject(path);
            }
        } else if (this.computer.nlID2 == 25 || this.computer.nlID2 == 27) {
            if (!Util.isEmpty(name)) {
                this.setUserObject(name + " (" + path + ")");
            } else {
                this.setUserObject("(" + path + ")");
            }
        } else {
            this.setUserObject(path);
        }
        this.setAllowsChildren(false);
        this.reset();
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.render(renderer, tree, sel, expanded, leaf, row, hasFocus);
        if (this.ID > 0) {
            renderer.setIcon(IconFactory.getFilesystemIcon());
        } else {
            renderer.setIcon(IconFactory.getLogicalVolumeIcon());
        }
    }

    public void select(TreeSelectionEvent event) {
        new LogicalVolumeDDI(this, this.logicalVolumeID, this.ID, this.computer, this.getUserObject().toString());
    }

    protected NameList getNameList() {
        NameList result = new NameList();
        result.nlID = this.ID;
        result.nlID2 = this.computer.nlID;
        result.nlInfo = (short)3;
        return result;
    }
}

