/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.HistoryChart;
import org.eclipse.aperi.TStorm.gui.ReportCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.TStorm.gui.SavedReportNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.ExportTableData;
import org.eclipse.aperi.gui.FlexibleTable;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.gui.PrintComponent;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingDDI
extends SavedReportDDI
implements ActionListener,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    String firstReportDescription;
    JTabbedPane tabPanel;
    TabNode tabNodeHead;
    TabNode tabNodeTail;
    Object[] objectName;
    int selectedIndex;
    public boolean jumpToChart;
    private int selectionServices;
    protected byte productCode;
    private boolean jumpStart;
    private boolean saveEnabled;
    private boolean exportEnabled;
    private boolean changeListening;
    private boolean saveAs;
    private boolean showing;
    protected boolean productAvailable = true;
    boolean selectionError;
    boolean listNeeded;
    String selectionTabTip;
    String selectionTabTitle;
    String reportTabTitle;
    ReportingSelectionDriver selectionPanel;
    static final String CHART = MessageLog.getMessageNoID("STG5052L");
    static final String CHARTPOPUP = MessageLog.getMessageNoID("STG2091T");
    static final String EXPORT = MessageLog.getMessageNoID("GUI5077T");
    static final String ROWS = MessageLog.getMessageNoID("STG5262L");
    static final int MAX_REPORT_NODE = 776;
    static final int CHART_NODE = 777;
    static final int OBJECT_NODE = 999;
    private GridBagConstraints gbc = new GridBagConstraints();
    private boolean pmReportTooBig = false;
    protected FlexibleTable printableTable;
    protected PageFormat pf;
    protected Graphics g;
    protected IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ReportingDDI(GuiSavedReportReq gsrr, BaseTreeNode treeNodeIn) {
        this(gsrr.grr, treeNodeIn);
        this.gsrr = gsrr;
        this.setDescription(gsrr.creator + "." + gsrr.getName());
        this.selectedIndex = 1;
        this.jumpStart = true;
    }

    public ReportingDDI(GuiReportReq grr, BaseTreeNode treeNodeIn) {
        this.grr = grr;
        this.productAvailable = true;
        this.treeNode = treeNodeIn;
        this.selectionServices = ((ReportingTreeNode)this.treeNode).selectionServices;
        this.productCode = ((ReportingTreeNode)this.treeNode).productCode;
        this.displayInScrollPane = false;
        this.setDescription(GuiReportReq.guiClasses[grr.reportType][2] == GuiReportReq.subtypeTreeLabels[grr.reportSubtype][0] ? "" : MessageLog.getMessageNoID(GuiReportReq.guiClasses[grr.reportType][2]) + Util.getString("COLON") + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[grr.reportSubtype][0]));
        this.objectName = new Object[1];
        if (this.selectionServices == 4) {
            this.reportTabTitle = MessageLog.getMessageNoID(GuiReportReq.guiClasses[grr.reportType][2]);
            if (this.getDescription().equals("")) {
                this.setDescription(this.reportTabTitle);
            }
            this.objectName[0] = this.reportTabTitle;
        } else {
            this.setTabTitleAndObjectName();
        }
        this.firstReportDescription = this.getDescription();
        this.helpID = grr.reportSubtype == 15 && grr.reportType == 31 && grr.profile == 24 ? "mrsys1" : GuiReportReq.guiClasses[grr.reportType][4];
        this.selectionTabTip = MessageLog.getMessageNoID("STG5010L", this.objectName);
        this.selectionTabTitle = MessageLog.getMessageNoID("STG5049L");
        if (this.guiMain.getUserPrefs().tabToDisplay != 0) {
            this.selectedIndex = 1;
            this.jumpStart = true;
            if (this.guiMain.getUserPrefs().tabToDisplay == 2) {
                this.jumpToChart = true;
            }
            if (grr.profile == 0) {
                this.setJumpPrefs();
            }
        }
    }

    private void setTabTitleAndObjectName() {
        switch (this.grr.reportSubtype) {
            case 8: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3143L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG2016L");
                break;
            }
            case 9: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3116T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3117L");
                break;
            }
            case 10: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3135T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1006L");
                break;
            }
            case 11: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3124T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4032L");
                break;
            }
            case 12: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1102L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4041L");
                break;
            }
            case 13: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3125T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3012L");
                break;
            }
            case 14: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1104L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG5004L");
                break;
            }
            case 15: {
                this.objectName[0] = MessageLog.getMessageNoID("STG2038L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG2038L");
                break;
            }
            case 27: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1004L");
                break;
            }
            case 16: {
                this.objectName[0] = MessageLog.getMessageNoID("STG0022T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3154L");
                break;
            }
            case 6: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3122T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3123L");
                break;
            }
            case 30: {
                this.objectName[0] = MessageLog.getMessageNoID("STG2019L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG2020L");
                break;
            }
            case 74: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4201L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4197L");
                break;
            }
            case 75: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4202L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4198L");
                break;
            }
            case 76: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1004L");
                break;
            }
            case 77: 
            case 89: 
            case 90: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4201L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4191L");
                break;
            }
            case 73: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4203L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4199L");
                break;
            }
            case 82: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1136L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1149L");
                break;
            }
            case 101: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1136L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3913L");
                break;
            }
            case 102: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3925L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3914L");
                break;
            }
            case 103: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3925L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3915L");
                break;
            }
            case 104: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3925L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3916L");
                break;
            }
            default: {
                this.objectName[0] = MessageLog.getMessageNoID("STG6052L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG6053L");
            }
        }
    }

    protected void setJumpPrefs() {
        ReportPrefs prefs = ReportPrefsManager.getOne(this.grr.reportType);
        this.grr.profile = prefs.rpProfileID;
        switch (this.grr.reportSubtype) {
            case 8: {
                this.grr.rowsToReturn = prefs.rpDirMaxRows;
                break;
            }
            case 9: {
                this.grr.rowsToReturn = prefs.rpDirGrpMaxRows;
                break;
            }
            case 10: {
                this.grr.rowsToReturn = prefs.rpFSMaxRows;
                break;
            }
            case 11: {
                this.grr.rowsToReturn = prefs.rpFSGrpMaxRows;
                break;
            }
            case 12: 
            case 82: {
                this.grr.rowsToReturn = prefs.rpComputerMaxRows;
                break;
            }
            case 13: {
                this.grr.rowsToReturn = prefs.rpCompGrpMaxRows;
                break;
            }
            case 14: {
                this.grr.rowsToReturn = prefs.rpDomMaxRows;
                break;
            }
            case 15: {
                this.grr.rowsToReturn = prefs.rpNetMaxRows;
                break;
            }
            case 16: {
                this.grr.rowsToReturn = prefs.rpQuotaMaxRows;
            }
        }
        if (this.grr.reportType == 67) {
            switch (this.grr.reportSubtype) {
                case 12: 
                case 73: {
                    this.grr.bySubtype = 75;
                    break;
                }
                default: {
                    this.grr.bySubtype = 12;
                }
            }
        }
    }

    public void losingFocus() {
        if (!this.showing) {
            if (this.selectionPanel != null && this.gsrr == null) {
                this.selectionPanel.setPrefs();
            }
            if (this.saveEnabled && !this.pmReportTooBig) {
                this.saveEnabled = false;
                this.guiMain.setSaveActionEnabled(false, false);
                this.guiMain.setSaveAsActionEnabled(false, false);
                this.guiMain.setSaveActionToolTip(null);
                this.guiMain.setSaveAsActionToolTip(null);
                this.guiMain.removeSaveActionListener(this);
                this.guiMain.removeSaveAsActionListener(this);
            }
            this.disableExport();
        }
    }

    public void panelToBeNulled() {
        if (this.tabPanel != null) {
            this.selectedIndex = this.tabPanel.getSelectedIndex();
            this.tabPanel = null;
            if (this.selectionPanel != null) {
                try {
                    this.selectionPanel.getData();
                }
                catch (GeneralException generalException) {
                    // empty catch block
                }
                this.selectionPanel = null;
            }
        }
    }

    public void goingAway() {
        if (this.changeListening) {
            ChangeManager.removeListener(this);
        }
        this.deletePartitions(this.tabNodeHead);
    }

    public void reDisplay() {
        if (!this.productAvailable) {
            return;
        }
        String username = GuiUtil.getUserName();
        if (this.panel == null) {
            this.panel = new JPanel();
            ((JPanel)this.panel).setLayout(new BorderLayout());
            JPopupMenu popup = null;
            if (this.treeNode instanceof SavedReportNode) {
                popup = this.treeNode.getPopupMenuForButtons();
                JPanel buttonPanel = this.getButtonPanel(popup);
                if (this.getActionButtonCount() > 0) {
                    this.panel.add((Component)buttonPanel, "North");
                }
            }
            this.tabPanel = new JTabbedPane();
            this.tabPanel.setFont(BaseTree.boldFont);
            if (this.selectedIndex > 0) {
                this.listNeeded = true;
                this.tabPanel.insertTab(this.selectionTabTitle, null, new JPanel(), this.selectionTabTip, 0);
            } else {
                this.selectionPanel = new ReportingSelectionDriver(this, this.grr, this.selectionServices, this.objectName);
                this.tabPanel.insertTab(this.selectionTabTitle, null, this.selectionPanel, this.selectionTabTip, 0);
            }
            ((JPanel)this.panel).add((Component)this.tabPanel, "Center");
            if (this.tabNodeHead != null) {
                this.rebuild();
            }
            this.tabPanel.addChangeListener(this);
            Mouser mouser = new Mouser();
            this.tabPanel.addMouseListener(mouser);
        }
        if (this.jumpStart) {
            this.jumpStart = false;
            this.addFirstReport(this.grr);
        }
        this.showing = true;
        this.show();
        this.showing = false;
        this.checkTab();
        if (!this.saveEnabled && !this.pmReportTooBig) {
            this.saveEnabled = true;
            this.guiMain.setSaveActionEnabled(true, true);
            this.guiMain.setSaveAsActionEnabled(true, true);
            this.guiMain.setSaveActionToolTip(MessageLog.getMessageNoID("GUI5066T"));
            this.guiMain.setSaveAsActionToolTip(MessageLog.getMessageNoID("GUI5067T"));
            this.guiMain.removeSaveActionListener(this);
            this.guiMain.removeSaveAsActionListener(this);
        }
        if (!this.changeListening) {
            this.changeListening = true;
            ChangeManager.addListener(this, (short)35);
        }
    }

    private void rebuild() {
        int tabIndex = 1;
        TabNode tabNode = this.tabNodeHead;
        while (tabNode != null) {
            this.rebuild(tabNode, tabIndex);
            ++tabIndex;
            tabNode = tabNode.next;
        }
        this.tabPanel.setSelectedIndex(this.selectedIndex);
        this.checkTab();
    }

    protected void rebuild(TabNode tabNode, int tabIndex) {
        if (tabNode.level == 777) {
            JPanel chartPanel = new JPanel(new GridLayout(1, 1));
            chartPanel.add(tabNode.chart);
            this.makeTab(tabNode.title, chartPanel, tabNode.toolTip, tabIndex, tabNode);
        } else if (tabNode.level == 999) {
            ReportingObjectBuilder builder = null;
            JPanel objectPanel = new JPanel(new GridLayout(1, 1));
            try {
                Class<?> bClass = Class.forName(tabNode.className);
                builder = (ReportingObjectBuilder)bClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Class load failed");
                builder = null;
            }
            if (builder != null) {
                Component component;
                tabNode.baseComponent = component = builder.build(tabNode.object);
                objectPanel.add(component);
                if (builder instanceof HistoryChart) {
                    tabNode.builder = builder;
                }
                this.makeTab(tabNode.title, objectPanel, tabNode.toolTip, tabIndex, tabNode);
            }
        } else {
            this.makeTab(tabNode.title, null, tabNode.toolTip, tabIndex, tabNode);
            tabNode.tableNeeded = true;
        }
    }

    public static JComponent getNoDataMessage(GuiReportReq grr) {
        JLabel noDataLabel = new JLabel();
        if (grr != null && (grr.reportSubtype == 24 || grr.reportSubtype == 23)) {
            noDataLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else {
            noDataLabel.setText(MessageLog.getMessageNoID("STG0020M"));
        }
        noDataLabel.setHorizontalAlignment(0);
        return noDataLabel;
    }

    public JComponent getNoDataMessage_instance(GuiReportReq grr) {
        JLabel noDataLabel = new JLabel();
        if (grr != null && (grr.reportSubtype == 24 || grr.reportSubtype == 23)) {
            noDataLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else {
            noDataLabel.setText(MessageLog.getMessageNoID("STG0020M"));
        }
        noDataLabel.setHorizontalAlignment(0);
        this.disableExport();
        return noDataLabel;
    }

    public void addFirstReport(GuiReportReq grr) {
        TabNode tabNode = this.tabNodeHead;
        while (tabNode != null) {
            this.tabPanel.removeTabAt(1);
            tabNode = tabNode.next;
        }
        this.deletePartitions(this.tabNodeHead);
        grr.partitionToken = 0L;
        this.tabNodeTail = this.tabNodeHead = new TabNode(grr, this.reportTabTitle, this.firstReportDescription);
        this.tabNodeHead.level = 1;
        this.makeReport(grr, this.reportTabTitle, this.firstReportDescription, 1, this.tabNodeHead);
    }

    public void addReport(GuiReportReq parentGrr, GuiReportReq childGrr, String name) {
        String toolTip;
        String string = toolTip = GuiReportReq.guiClasses[childGrr.reportType][2] == GuiReportReq.subtypeTreeLabels[childGrr.reportSubtype][0] ? "" : MessageLog.getMessageNoID(GuiReportReq.guiClasses[childGrr.reportType][2]) + Util.getString("COLON") + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[childGrr.reportSubtype][0]);
        if (name.length() > 64) {
            name = name.substring(0, 62) + "-";
        }
        TabNode newTabNode = new TabNode(childGrr, name, toolTip);
        int index = 2;
        TabNode oldTabNode = this.tabNodeHead;
        while (oldTabNode != null && oldTabNode.grr != parentGrr) {
            ++index;
            oldTabNode = oldTabNode.next;
        }
        if (oldTabNode != null) {
            newTabNode.level = oldTabNode.level + 1;
            oldTabNode = oldTabNode.next;
            while (oldTabNode != null && oldTabNode.level >= newTabNode.level) {
                ++index;
                oldTabNode = oldTabNode.next;
            }
            if (oldTabNode == null) {
                newTabNode.prev = this.tabNodeTail;
                this.tabNodeTail.next = newTabNode;
                this.tabNodeTail = newTabNode;
            } else {
                newTabNode.prev = oldTabNode.prev;
                newTabNode.next = oldTabNode;
                oldTabNode.prev = newTabNode;
                newTabNode.prev.next = newTabNode;
            }
            this.makeReport(childGrr, name, toolTip, index, newTabNode);
        }
    }

    public void makeReport(GuiReportReq grr, String title, String toolTip, int tabIndex, TabNode tabNode) {
        JPanel newPanel = null;
        try {
            Object[] args;
            Constructor<?> constr;
            Class<?> rClass = Class.forName(GuiReportReq.guiClasses[grr.reportType][0]);
            Class[] argdef2 = new Class[]{GuiReportReq.class, ReportingDDI.class};
            try {
                constr = rClass.getConstructor(argdef2);
                args = new Object[2];
                args[1] = this;
            }
            catch (NoSuchMethodException e) {
                try {
                    argdef2[1] = DataDisplayInfo.class;
                    constr = rClass.getConstructor(argdef2);
                    args = new Object[2];
                    args[1] = this;
                }
                catch (NoSuchMethodException e1) {
                    Class[] argdef1 = new Class[]{GuiReportReq.class};
                    constr = rClass.getConstructor(argdef1);
                    args = new Object[]{grr};
                }
            }
            newPanel = (JPanel)constr.newInstance(args);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        this.makeTab(title, newPanel, toolTip, tabIndex, tabNode);
    }

    public void addChart(GuiReportReq grr, JComponent chart, String toolTip) {
        TabNode newTabNode = new TabNode(chart, CHART, toolTip, chart);
        int index = 2;
        TabNode oldTabNode = this.tabNodeHead;
        while (oldTabNode != null && oldTabNode.grr != grr) {
            ++index;
            oldTabNode = oldTabNode.next;
        }
        if (oldTabNode != null) {
            oldTabNode = oldTabNode.next;
            while (oldTabNode != null && (oldTabNode.level == 777 || oldTabNode.level == 999)) {
                ++index;
                oldTabNode = oldTabNode.next;
            }
            if (oldTabNode == null) {
                newTabNode.prev = this.tabNodeTail;
                this.tabNodeTail.next = newTabNode;
                this.tabNodeTail = newTabNode;
            } else {
                newTabNode.prev = oldTabNode.prev;
                newTabNode.next = oldTabNode;
                oldTabNode.prev = newTabNode;
                newTabNode.prev.next = newTabNode;
            }
            JPanel chartPanel = new JPanel(new GridLayout(1, 1));
            chartPanel.add(chart);
            this.makeTab(CHART, chartPanel, toolTip, index, newTabNode);
        }
    }

    public void addObject(GuiReportReq grr, String className, Object object, String tabName, String toolTip) {
        this.addObject(grr, className, object, tabName, toolTip, -1, null);
    }

    public void addObject(GuiReportReq grr, String className, Object object, String tabName, String toolTip, Object caller) {
        this.addObject(grr, className, object, tabName, toolTip, -1, caller);
    }

    public void addObject(GuiReportReq grr, String className, Object object, String tabName, String toolTip, int tabIndex, Object caller) {
        ReportingObjectBuilder builder = null;
        try {
            Class<?> bClass = Class.forName(className);
            builder = (ReportingObjectBuilder)bClass.newInstance();
            if (builder instanceof HistoryChart) {
                ((HistoryChart)builder).setDDI(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Class load failed");
            builder = null;
        }
        if (builder != null) {
            Component component = builder.build(object);
            JPanel objectPanel = new JPanel(new GridLayout(1, 1));
            objectPanel.add(component);
            TabNode newTabNode = new TabNode(object, tabName, toolTip, className, component);
            if (builder instanceof HistoryChart) {
                newTabNode.builder = builder;
                HistoryChoiceInterface table = (HistoryChoiceInterface)caller;
                newTabNode.historyArrays = table.getChoices(grr.reportType, grr.reportSubtype);
                newTabNode.historySubtype = grr.reportSubtype;
            }
            int index = 2;
            TabNode oldTabNode = this.tabNodeHead;
            if (tabIndex > 0) {
                index = tabIndex;
                while (oldTabNode != null && tabIndex > 1) {
                    --tabIndex;
                    oldTabNode = oldTabNode.next;
                }
            } else {
                while (oldTabNode != null && oldTabNode.grr != grr) {
                    ++index;
                    oldTabNode = oldTabNode.next;
                }
                if (oldTabNode != null) {
                    oldTabNode = oldTabNode.next;
                    while (oldTabNode != null && (oldTabNode.level == 777 || oldTabNode.level == 999)) {
                        ++index;
                        oldTabNode = oldTabNode.next;
                    }
                }
            }
            if (oldTabNode == null) {
                newTabNode.prev = this.tabNodeTail;
                this.tabNodeTail.next = newTabNode;
                this.tabNodeTail = newTabNode;
            } else {
                newTabNode.prev = oldTabNode.prev;
                newTabNode.next = oldTabNode;
                oldTabNode.prev = newTabNode;
                newTabNode.prev.next = newTabNode;
            }
            this.makeTab(tabName, objectPanel, toolTip, index, newTabNode);
        }
    }

    protected void makeTab(String title, Component component, String toolTip, int tabIndex, TabNode tabNode) {
        tabNode.rowsLabel = null;
        JPanel addPanel = new JPanel();
        if (component != null) {
            TJCTableMouseInterface showsPopup;
            addPanel.setLayout(new BorderLayout());
            tabNode.titlePanel = new JPanel(new GridBagLayout());
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.gridwidth = 0;
            this.gbc.insets.bottom = 4;
            this.gbc.insets.left = 4;
            tabNode.titleLabel = new JLabel(toolTip);
            tabNode.titlePanel.add((Component)tabNode.titleLabel, this.gbc);
            if (DisplaysChartPopupInterface.class.isInstance(component) && (showsPopup = ((DisplaysChartPopupInterface)((Object)component)).getShowsPopup()) != null) {
                JButton chartButton = new JButton(IconFactory.getPieChartIcon());
                chartButton.setMargin(new Insets(0, 0, 0, 0));
                chartButton.setToolTipText(CHARTPOPUP);
                chartButton.addActionListener(new ChartButtonPressed(showsPopup));
                GuiUtil.setAccessible(chartButton, CHARTPOPUP, CHARTPOPUP);
                this.gbc.gridwidth = 1;
                tabNode.titlePanel.add((Component)chartButton, this.gbc);
                this.gbc.gridwidth = 0;
            }
            JPanel wrapperPanel = new JPanel(new FlowLayout(0));
            wrapperPanel.setOpaque(false);
            wrapperPanel.add(tabNode.titlePanel);
            addPanel.add((Component)wrapperPanel, "North");
            addPanel.add(component, "Center");
        }
        this.tabPanel.insertTab(title, null, addPanel, toolTip, tabIndex);
        this.tabPanel.setSelectedIndex(tabIndex);
        if (!this.jumpToChart) {
            this.showing = true;
            this.show();
            this.showing = false;
        }
    }

    public void addRowCount(ReportDataAdjuster adjuster) {
        int index = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        for (int i = 1; i < index; ++i) {
            tabNode = tabNode.next;
        }
        if (tabNode.titlePanel != null) {
            if (tabNode.rowsLabel != null) {
                tabNode.titlePanel.remove(tabNode.rowsLabel);
            }
            int rows = adjuster.getNumberRows();
            if (adjuster.hasTotalsRow()) {
                --rows;
            }
            tabNode.rowsLabel = new BlackLabel(" " + ROWS + " " + rows);
            tabNode.titlePanel.add((Component)tabNode.rowsLabel, this.gbc);
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.checkTab();
    }

    private void checkTab() {
        int index = this.tabPanel.getSelectedIndex();
        if (index == 0) {
            if (this.listNeeded) {
                this.listNeeded = false;
                this.selectionPanel = new ReportingSelectionDriver(this, this.grr, this.selectionServices, this.objectName);
                this.tabPanel.removeTabAt(0);
                this.tabPanel.insertTab(this.selectionTabTitle, null, this.selectionPanel, this.selectionTabTip, 0);
                this.tabPanel.setSelectedIndex(0);
            }
            this.disableExport();
        } else {
            TabNode tabNode = this.tabNodeHead;
            for (int nodeNum = 1; nodeNum < index; ++nodeNum) {
                tabNode = tabNode.next;
            }
            if (tabNode.tableNeeded) {
                tabNode.tableNeeded = false;
                this.tabPanel.removeTabAt(index);
                this.makeReport(tabNode.grr, tabNode.title, tabNode.toolTip, index, tabNode);
            }
            if (tabNode.level <= 776) {
                if (tabNode.grr.reportSubtype != 28 || tabNode.grr.reportType == 4 || tabNode.grr.reportType == 5) {
                    this.enableExport();
                } else {
                    this.disableExport();
                }
            } else if (tabNode.builder != null) {
                this.enableExport();
            } else {
                this.disableExport();
                this.guiMain.setPrintActionEnabled(true, true);
            }
        }
    }

    protected void enableExport() {
        this.guiMain.setExportActionEnabled(true, true);
        this.guiMain.setExportActionToolTip(EXPORT);
        if (!this.exportEnabled) {
            this.exportEnabled = true;
            this.guiMain.addExportActionListener(this);
        }
    }

    protected void disableExport() {
        this.guiMain.setExportActionEnabled(false, false);
        this.guiMain.setExportActionToolTip(null);
        this.guiMain.setPrintActionEnabled(false, false);
        if (this.exportEnabled) {
            this.exportEnabled = false;
            this.guiMain.removeExportActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String source = event.getActionCommand();
        if (source == "Save") {
            this.saveAs = false;
            this.save();
        } else if (source == "SaveAs") {
            this.saveAs = true;
            this.save();
        } else if (source == "Export") {
            this.export();
        }
    }

    private void save() {
        GeneralException exception = null;
        GuiSavedReportReq newGsrr = new GuiSavedReportReq();
        if (this.gsrr == null || this.gsrr.ID <= 299) {
            this.saveAs = true;
            newGsrr.creator = GuiUtil.getUserName();
            newGsrr.grr = this.grr;
        } else {
            newGsrr.creator = this.gsrr.creator;
            newGsrr.setName(this.gsrr.getTrueName());
            newGsrr.ID = this.gsrr.ID;
            newGsrr.grr = this.gsrr.grr;
        }
        newGsrr.productCode = this.productCode;
        if (this.selectionPanel != null) {
            try {
                this.selectionPanel.getData();
            }
            catch (GeneralException e) {
                exception = e;
            }
        }
        if (exception != null) {
            GuiUtil.displayException(exception);
            exception = null;
            this.showing = true;
            this.show();
            this.showing = false;
            return;
        }
        if (this.saveAs) {
            newGsrr.ID = -1;
            String title = MessageLog.getMessageNoID("GUI5007L");
            String str = MessageLog.getMessageNoID("STG4207L");
            String prompt = MessageLog.getMessageNoID("GUI5011L", new Object[]{str});
            boolean going = true;
            while (going) {
                newGsrr.setName(GuiUtil.displayOkCancelPane(title, prompt, 32, false, null, this.guiMain.getFrame()));
                going = newGsrr.getName() != null && !newGsrr.getName().equals("") && newGsrr.getName().indexOf(46) >= 0;
                if (!going) continue;
                String s = MessageLog.getMessageNoTS("GUI0056E", null);
                GuiUtil.displayErrorMessage(s);
            }
        }
        if (newGsrr.getName() != null && !newGsrr.getName().equals("")) {
            SavedReportNode.doRequest(this, newGsrr);
        }
    }

    public void handleResponse(short status, Response response) {
        Serializable data;
        if (status <= 4 && response.responseData != null && (data = response.responseData) instanceof GuiSavedReportReq) {
            this.gsrr = (GuiSavedReportReq)response.responseData;
            this.changeDescription();
            NameList element = new NameList();
            element.nlInfo = (short)35;
            element.nlName = this.gsrr.getName();
            element.nlID = this.gsrr.ID;
            element.nlState = this.productCode;
            ChangeManager.signalChange(1, element);
        }
    }

    private void export() {
        int index = this.tabPanel.getSelectedIndex();
        MegaTable table = this.getTable();
        if (table != null) {
            String title;
            if (index == 1) {
                title = this.getDescription();
            } else {
                TabNode tabNode = this.tabNodeHead;
                for (int nodeNum = 1; nodeNum < index; ++nodeNum) {
                    tabNode = tabNode.next;
                }
                title = tabNode.toolTip;
            }
            ExportTableData.exportTable(table, null, title);
        } else {
            TabNode tabNode = this.getTabNode();
            if (tabNode.builder != null && tabNode.builder instanceof HistoryChart) {
                GuiReportReq newGrr = (GuiReportReq)tabNode.object;
                tabNode.builder.build(tabNode.object);
                Object[] arrays = ((HistoryChart)tabNode.builder).getArrays();
                String[] messages = (String[])tabNode.historyArrays[0];
                byte[] reports = (byte[])tabNode.historyArrays[2];
                String header = null;
                for (int i = 0; i < reports.length; ++i) {
                    if (reports[i] != newGrr.histSubtype) continue;
                    header = ReportCreateOrEdit.adjustHistoryName(messages[i]);
                    if (tabNode.historyArrays.length <= 3) break;
                    messages = (String[])tabNode.historyArrays[3];
                    header = header.endsWith("%") ? header + "  " : header + " ";
                    header = header + MessageLog.getMessageNoID(messages[newGrr.histSubtypeRange - 1]);
                    break;
                }
                ExportTableData.exportHistory(tabNode.historySubtype, arrays, null, tabNode.toolTip, header);
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        this.pf = pf;
        this.g = g;
        if (this.tabPanel == null) {
            super.print(g, pf, pageIndex);
        } else {
            JTableHeader header;
            int tabIndex = this.tabPanel.getSelectedIndex();
            MegaTable table = null;
            if (tabIndex > 0) {
                table = this.getTable();
            }
            if (table == null) {
                this.printableTable = null;
                return super.print(g, pf, pageIndex);
            }
            this.printableTable = this.generatePrintableJTable(table, g);
            Dimension size = null;
            if (this.printableTable.getWidth() == 0 || this.printableTable.getHeight() == 0) {
                this.printableTable.setSize(this.printableTable.getPreferredSize());
            }
            if ((header = this.printableTable.getTableHeader()).getHeight() == 0 || header.getWidth() == 0) {
                header.setSize(header.getPreferredSize());
            }
            int tableWidth = this.printableTable.getWidth();
            int tableHeight = this.printableTable.getHeight();
            int positionX = 0;
            int index = 0;
            for (int positionY = 0; positionY < tableHeight; positionY += size.height) {
                for (positionX = 0; positionX < tableWidth; positionX += size.width) {
                    size = this.getPrintableClip(this.printableTable, positionX, positionY, g);
                    if (index == pageIndex) {
                        this.paintTable(this.printableTable, g, positionX, positionY, size, index);
                        return 0;
                    }
                    ++index;
                }
            }
        }
        return 1;
    }

    protected Dimension getPrintableClip(JTable table, int positionX, int positionY, Graphics g) {
        int printHeight;
        Rectangle rect;
        int printWidth;
        int firstCol = table.columnAtPoint(new Point(positionX, positionY));
        int firstRow = table.rowAtPoint(new Point(positionX, positionY));
        int maxWidth = (int)this.pf.getImageableWidth();
        int maxHeight = (int)this.pf.getImageableHeight();
        maxHeight -= table.getTableHeader().getHeight();
        FontMetrics fm = g.getFontMetrics(table.getFont());
        maxHeight -= fm.getHeight() * 4;
        maxHeight -= fm.getAscent() * 2;
        int lastCol = table.columnAtPoint(new Point(positionX + maxWidth, positionY));
        if (lastCol == -1) {
            printWidth = table.getWidth() - positionX;
        } else {
            rect = table.getCellRect(0, lastCol - 1, true);
            printWidth = rect.x + rect.width - positionX;
        }
        int lastRow = table.rowAtPoint(new Point(positionX, positionY + maxHeight));
        if (lastRow == -1) {
            printHeight = table.getHeight() - positionY;
        } else {
            rect = table.getCellRect(lastRow - 1, 0, true);
            printHeight = rect.y + rect.height - positionY;
        }
        return new Dimension(printWidth, printHeight);
    }

    protected void paintTable(JTable printableTable, Graphics g, int positionX, int positionY, Dimension size, int pageIndex) {
        int offsetX = (int)this.pf.getImageableX();
        int offsetY = (int)this.pf.getImageableY();
        JTableHeader header = printableTable.getTableHeader();
        int headerHeight = header.getHeight();
        int byLineHeight = 0;
        g.translate(offsetX - positionX, offsetY);
        g.setFont(printableTable.getFont().deriveFont(1));
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        byLineHeight = fm.getAscent();
        byLineHeight += fm.getHeight();
        if (pageIndex == 0) {
            g.drawString(PrintPreviewable.CREATED_BY + " " + GuiUtil.getUserName() + "     " + PrintPreviewable.PRINTED_ON + " " + Util.formatDateTime(new Date()), 0, fm.getAscent());
        }
        g.drawString(this.getDescription(), positionX, byLineHeight);
        byLineHeight = fm.getHeight() * 3;
        g.translate(0, byLineHeight);
        g.clipRect(positionX, 0, size.width, size.height + headerHeight);
        header.setForeground(Color.black);
        header.setBackground(Color.white);
        header.paint(g);
        g.translate(0, headerHeight - positionY);
        g.clipRect(positionX, positionY, size.width, size.height);
        printableTable.paint(g);
        g.translate(0, -(headerHeight - positionY + byLineHeight));
        g.setClip(positionX, 0, (int)this.pf.getImageableWidth(), (int)this.pf.getImageableHeight());
        g.drawString(Util.getString("LABEL_PAGE_X_OF_Y", Integer.toString(pageIndex + 1), Integer.toString(this.getNumberOfPages())), positionX, (int)(this.pf.getImageableHeight() - (double)fm.getHeight()));
    }

    public int getNumberOfPages() {
        if (this.printableTable == null) {
            return super.getNumberOfPages();
        }
        Dimension size = null;
        int tableWidth = this.printableTable.getWidth();
        int tableHeight = this.printableTable.getHeight();
        int positionX = 0;
        int pageIndex = 0;
        for (int positionY = 0; positionY < tableHeight; positionY += size.height) {
            positionX = 0;
            while (positionX < tableWidth) {
                size = this.getPrintableClip(this.printableTable, positionX, positionY, this.g);
                positionX += size.width;
                ++pageIndex;
            }
        }
        return pageIndex;
    }

    public PageFormat getPageFormat(int pageIndex) {
        if (this.printableTable == null) {
            return super.getPageFormat(pageIndex);
        }
        return this.pf;
    }

    public void printData(Container ignored) {
        if (this.tabPanel == null) {
            super.printData(null);
        } else {
            String title;
            int index = this.tabPanel.getSelectedIndex();
            if (index <= 1) {
                title = this.getDescription();
            } else {
                TabNode tabNode = this.tabNodeHead;
                for (int nodeNum = 1; nodeNum < index; ++nodeNum) {
                    tabNode = tabNode.next;
                }
                title = tabNode.toolTip;
            }
            MegaTable table = null;
            if (index > 0) {
                table = this.getTable();
            }
            if (table != null) {
                PrintTableData.printTable(this, table, GuiUtil.getUserName(), title, title);
            } else {
                Component output = null;
                output = index == 0 ? this.tabPanel.getComponentAt(0) : this.getTabNode().baseComponent;
                if (output != null) {
                    boolean offerHtml = false;
                    AperiChart htmlChart = null;
                    if (output instanceof AperiChart) {
                        offerHtml = true;
                        htmlChart = (AperiChart)output;
                    }
                    PrintOutputChooser chooser = new PrintOutputChooser();
                    chooser.allowCSV(this.exportEnabled);
                    chooser.allowFormatted(this.exportEnabled);
                    boolean pdfAllowed = this.getPdfAllowed();
                    PrintOptions options = chooser.getOptions(offerHtml, pdfAllowed);
                    if (options != null) {
                        options.htmlChart = htmlChart;
                        if (options.outputType == 1) {
                            new PrintPreviewPanel(this, title, true);
                        } else {
                            PrintComponent.print(options, output, GuiUtil.getUserName(), title, title, true);
                        }
                    }
                }
            }
        }
    }

    private MegaTable getTable() {
        MegaTable table = null;
        int index = this.tabPanel.getSelectedIndex();
        table = this.getTable((Container)this.tabPanel.getComponentAt(index));
        return table;
    }

    private MegaTable getTable(Container container) {
        MegaTable table = null;
        Component[] innerStuff = container.getComponents();
        for (int i = 0; i < innerStuff.length; ++i) {
            if (innerStuff[i] instanceof MegaTable) {
                table = (MegaTable)innerStuff[i];
                break;
            }
            if (innerStuff[i] instanceof Container && (table = this.getTable((Container)innerStuff[i])) != null) break;
        }
        return table;
    }

    private FlexibleTable generatePrintableJTable(MegaTable table, Graphics g) {
        int col;
        BaseTableModel model = (BaseTableModel)table.getDataSource();
        ReportDataAdjuster adjuster = model.getAdjuster();
        int[] columnArray = null;
        columnArray = adjuster.fixColumnArray(columnArray);
        int[] rowMap = new int[adjuster.getNumberFrozenRows() + adjuster.getNumberRows()];
        for (int i = 0; i < rowMap.length; ++i) {
            rowMap[i] = i;
        }
        String[] labels1 = adjuster.getLabels();
        int frozenRows = adjuster.getNumberFrozenRows();
        int numCols = labels1.length;
        int spannedRows = adjuster.getNumberSpannedRows();
        Object[] colNames = new String[columnArray.length];
        FlexibleTable printableTable = null;
        Object[][] rowNames = new String[adjuster.getNumberRows()][colNames.length];
        if (spannedRows == 0) {
            int i;
            for (i = 0; i < colNames.length; ++i) {
                col = columnArray[i];
                StringBuffer buff = new StringBuffer(25);
                buff.append(labels1[col]);
                if (frozenRows > 0) {
                    for (int j = 0; j < frozenRows; ++j) {
                        buff.append("\n");
                        buff.append(adjuster.getCellData(adjuster.getRowIndex(j, rowMap), col));
                    }
                }
                colNames[i] = buff.toString();
            }
            for (i = frozenRows; i < adjuster.getNumberRows() + frozenRows; ++i) {
                for (int j = 0; j < columnArray.length; ++j) {
                    rowNames[i - frozenRows][j] = this.formatData(adjuster, i, columnArray[j], rowMap);
                }
            }
        }
        boolean[] spanners = new boolean[numCols];
        if (spannedRows > 0) {
            for (int k = 0; k < columnArray.length; ++k) {
                col = columnArray[k];
                int nextCol = col + 1;
                if (nextCol >= labels1.length || labels1[nextCol].length() != 0) continue;
                spanners[col] = true;
                ++k;
            }
            for (int row = 0; row < spannedRows - 1; ++row) {
                for (int k = 0; k < columnArray.length; ++k) {
                    col = columnArray[k];
                    if (spanners[col]) {
                        colNames[k] = adjuster.getCellData(adjuster.getRowIndex(row + 1, rowMap), col).toString();
                        colNames[k + 1] = adjuster.getCellData(adjuster.getRowIndex(row + 1, rowMap), col + 1).toString();
                        ++k;
                        continue;
                    }
                    colNames[k] = labels1[col];
                }
            }
            for (int i = frozenRows; i < adjuster.getNumberRows() + frozenRows; ++i) {
                for (int j = 0; j < columnArray.length; ++j) {
                    rowNames[i - frozenRows][j] = this.formatData(adjuster, i, columnArray[j], rowMap);
                }
            }
        }
        DefaultTableModel dtm = new DefaultTableModel(rowNames, colNames);
        printableTable = new FlexibleTable(dtm);
        printableTable.setDoubleBuffered(false);
        printableTable.setAutoResizeMode(0);
        TableColumnModel columnModel = printableTable.getColumnModel();
        int columns = columnModel.getColumnCount();
        if (spannedRows > 0) {
            for (int row = 0; row < spannedRows - 1; ++row) {
                for (int k = 0; k < columnArray.length; ++k) {
                    col = columnArray[k];
                    if (spanners[col]) {
                        StringBuffer buff = new StringBuffer();
                        buff.append(labels1[col]);
                        buff.append("\n");
                        buff.append(adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col).toString());
                        printableTable.makeNewColumnGroup(buff.toString());
                        printableTable.addColumnToGroup(columnModel.getColumn(k));
                        printableTable.addColumnToGroup(columnModel.getColumn(++k));
                        continue;
                    }
                    colNames[k] = labels1[k];
                }
            }
        }
        FontMetrics fm = g.getFontMetrics(table.getFont().deriveFont(1));
        for (int i = 0; i < columns; ++i) {
            TableColumn column = columnModel.getColumn(i);
            int headerWidth = 0;
            StringTokenizer st = new StringTokenizer((String)colNames[i], "\r\n");
            while (st.hasMoreTokens()) {
                int hWidth = (int)fm.getStringBounds(st.nextToken(), g).getWidth();
                if (hWidth <= headerWidth) continue;
                headerWidth = hWidth;
            }
            headerWidth += fm.getMaxAdvance();
            int preferredColWidth = 0;
            fm = g.getFontMetrics(table.getFont());
            for (int j = 0; j < printableTable.getRowCount(); ++j) {
                preferredColWidth = (int)Math.max((double)preferredColWidth, fm.getStringBounds(printableTable.getModel().getValueAt(j, i).toString(), g).getWidth());
            }
            int width = Math.max(preferredColWidth, headerWidth) + fm.getMaxAdvance();
            column.setWidth(width);
            column.setMinWidth(width);
        }
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(4);
        printableTable.setDefaultRenderer(String.class, dtcr);
        return printableTable;
    }

    private String formatData(ReportDataAdjuster adjuster, int row, int col, int[] rowMap) {
        StringBuffer buffer = new StringBuffer(25);
        DateFormat df = DateFormat.getDateTimeInstance();
        DecimalFormat d0Fmt = new DecimalFormat();
        int[] rendererArray = adjuster.getRenderers();
        int rendererType = rendererArray[col];
        Object obj = adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
        int scale = adjuster.getScale();
        String suffix = adjuster.getSuffix();
        String data = rendererType == 0 ? (obj == null ? "-" : obj.toString()) : (rendererType == 7 ? TableCellStrings.SpaceRenderer(obj) : (rendererType == 1 ? TableCellStrings.DateRenderer(obj, df) : (rendererType == 2 ? TableCellStrings.DecimalRenderer(scale, suffix, obj, buffer) : (rendererType == 5 ? TableCellStrings.NumberRenderer(obj, d0Fmt) : (rendererType == 4 ? TableCellStrings.MegabyteRenderer(obj, d0Fmt) : (rendererType == 6 ? TableCellStrings.PercentRenderer(obj, d0Fmt) : (rendererType == 3 ? TableCellStrings.DurationRenderer(obj, buffer) : (rendererType == 8 ? TableCellStrings.SpaceNoDecimalRenderer(obj) : (rendererType == 9 ? Util.formatHertz(((Number)obj).intValue()) : "-")))))))));
        return data;
    }

    private TabNode getTabNode() {
        int index = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        for (int nodeNum = 1; nodeNum < index; ++nodeNum) {
            tabNode = tabNode.next;
        }
        return tabNode;
    }

    private String getTitle() {
        int index = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        for (int nodeNum = 1; nodeNum < index; ++nodeNum) {
            tabNode = tabNode.next;
        }
        return tabNode.toolTip;
    }

    public boolean setChartTitle(String title) {
        if (this.tabPanel == null) {
            return false;
        }
        int index = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        for (int nodeNum = 1; nodeNum < index; ++nodeNum) {
            tabNode = tabNode.next;
        }
        if (tabNode.titleLabel != null) {
            tabNode.titleLabel.setText(title);
        } else {
            tabNode.titleLabel = new JLabel(title);
        }
        tabNode.toolTip = title;
        this.tabPanel.setToolTipTextAt(index, title);
        return true;
    }

    public String getChartTitle() {
        int index = this.tabPanel.getSelectedIndex();
        String title = "";
        TabNode tabNode = this.tabNodeHead;
        for (int nodeNum = 1; nodeNum < index; ++nodeNum) {
            tabNode = tabNode.next;
        }
        if (tabNode.titleLabel != null) {
            title = tabNode.titleLabel.getText();
        }
        return title;
    }

    public void changeOccurred(int changeType, NameList element) {
        if (changeType == 0 && this.gsrr != null && element.nlID == this.gsrr.ID) {
            this.gsrr.setName(element.nlName);
            this.changeDescription();
        }
    }

    private void changeDescription() {
        this.setDescription(this.gsrr.creator + "." + this.gsrr.getName());
        if (ReportingDDI.getCurrent() == this) {
            this.showing = true;
            this.show();
            this.showing = false;
        }
    }

    private void deletePartitions(TabNode tabList) {
        int count = 0;
        TabNode tabNode = tabList;
        while (tabNode != null) {
            if (tabNode.grr != null && tabNode.grr.partitionToken != 0L) {
                ++count;
            }
            tabNode = tabNode.next;
        }
        if (count == 0) {
            return;
        }
        long[] idArray = new long[count];
        TabNode tabNode2 = tabList;
        while (tabNode2 != null) {
            if (tabNode2.grr != null && tabNode2.grr.partitionToken != 0L) {
                idArray[--count] = tabNode2.grr.partitionToken;
            }
            tabNode2 = tabNode2.next;
        }
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
        request.requestData = idArray;
        GuiClient.doRhetoricalRequest(request);
    }

    public int getSelectedIndex() {
        return this.tabPanel == null ? -1 : this.tabPanel.getSelectedIndex();
    }

    public void setHelpID(String helpID) {
        if (helpID != null) {
            this.helpID = helpID;
        }
    }

    public void setPmReportTooBig(boolean tooBig) {
        if (tooBig && !this.pmReportTooBig) {
            this.pmReportTooBig = true;
            this.guiMain.setSaveActionEnabled(false, false);
            this.guiMain.setSaveAsActionEnabled(false, false);
            this.guiMain.setSaveActionToolTip(null);
            this.guiMain.setSaveAsActionToolTip(null);
            this.guiMain.removeSaveActionListener(this);
            this.guiMain.removeSaveAsActionListener(this);
        } else if (!tooBig && this.pmReportTooBig) {
            this.pmReportTooBig = false;
            this.guiMain.setSaveActionEnabled(true, true);
            this.guiMain.setSaveAsActionEnabled(true, true);
            this.guiMain.setSaveActionToolTip(MessageLog.getMessageNoID("GUI5066T"));
            this.guiMain.setSaveAsActionToolTip(MessageLog.getMessageNoID("GUI5067T"));
            this.guiMain.removeSaveActionListener(this);
            this.guiMain.removeSaveAsActionListener(this);
        }
    }

    protected class TabNode {
        TabNode prev;
        TabNode next;
        int level;
        boolean tableNeeded;
        GuiReportReq grr;
        JComponent chart;
        Object object;
        Component baseComponent;
        JPanel titlePanel;
        JLabel rowsLabel;
        String className;
        String title;
        String toolTip;
        JLabel titleLabel;
        Object[] historyArrays;
        int historySubtype;
        ReportingObjectBuilder builder;

        public TabNode(GuiReportReq grr, String title, String toolTip) {
            this.grr = grr;
            this.title = title;
            this.toolTip = toolTip;
        }

        public TabNode(JComponent chart, String title, String toolTip, Component baseComponent) {
            this.chart = chart;
            this.title = title;
            this.toolTip = toolTip;
            this.baseComponent = baseComponent;
            this.level = 777;
        }

        public TabNode(Object object, String title, String toolTip, String className, Component baseComponent) {
            this.object = object;
            this.title = title;
            this.toolTip = toolTip;
            this.className = className;
            this.baseComponent = baseComponent;
            this.level = 999;
        }
    }

    private class Mouser
    extends MouseAdapter
    implements ActionListener {
        int mouseIndex;

        private Mouser() {
        }

        public void mousePressed(MouseEvent event) {
            this.checkPopup(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.checkPopup(event);
        }

        private void checkPopup(MouseEvent event) {
            if (event.isPopupTrigger()) {
                int x = event.getX();
                int y = event.getY();
                this.mouseIndex = ReportingDDI.this.tabPanel.getUI().tabForCoordinate(ReportingDDI.this.tabPanel, x, y);
                if (this.mouseIndex > 0) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem mi = menu.add(MessageLog.getMessageNoID("GUI5008L"));
                    mi.setActionCommand("Close");
                    mi.addActionListener(this);
                    menu.show(ReportingDDI.this.tabPanel, x, y);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Close") {
                TabNode delTabNode;
                ReportingDDI.this.tabPanel.removeTabAt(this.mouseIndex);
                if (this.mouseIndex == 1) {
                    delTabNode = ReportingDDI.this.tabNodeHead;
                    ReportingDDI.this.tabNodeHead = ReportingDDI.this.tabNodeHead.next;
                    if (ReportingDDI.this.tabNodeHead == null) {
                        ReportingDDI.this.tabNodeTail = null;
                    } else {
                        ReportingDDI.this.tabNodeHead.prev = null;
                    }
                } else {
                    delTabNode = ReportingDDI.this.tabNodeHead;
                    while (this.mouseIndex > 1) {
                        --this.mouseIndex;
                        delTabNode = delTabNode.next;
                    }
                    delTabNode.prev.next = delTabNode.next;
                    if (delTabNode.next == null) {
                        ReportingDDI.this.tabNodeTail = delTabNode.prev;
                    } else {
                        delTabNode.next.prev = delTabNode.prev;
                    }
                }
                delTabNode.next = null;
                ReportingDDI.this.deletePartitions(delTabNode);
            }
        }
    }

    private class ChartButtonPressed
    implements ActionListener {
        TJCTableMouseInterface showsPopup;

        ChartButtonPressed(TJCTableMouseInterface showsPopup) {
            this.showsPopup = showsPopup;
        }

        public void actionPerformed(ActionEvent e) {
            this.showsPopup.showPopup(-1, -1, (Component)e.getSource(), 10, 10);
        }
    }
}

