/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.DataReportingSelectionTable;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTableDialog;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class ReportingSelectionTable
extends JPanel
implements GuiRequestor,
ActionListener {
    public static final int ERROR = -1;
    public static final int NEVER_REQUESTED = 0;
    public static final int SUBMITTED = 1;
    public static final int GOT_DATA = 2;
    public static final int PANEL_BUILT = 3;
    public int status;
    MegaTable table;
    JButton selectButton;
    JButton clearButton;
    GuiReportReq grr;
    Object[] objectName;
    MutableInteger[] mInt;
    MutableLong[] mLong;
    int objectType = -1;
    int reportSubtype;
    private int lastClickedRow;
    private boolean lastClickSelected;
    ReportingSelectionTableDialog dialog;
    BaseTableModel dataModel;

    public static ReportingSelectionTable createInstance(ReportingSelectionTableDialog pDialog, GuiReportReq grr, int reportSubtype, Object[] objectName) {
        DataReportingSelectionTable result = null;
        result = new DataReportingSelectionTable(pDialog, grr, reportSubtype, objectName);
        return result;
    }

    protected ReportingSelectionTable(ReportingSelectionTableDialog pDialog, GuiReportReq grr, int reportSubtype, Object[] objectName) {
        this.dialog = pDialog;
        this.grr = grr;
        this.objectName = objectName;
        this.reportSubtype = reportSubtype;
        this.status = 0;
        this.lastClickedRow = -1;
    }

    protected abstract Request getRequest();

    public void submitRequest() {
        if (this.objectType != -1) {
            this.status = 1;
            Request request = this.getRequest();
            GuiClient.doRequest(this, request);
        }
    }

    public abstract void handleResponse(short var1, Response var2);

    protected abstract int getCountValue();

    protected abstract void sortData();

    public void buildPanel() {
        this.status = 3;
        int count = this.getCountValue();
        this.mInt = new MutableInteger[count];
        this.mLong = new MutableLong[count];
        for (int index = 0; index < count; ++index) {
            this.mInt[index] = new MutableInteger();
            this.mLong[index] = new MutableLong();
        }
        this.setBorder(GuiUtil.getBorder(MessageLog.getMessageNoID("STG5010L", this.objectName)));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getOptionPanel(), "North");
        this.table = new MegaTable();
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setMouseListener(new HandleSelect());
        this.dataModel = this.getDataModel();
        this.table.setBaseTableModel(this.dataModel);
        this.add((Component)this.table, "Center");
        this.addListeners();
    }

    public abstract void selectRows(boolean var1);

    private JPanel getOptionPanel() {
        GridBagConstraints gbcFirst = new GridBagConstraints();
        GridBagConstraints gbcPlop = new GridBagConstraints();
        GridBagConstraints gbcEast = new GridBagConstraints();
        GridBagConstraints gbcLast = new GridBagConstraints();
        Insets insetA = new Insets(5, 6, 6, 7);
        Insets insetB = new Insets(5, 0, 6, 20);
        Insets insetC = new Insets(5, 0, 6, 0);
        gbcFirst.anchor = 17;
        gbcFirst.insets = insetA;
        gbcPlop.anchor = 17;
        gbcPlop.insets = insetB;
        gbcEast.anchor = 13;
        gbcEast.insets = insetC;
        gbcLast.gridwidth = 0;
        gbcLast.insets = insetC;
        JPanel optionPanel = GuiUtil.getPanel();
        this.selectButton = new JButton(MessageLog.getMessageNoID("GUI0137L"));
        this.clearButton = new JButton(MessageLog.getMessageNoID("GUI0083L"));
        GuiUtil.setAccessible(this.selectButton, this.selectButton.getText(), this.selectButton.getText());
        GuiUtil.setAccessible(this.clearButton, this.clearButton.getText(), this.clearButton.getText());
        optionPanel.add((Component)this.selectButton, gbcFirst);
        optionPanel.add((Component)this.clearButton, gbcPlop);
        GuiUtil.completePanel(optionPanel);
        return optionPanel;
    }

    private void addListeners() {
        this.selectButton.addActionListener(this);
        this.clearButton.addActionListener(this);
    }

    public abstract void setArray() throws GeneralException;

    protected abstract BaseTableModel getDataModel();

    protected abstract boolean isSelectedRow(int var1);

    protected abstract void setSelectedRow(int var1, boolean var2);

    public abstract boolean selectionChanged();

    private class HandleSelect
    extends TJCTableMouseAdapter {
        private HandleSelect() {
        }

        public boolean select(int viewRow, int viewCol) {
            int targetRow = viewRow;
            int row = ReportingSelectionTable.this.table.getDataRow(viewRow);
            boolean selected = !ReportingSelectionTable.this.isSelectedRow(row);
            int delta = viewRow > ReportingSelectionTable.this.lastClickedRow ? 1 : -1;
            viewRow = ReportingSelectionTable.this.lastClickedRow;
            do {
                row = ReportingSelectionTable.this.table.getDataRow(viewRow += delta);
                ReportingSelectionTable.this.setSelectedRow(row, selected);
                ReportingSelectionTable.this.dataModel.fireTableCellUpdated(row, 0);
            } while (viewRow != targetRow);
            ReportingSelectionTable.this.lastClickedRow = viewRow;
            ReportingSelectionTable.this.lastClickSelected = selected;
            return false;
        }
    }
}

