/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTable;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

class ReportingSelectionTableDialog
implements ActionListener {
    private static final char CANCEL = 'X';
    private static final char OK = 'K';
    public Component mainPanel;
    private JDialog dialog;
    private JButton okButton;
    private JButton cancelButton;
    private ReportingSelectionTable resourceSelector;
    private ReportingSelectionTable userSelector;
    private ReportingSelectionTable[] tables;
    private ReportingSelectionDriver driver;
    private Dimension screenSize;
    private JSplitPane splitPane;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ReportingSelectionTableDialog(ReportingSelectionDriver pDriver, GuiReportReq pGRR, Object[] objectName) {
        this.driver = pDriver;
        this.mainPanel = null;
        Object[] userText = new Object[]{MessageLog.getMessageNoID("STG2019L")};
        boolean usersFirst = false;
        boolean usersLast = false;
        int userType = -1;
        if (pGRR.reportSubtype == 15) {
            if (usersFirst || usersLast) {
                this.userSelector = ReportingSelectionTable.createInstance(this, pGRR, userType, userText);
                this.resourceSelector = ReportingSelectionTable.createInstance(this, pGRR, pGRR.reportSubtype, objectName);
                this.tables = new ReportingSelectionTable[1];
                this.tables[0] = this.userSelector;
                this.mainPanel = this.userSelector;
            }
        } else if (usersFirst || usersLast) {
            int x;
            String resourceLocation;
            String userLocation;
            this.userSelector = ReportingSelectionTable.createInstance(this, pGRR, userType, userText);
            this.resourceSelector = ReportingSelectionTable.createInstance(this, pGRR, pGRR.reportSubtype, objectName);
            this.splitPane = new JSplitPane(0);
            if (usersFirst) {
                userLocation = "top";
                resourceLocation = "bottom";
                x = 0;
            } else {
                userLocation = "bottom";
                resourceLocation = "top";
                x = 1;
            }
            this.splitPane.add((Component)this.resourceSelector, resourceLocation);
            this.splitPane.add((Component)this.userSelector, userLocation);
            this.mainPanel = this.splitPane;
            this.tables = new ReportingSelectionTable[2];
            this.tables[x] = this.userSelector;
            this.tables[1 - x] = this.resourceSelector;
        } else {
            this.splitPane = null;
            this.resourceSelector = ReportingSelectionTable.createInstance(this, pGRR, pGRR.reportSubtype, objectName);
            this.tables = new ReportingSelectionTable[1];
            this.tables[0] = this.resourceSelector;
            this.mainPanel = this.resourceSelector;
        }
        int count = this.tables == null ? 0 : this.tables.length;
        while (count > 0) {
            if (this.tables[--count].objectType != -1) continue;
            this.mainPanel = null;
        }
    }

    public void show() {
        int count = this.tables == null ? 0 : this.tables.length;
        boolean allDone = count != 0;
        boolean error = !allDone;
        for (int i = 0; i < count; ++i) {
            ReportingSelectionTable table = this.tables[i];
            if (table.status < 2) {
                allDone = false;
                switch (table.status) {
                    case 0: {
                        table.submitRequest();
                        break;
                    }
                    case -1: {
                        error = true;
                    }
                }
                continue;
            }
            if (table.status == 3) {
                table.selectRows(true);
                continue;
            }
            table.selectRows(false);
            table.buildPanel();
        }
        if (!allDone) {
            if (error) {
                this.driver.disableRowSelectionTableButton();
            }
        } else {
            if (this.dialog != null) {
                Container pane = this.dialog.getContentPane();
                pane.remove(this.mainPanel);
                this.dialog = null;
            }
            this.makeDialog();
            this.dialog.pack();
            if (this.screenSize == null) {
                this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            }
            int height = 9 * this.screenSize.height / 10;
            if (this.dialog.getHeight() > height) {
                this.dialog.setSize(this.dialog.getWidth(), height);
            } else {
                height = this.dialog.getHeight();
            }
            if (this.splitPane != null) {
                this.splitPane.setDividerLocation(height / 2);
            }
            GuiUtil.centerDialog(this.dialog);
            this.dialog.show();
            this.driver.setSelectionButtonIcon();
        }
    }

    private void makeDialog() {
        String s = MessageLog.getMessageNoID("GUI2083L");
        this.dialog = new JDialog(this.guiMain.getFrame(), s, true);
        Container pane = this.dialog.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 10;
        c.insets.bottom = 10;
        c.insets.left = 10;
        c.insets.right = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 0;
        pane.add(this.mainPanel, c);
        s = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(s);
        this.okButton.setActionCommand(ReportingSelectionDriver.charToString('K'));
        this.okButton.addActionListener(this);
        JPanel subPanel = new JPanel(new GridBagLayout());
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.insets.left = 0;
        c.insets.right = 5;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 0;
        subPanel.add((Component)this.okButton, c);
        s = MessageLog.getMessageNoID("GUI0114L");
        this.cancelButton = new JButton(s);
        s = ReportingSelectionDriver.charToString('X');
        this.cancelButton.setActionCommand(s);
        this.cancelButton.addActionListener(this);
        c.gridwidth = 0;
        c.insets.right = 0;
        subPanel.add((Component)this.cancelButton, c);
        c.insets.bottom = 10;
        pane.add((Component)subPanel, c);
    }

    public void actionPerformed(ActionEvent event) {
        boolean dispose = true;
        char c = event.getActionCommand().charAt(0);
        if (c == 'K') {
            try {
                for (int i = 0; i < this.tables.length; ++i) {
                    this.tables[i].setArray();
                }
            }
            catch (GeneralException e) {
                GuiUtil.displayException(e);
                dispose = false;
            }
        }
        if (dispose) {
            this.dialog.dispose();
        }
    }

    public boolean selectionChanged() {
        return this.resourceSelector.selectionChanged();
    }

    public ReportingSelectionDriver getDriver() {
        return this.driver;
    }
}

