/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.TStorm.gui.SavedReportNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.ExportTableData;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingTableDDI
extends SavedReportDDI
implements ActionListener,
GuiRequestor,
ObjectChangeListener {
    private JComponent centerPanel;
    private byte productCode;
    private boolean productAvailable = true;
    private boolean saveEnabled;
    private boolean changeListening;
    private boolean saveAs;
    private boolean showing;

    public ReportingTableDDI(GuiSavedReportReq gsrr, BaseTreeNode treeNodeIn) {
        this(gsrr.grr, treeNodeIn, gsrr.creator + "." + gsrr.getName());
        this.gsrr = gsrr;
    }

    public ReportingTableDDI(GuiReportReq grr, BaseTreeNode treeNodeIn) {
        this(grr, treeNodeIn, (GuiReportReq.guiClasses[grr.reportType][2] == GuiReportReq.subtypeTreeLabels[grr.reportSubtype][0] ? "" : MessageLog.getMessageNoID(GuiReportReq.guiClasses[grr.reportType][2]) + Util.getString("COLON")) + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[grr.reportSubtype][0]));
    }

    public ReportingTableDDI(GuiReportReq grrIn, BaseTreeNode treeNodeIn, String descriptionIn) {
        super(descriptionIn);
        this.treeNode = treeNodeIn;
        this.grr = grrIn;
        this.productAvailable = true;
        this.productCode = ((ReportingTreeNode)this.treeNode).productCode;
        this.displayInScrollPane = false;
        this.helpID = GuiReportReq.guiClasses[this.grr.reportType][4];
        this.reDisplay();
    }

    public void reDisplay() {
        if (this.panel == null) {
            try {
                Object[] args;
                Constructor<?> constr;
                Class<?> rClass = Class.forName(GuiReportReq.guiClasses[this.grr.reportType][0]);
                Class[] argdef2 = new Class[]{GuiReportReq.class, DataDisplayInfo.class};
                try {
                    constr = rClass.getConstructor(argdef2);
                    args = new Object[2];
                    args[1] = this;
                }
                catch (NoSuchMethodException e) {
                    Class[] argdef1 = new Class[]{GuiReportReq.class};
                    constr = rClass.getConstructor(argdef1);
                    args = new Object[]{this.grr};
                }
                this.centerPanel = (JComponent)constr.newInstance(args);
                this.panel = new JPanel();
                this.panel.setLayout(new BorderLayout());
                JPopupMenu popup = this.treeNode.getPopupMenuForButtons();
                JPanel buttonPanel = this.getButtonPanel(popup);
                if (this.getActionButtonCount() > 0) {
                    this.panel.add((Component)buttonPanel, "North");
                }
                this.panel.add((Component)this.centerPanel, "Center");
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace();
            }
        }
        this.showing = true;
        this.show();
        this.showing = false;
        if (!this.saveEnabled) {
            this.saveEnabled = true;
            guiMain.setSaveActionEnabled(true, true);
            guiMain.setSaveAsActionEnabled(true, true);
            guiMain.setPrintActionEnabled(true, true);
            guiMain.setExportActionEnabled(true, true);
            guiMain.setSaveActionToolTip(MessageLog.getMessageNoID("GUI5066T"));
            guiMain.setSaveAsActionToolTip(MessageLog.getMessageNoID("GUI5067T"));
            guiMain.setExportActionToolTip(MessageLog.getMessageNoID("GUI5068T"));
            guiMain.addSaveActionListener(this);
            guiMain.addSaveAsActionListener(this);
            guiMain.addExportActionListener(this);
            guiMain.addPrintActionListener(this);
        }
        if (!this.changeListening) {
            this.changeListening = true;
            ChangeManager.addListener(this, (short)35);
        }
    }

    public void losingFocus() {
        if (!this.showing && this.saveEnabled) {
            this.saveEnabled = false;
            guiMain.setSaveActionEnabled(false, false);
            guiMain.setSaveAsActionEnabled(false, false);
            guiMain.setPrintActionEnabled(false, false);
            guiMain.setExportActionEnabled(false, false);
            guiMain.setSaveActionToolTip(null);
            guiMain.setSaveAsActionToolTip(null);
            guiMain.setExportActionToolTip(null);
            guiMain.removeSaveActionListener(this);
            guiMain.removeSaveAsActionListener(this);
            guiMain.removeExportActionListener(this);
            guiMain.removePrintActionListener(this);
        }
    }

    public void goingAway() {
        if (this.changeListening) {
            ChangeManager.removeListener(this);
        }
    }

    public JComponent getNoDataMessage(GuiReportReq grr) {
        JLabel noDataLabel = new JLabel();
        if (grr != null && (grr.reportSubtype == 24 || grr.reportSubtype == 23)) {
            noDataLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else if (this.gsrr != null && (this.gsrr.grr.reportSubtype == 24 || this.gsrr.grr.reportSubtype == 23)) {
            noDataLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else {
            noDataLabel.setText(MessageLog.getMessageNoID("STG0020M"));
        }
        noDataLabel.setHorizontalAlignment(0);
        return noDataLabel;
    }

    public void actionPerformed(ActionEvent event) {
        String source = event.getActionCommand();
        if (source == "Save") {
            this.saveAs = false;
            this.save();
        } else if (source == "SaveAs") {
            this.saveAs = true;
            this.save();
        } else if (source == "Export") {
            ExportTableData.export(this.centerPanel, null, this.getDescription());
        }
    }

    private void save() {
        GuiSavedReportReq newGsrr = new GuiSavedReportReq();
        if (this.gsrr == null || this.gsrr.ID <= 299) {
            this.saveAs = true;
            newGsrr.creator = GuiUtil.getUserName();
            newGsrr.grr = this.grr;
        } else {
            newGsrr.creator = this.gsrr.creator;
            newGsrr.setName(this.gsrr.getTrueName());
            newGsrr.ID = this.gsrr.ID;
            newGsrr.grr = this.gsrr.grr;
        }
        newGsrr.productCode = this.productCode;
        if (this.saveAs) {
            newGsrr.ID = -1;
            String title = MessageLog.getMessageNoID("GUI5007L");
            String prompt = MessageLog.getMessageNoID("GUI5011L", "report");
            boolean going = true;
            while (going) {
                newGsrr.setName(GuiUtil.displayOkCancelPane(title, prompt, 32, false, null, guiMain.getFrame()));
                going = newGsrr.getName() != null && !newGsrr.getName().equals("") && newGsrr.getName().indexOf(46) >= 0;
                if (!going) continue;
                String s = MessageLog.getMessageNoTS("GUI0056E", null);
                GuiUtil.displayErrorMessage(s);
            }
        }
        if (newGsrr.getName() != null && !newGsrr.getName().equals("")) {
            SavedReportNode.doRequest(this, newGsrr);
        }
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4 && response.responseData != null) {
            this.gsrr = (GuiSavedReportReq)response.responseData;
            this.changeDescription();
            NameList element = new NameList();
            element.nlInfo = (short)35;
            element.nlName = this.gsrr.getName();
            element.nlID = this.gsrr.ID;
            ChangeManager.signalChange(1, element);
        }
    }

    public void changeOccurred(int changeType, NameList element) {
        if (changeType == 0 && this.gsrr != null && element.nlID == this.gsrr.ID) {
            this.gsrr.setName(element.nlName);
            this.changeDescription();
        }
    }

    private void changeDescription() {
        this.setDescription(this.gsrr.creator + "." + this.gsrr.getName());
        if (ReportingTableDDI.getCurrent() == this) {
            this.showing = true;
            this.show();
            this.showing = false;
        }
    }
}

