/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingTableDDI;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.UnTabbedReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingTreeNode
extends BaseTreeNode {
    protected int reportType;
    protected int reportSubtype;
    protected int selectionServices;
    public static final int NO_TABS = -2;
    public static final int NO_SELECTION = -1;
    public static final int ALL_SERVICES = 0;
    public static final int NO_ROW_LIMIT = 1;
    public static final int TIME_RANGE = 2;
    public static final int DISK_ARRAY = 3;
    public static final int SYSTEM_WIDE = 4;
    public byte productCode;
    public byte dbmsType;

    protected ReportingTreeNode() {
    }

    public ReportingTreeNode(int reportType, int reportSubtype, int sortNumber) {
        this(reportType, reportSubtype, 0, sortNumber, 1);
    }

    public ReportingTreeNode(int reportType, int reportSubtype, int sortNumber, byte productCode) {
        this(reportType, reportSubtype, 0, sortNumber, productCode);
    }

    public ReportingTreeNode(int reportType, int reportSubtype, int sortNumber, byte productCode, byte dbmsType) {
        this(reportType, reportSubtype, sortNumber, productCode);
        this.dbmsType = dbmsType;
    }

    public ReportingTreeNode(int reportType, int reportSubtype, int selectionServices, int sortNumber) {
        this(reportType, reportSubtype, selectionServices, sortNumber, 1);
    }

    public ReportingTreeNode(int reportType, int reportSubtype, int selectionServices, int sortNumber, byte productCode) {
        super(MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[reportSubtype][0]), false);
        this.reportType = reportType;
        this.reportSubtype = reportSubtype;
        this.selectionServices = selectionServices;
        if (selectionServices != -2) {
            ReportingTreeLabel.selectionServiceArray[reportType] = selectionServices;
        }
        this.batchSortNumber = sortNumber;
        this.productCode = productCode;
    }

    public ReportingTreeNode(int reportType, int reportSubtype, int selectionServices, int sortNumber, byte productCode, byte dbmsType) {
        this(reportType, reportSubtype, selectionServices, sortNumber, productCode);
        this.dbmsType = dbmsType;
    }

    public void select(TreeSelectionEvent event) {
        GuiReportReq grr = new GuiReportReq();
        grr.reportType = this.reportType;
        grr.reportSubtype = this.reportSubtype;
        grr.rowsToReturn = Integer.MAX_VALUE;
        grr.productCode = this.productCode;
        grr.dbmsType = this.dbmsType;
        if (this.selectionServices == -1) {
            new ReportingTableDDI(grr, (BaseTreeNode)this);
        } else if (this.selectionServices == -2) {
            new UnTabbedReportingDDI(grr, this).reDisplay();
        } else {
            new ReportingDDI(grr, (BaseTreeNode)this).reDisplay();
        }
    }
}

